/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.files;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.common.Artifact;
import org.jreleaser.model.api.common.Glob;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.util.Env;

public final class Files
extends AbstractModelObject<Files>
implements Domain,
Activatable {
    private final Set<org.jreleaser.model.internal.common.Artifact> artifacts = new LinkedHashSet<org.jreleaser.model.internal.common.Artifact>();
    private final List<org.jreleaser.model.internal.common.Glob> globs = new ArrayList<org.jreleaser.model.internal.common.Glob>();
    @JsonIgnore
    private final Set<org.jreleaser.model.internal.common.Artifact> paths = new LinkedHashSet<org.jreleaser.model.internal.common.Artifact>();
    @JsonIgnore
    private boolean resolved;
    private Active active;
    @JsonIgnore
    private boolean enabled;
    private final org.jreleaser.model.api.files.Files immutable = new org.jreleaser.model.api.files.Files(){
        private Set<? extends Artifact> paths;
        private Set<? extends Artifact> artifacts;
        private List<? extends Glob> globs;

        public Set<? extends Artifact> getPaths() {
            if (null == this.paths) {
                this.paths = Files.this.paths.stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.paths;
        }

        public Set<? extends Artifact> getArtifacts() {
            if (null == this.artifacts) {
                this.artifacts = Files.this.artifacts.stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.artifacts;
        }

        public List<? extends Glob> getGlobs() {
            if (null == this.globs) {
                this.globs = Files.this.globs.stream().map(org.jreleaser.model.internal.common.Glob::asImmutable).collect(Collectors.toList());
            }
            return this.globs;
        }

        public Active getActive() {
            return Files.this.active;
        }

        public boolean isEnabled() {
            return Files.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Files.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.files.Files asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Files source) {
        this.active = this.merge(this.active, source.active);
        this.enabled = this.merge(this.enabled, source.enabled);
        this.setArtifacts(this.merge(this.artifacts, source.artifacts));
        this.setGlobs(this.merge(this.globs, source.globs));
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"files.active", (String)"", (String)"NEVER"));
        }
        this.enabled = this.active.check((Active.Releaseable)project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of((String)str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public boolean isEmpty() {
        return this.artifacts.isEmpty() && this.globs.isEmpty();
    }

    public boolean arePathsResolved() {
        return this.resolved;
    }

    public Set<org.jreleaser.model.internal.common.Artifact> getPaths() {
        return org.jreleaser.model.internal.common.Artifact.sortArtifacts(this.paths);
    }

    public void setPaths(Set<org.jreleaser.model.internal.common.Artifact> paths) {
        this.paths.clear();
        this.paths.addAll(paths);
        this.resolved = true;
    }

    public Set<org.jreleaser.model.internal.common.Artifact> getArtifacts() {
        return org.jreleaser.model.internal.common.Artifact.sortArtifacts(this.artifacts);
    }

    public void setArtifacts(Set<org.jreleaser.model.internal.common.Artifact> artifacts) {
        this.artifacts.clear();
        this.artifacts.addAll(artifacts);
    }

    public void addArtifacts(Set<org.jreleaser.model.internal.common.Artifact> artifacts) {
        this.artifacts.addAll(artifacts);
    }

    public void addArtifact(org.jreleaser.model.internal.common.Artifact artifact) {
        if (null != artifact) {
            this.artifacts.add(artifact);
        }
    }

    public List<org.jreleaser.model.internal.common.Glob> getGlobs() {
        return this.globs;
    }

    public void setGlobs(List<org.jreleaser.model.internal.common.Glob> globs) {
        this.globs.clear();
        this.globs.addAll(globs);
    }

    public void addGlobs(List<org.jreleaser.model.internal.common.Glob> globs) {
        this.globs.addAll(globs);
    }

    public void addGlob(org.jreleaser.model.internal.common.Glob glob) {
        if (null != glob) {
            this.globs.add(glob);
        }
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        if (!full && !this.isEnabled()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", this.active);
        LinkedHashMap<String, Map<String, Object>> mappedArtifacts = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (org.jreleaser.model.internal.common.Artifact artifact : this.getArtifacts()) {
            mappedArtifacts.put("artifact " + i++, artifact.asMap(full));
        }
        map.put("artifacts", mappedArtifacts);
        LinkedHashMap<String, Map<String, Object>> mappedGlobs = new LinkedHashMap<String, Map<String, Object>>();
        for (i = 0; i < this.globs.size(); ++i) {
            mappedGlobs.put("glob " + i, this.globs.get(i).asMap(full));
        }
        map.put("globs", mappedGlobs);
        return map;
    }
}

