/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class SlackAnnouncer
extends AbstractAnnouncer<SlackAnnouncer, org.jreleaser.model.api.announce.SlackAnnouncer> {
    private String token;
    private String webhook;
    private String channel;
    private String message;
    private String messageTemplate;
    private final org.jreleaser.model.api.announce.SlackAnnouncer immutable = new org.jreleaser.model.api.announce.SlackAnnouncer(){

        public String getType() {
            return "slack";
        }

        public String getToken() {
            return SlackAnnouncer.this.token;
        }

        public String getWebhook() {
            return SlackAnnouncer.this.webhook;
        }

        public String getChannel() {
            return SlackAnnouncer.this.channel;
        }

        public String getMessage() {
            return SlackAnnouncer.this.message;
        }

        public String getMessageTemplate() {
            return SlackAnnouncer.this.messageTemplate;
        }

        public String getName() {
            return SlackAnnouncer.this.name;
        }

        public boolean isSnapshotSupported() {
            return SlackAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return SlackAnnouncer.this.active;
        }

        public boolean isEnabled() {
            return SlackAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(SlackAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return SlackAnnouncer.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(SlackAnnouncer.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return SlackAnnouncer.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return SlackAnnouncer.this.readTimeout;
        }
    };

    public SlackAnnouncer() {
        super("slack");
    }

    @Override
    public org.jreleaser.model.api.announce.SlackAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(SlackAnnouncer source) {
        super.merge(source);
        this.token = this.merge(this.token, source.token);
        this.channel = this.merge(this.channel, source.channel);
        this.webhook = this.merge(this.webhook, source.webhook);
        this.message = this.merge(this.message, source.message);
        this.messageTemplate = this.merge(this.messageTemplate, source.messageTemplate);
    }

    public String getResolvedMessage(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        return Templates.resolveTemplate((String)this.message, props);
    }

    public String getResolvedMessageTemplate(JReleaserContext context, Map<String, Object> extraProps) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        props.put("tagName", context.getModel().getRelease().getReleaser().getEffectiveTagName(context.getModel()));
        props.putAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.messageTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((Reader)reader, props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getResolvedToken() {
        return Env.env((String)"SLACK_TOKEN", (String)this.token);
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getResolvedWebhook() {
        return Env.env((String)"SLACK_WEBHOOK", (String)this.webhook);
    }

    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("webhook", StringUtils.isNotBlank((String)this.getResolvedWebhook()) ? "************" : "**unset**");
        props.put("token", StringUtils.isNotBlank((String)this.getResolvedToken()) ? "************" : "**unset**");
        props.put("channel", this.channel);
        props.put("message", this.message);
        props.put("messageTemplate", this.messageTemplate);
    }
}

