/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import java.util.Collections;
import java.util.Map;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class MastodonAnnouncer
extends AbstractAnnouncer<MastodonAnnouncer, org.jreleaser.model.api.announce.MastodonAnnouncer> {
    private String host;
    private String accessToken;
    private String status;
    private final org.jreleaser.model.api.announce.MastodonAnnouncer immutable = new org.jreleaser.model.api.announce.MastodonAnnouncer(){

        public String getType() {
            return "mastodon";
        }

        public String getHost() {
            return MastodonAnnouncer.this.host;
        }

        public String getAccessToken() {
            return MastodonAnnouncer.this.accessToken;
        }

        public String getStatus() {
            return MastodonAnnouncer.this.status;
        }

        public String getName() {
            return MastodonAnnouncer.this.name;
        }

        public boolean isSnapshotSupported() {
            return MastodonAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return MastodonAnnouncer.this.active;
        }

        public boolean isEnabled() {
            return MastodonAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(MastodonAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return MastodonAnnouncer.this.getPrefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(MastodonAnnouncer.this.extraProperties);
        }

        public Integer getConnectTimeout() {
            return MastodonAnnouncer.this.connectTimeout;
        }

        public Integer getReadTimeout() {
            return MastodonAnnouncer.this.readTimeout;
        }
    };

    public MastodonAnnouncer() {
        super("mastodon");
    }

    @Override
    public org.jreleaser.model.api.announce.MastodonAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(MastodonAnnouncer source) {
        super.merge(source);
        this.host = this.merge(this.host, source.host);
        this.accessToken = this.merge(this.accessToken, source.accessToken);
        this.status = this.merge(this.status, source.status);
    }

    public String getResolvedStatus(JReleaserContext context) {
        Map<String, Object> props = context.fullProps();
        MustacheUtils.applyTemplates(props, this.getResolvedExtraProperties());
        context.getModel().getRelease().getReleaser().fillProps(props, context.getModel());
        return Templates.resolveTemplate((String)this.status, props);
    }

    public String getResolvedAccessToken() {
        return Env.env((String)"MASTODON_ACCESS_TOKEN", (String)this.accessToken);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("host", this.host);
        props.put("accessToken", StringUtils.isNotBlank((String)this.getResolvedAccessToken()) ? "************" : "**unset**");
        props.put("status", this.status);
    }
}

