/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2020-2024 The JReleaser authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jreleaser.model.spi.upload;

import org.jreleaser.model.internal.upload.Uploader;

/**
 * @author Andres Almiray
 * @since 0.3.0
 */
public interface ArtifactUploader<A extends org.jreleaser.model.api.upload.Uploader, U extends Uploader<A>> {
    U getUploader();

    void setUploader(U uploader);

    String getType();

    void upload(String name) throws UploadException;
}
