/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2020-2024 The JReleaser authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jreleaser.model.spi.packagers;

import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.Packager;
import org.jreleaser.mustache.TemplateContext;

/**
 * @author Andres Almiray
 * @since 0.1.0
 */
public interface PackagerProcessor<T extends Packager> {
    T getPackager();

    void setPackager(T packager);

    String getPackagerName();

    boolean supportsDistribution(Distribution distribution);

    void prepareDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException;

    void packageDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException;

    void publishDistribution(Distribution distribution, TemplateContext props) throws PackagerProcessingException;
}
