/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * Copyright 2020-2024 The JReleaser authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jreleaser.model.spi.assemble;

import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.mustache.TemplateContext;

/**
 * @author Andres Almiray
 * @since 0.2.0
 */
public interface AssemblerProcessor<A extends org.jreleaser.model.api.assemble.Assembler, S extends Assembler<A>> {
    S getAssembler();

    void setAssembler(S assembler);

    void assemble(TemplateContext props) throws AssemblerProcessingException;
}
