/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.GpgObjectSigner;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.releaser.spi.Commit;
import org.jreleaser.model.releaser.spi.Repository;
import org.jreleaser.sdk.git.JReleaserGpgSigner;

public class GitSdk {
    public static final String REFS_TAGS = "refs/tags/";
    public static final String REFS_HEADS = "refs/heads/";
    private final File basedir;

    private GitSdk(File basedir) {
        this.basedir = basedir;
    }

    public Git open() throws IOException {
        return Git.open((File)this.basedir);
    }

    public Repository getRemote() throws IOException {
        Git git = this.open();
        try {
            RemoteConfig remoteConfig = git.remoteList().call().stream().filter(rc -> "origin".equals(rc.getName())).findFirst().orElseThrow(() -> new IOException("repository doesn't have an 'origin' remote"));
            List uris = remoteConfig.getURIs();
            if (uris.isEmpty()) {
                throw new IOException("'origin' remote does not have a configured URL");
            }
            URIish uri = (URIish)uris.get(0);
            Repository.Kind kind = Repository.Kind.OTHER;
            switch (uri.getHost()) {
                case "github.com": {
                    kind = Repository.Kind.GITHUB;
                    break;
                }
                case "gitlab.com": {
                    kind = Repository.Kind.GITLAB;
                    break;
                }
                case "codeberg.org": {
                    kind = Repository.Kind.CODEBERG;
                }
            }
            String[] parts = uri.getPath().split("/");
            if (parts.length < 2) {
                throw new IOException("Unparseable remote URL " + uri.getPath());
            }
            String owner = parts[parts.length - 2];
            String name = parts[parts.length - 1].replace(".git", "");
            return new Repository(kind, owner, name, null, uri.toString());
        }
        catch (GitAPIException e) {
            throw new IOException("Could not determine 'origin' remote", e);
        }
    }

    public Commit head() throws IOException {
        Git git = this.open();
        RevWalk walk = new RevWalk(git.getRepository());
        ObjectId head = git.getRepository().resolve("HEAD");
        RevCommit commit = walk.parseCommit((AnyObjectId)head);
        Ref ref = git.getRepository().findRef("HEAD");
        return new Commit(commit.getId().abbreviate(7).name(), commit.getId().name(), GitSdk.extractHeadName(ref));
    }

    public void deleteTag(String tagName) throws IOException {
        Git git = this.open();
        try {
            git.tagDelete().setTags(new String[]{tagName}).call();
        }
        catch (GitAPIException e) {
            throw new IOException("Could not delete tag " + tagName, e);
        }
    }

    public boolean findTag(String tagName) throws IOException {
        Git git = this.open();
        try {
            return git.tagList().call().stream().map(GitSdk::extractTagName).anyMatch(tagName::matches);
        }
        catch (GitAPIException e) {
            throw new IOException("Could not find tag " + tagName, e);
        }
    }

    public void tag(String tagName, JReleaserContext context) throws IOException {
        this.tag(tagName, false, context);
    }

    public void tag(String tagName, boolean force, JReleaserContext context) throws IOException {
        Git git = this.open();
        try {
            boolean signEnabled = context.getModel().getRelease().getGitService().isSign();
            git.tag().setSigned(signEnabled).setSigningKey("**********").setGpgSigner((GpgObjectSigner)new JReleaserGpgSigner(context, signEnabled)).setName(tagName).setForceUpdate(force).call();
        }
        catch (GitAPIException e) {
            throw new IOException("Could not create tag " + tagName, e);
        }
    }

    public static GitSdk of(JReleaserContext context) {
        return new GitSdk(context.getBasedir().toFile());
    }

    public static GitSdk of(Path basedir) {
        return new GitSdk(basedir.toFile());
    }

    public static GitSdk of(File basedir) {
        return new GitSdk(basedir);
    }

    public static Commit head(Path basedir) throws IOException {
        Git git = Git.open((File)basedir.toFile());
        RevWalk walk = new RevWalk(git.getRepository());
        ObjectId head = git.getRepository().resolve("HEAD");
        RevCommit commit = walk.parseCommit((AnyObjectId)head);
        Ref ref = git.getRepository().findRef("HEAD");
        return new Commit(commit.getId().abbreviate(7).name(), commit.getId().name(), GitSdk.extractHeadName(ref));
    }

    public static String extractTagName(Ref tag) {
        if (tag.getName().startsWith(REFS_TAGS)) {
            return tag.getName().substring(REFS_TAGS.length());
        }
        return "";
    }

    public static String extractHeadName(Ref ref) {
        if (ref.getTarget().getName().startsWith(REFS_HEADS)) {
            return ref.getTarget().getName().substring(REFS_HEADS.length());
        }
        return "";
    }

    public static class TagComparator
    implements Comparator<Ref> {
        @Override
        public int compare(Ref tag1, Ref tag2) {
            String tagName1 = GitSdk.extractTagName(tag1);
            String tagName2 = GitSdk.extractTagName(tag2);
            return tagName1.compareTo(tagName2);
        }
    }
}

