/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jreleaser.model.Changelog;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.sdk.git.GitSdk;
import org.jreleaser.util.Version;

public class ChangelogGenerator {
    public static String generate(JReleaserContext context) throws IOException {
        if (!context.getModel().getRelease().getGitService().getChangelog().isEnabled()) {
            return "";
        }
        return ChangelogGenerator.createChangelog(context);
    }

    private static String createChangelog(JReleaserContext context) throws IOException {
        GitService gitService = context.getModel().getRelease().getGitService();
        Changelog changelog = gitService.getChangelog();
        String commitsUrl = gitService.getResolvedCommitUrl(context.getModel());
        String separator = System.lineSeparator();
        if ("gitlab".equals(gitService.getServiceName())) {
            separator = separator + System.lineSeparator();
        }
        String commitSeparator = separator;
        try {
            Git git = GitSdk.of(context).open();
            context.getLogger().debug("resolving commits");
            Iterable<RevCommit> commits = ChangelogGenerator.resolveCommits(git, context);
            Comparator<RevCommit> revCommitComparator = Comparator.comparing(RevCommit::getCommitTime).reversed();
            if (changelog.getSort() == Changelog.Sort.ASC) {
                revCommitComparator = Comparator.comparing(RevCommit::getCommitTime);
            }
            context.getLogger().debug("sorting commits {}", new Object[]{changelog.getSort()});
            return "## Changelog" + System.lineSeparator() + System.lineSeparator() + StreamSupport.stream(commits.spliterator(), false).sorted(revCommitComparator).map(commit -> ChangelogGenerator.formatCommit(commit, commitsUrl, changelog, commitSeparator)).collect(Collectors.joining(commitSeparator));
        }
        catch (GitAPIException e) {
            throw new IOException(e);
        }
    }

    private static String formatCommit(RevCommit commit, String commitsUrl, Changelog changelog, String commitSeparator) {
        String commitHash = commit.getId().name();
        String abbreviation = commit.getId().abbreviate(7).name();
        String[] input = commit.getFullMessage().trim().split(System.lineSeparator());
        ArrayList<String> lines = new ArrayList<String>();
        if (changelog.isLinks()) {
            lines.add("[" + abbreviation + "](" + commitsUrl + "/" + commitHash + ") " + input[0].trim());
        } else {
            lines.add(abbreviation + " " + input[0].trim());
        }
        return String.join((CharSequence)commitSeparator, lines);
    }

    private static Version versionOf(Ref tag, Pattern versionPattern) {
        Matcher matcher = versionPattern.matcher(GitSdk.extractTagName(tag));
        if (matcher.matches()) {
            return Version.of((String)matcher.group(1));
        }
        return Version.of((String)"0.0.0");
    }

    private static Iterable<RevCommit> resolveCommits(Git git, JReleaserContext context) throws GitAPIException, IOException {
        List tags = git.tagList().call();
        GitService gitService = context.getModel().getRelease().getGitService();
        String effectiveTagName = gitService.getEffectiveTagName(context.getModel());
        String tagName = gitService.getConfiguredTagName();
        String tagPattern = tagName.replaceAll("\\{\\{.*}}", "\\.\\*");
        Pattern versionPattern = Pattern.compile(tagName.replaceAll("\\{\\{.*}}", "\\(\\.\\*\\)"));
        tags.sort((tag1, tag2) -> {
            Version v1 = ChangelogGenerator.versionOf(tag1, versionPattern);
            Version v2 = ChangelogGenerator.versionOf(tag2, versionPattern);
            return v2.compareTo(v1);
        });
        Optional<Object> tag = Optional.empty();
        if ("early-access".equals(effectiveTagName)) {
            context.getLogger().debug("looking for tags that match '{}'", new Object[]{effectiveTagName});
            tag = tags.stream().filter(ref -> GitSdk.extractTagName(ref).equals(effectiveTagName)).findFirst();
        }
        if (!tag.isPresent()) {
            context.getLogger().debug("looking for tags that match '{}', excluding '{}'", new Object[]{tagPattern, effectiveTagName});
            tag = tags.stream().filter(ref -> !GitSdk.extractTagName(ref).equals(effectiveTagName)).filter(ref -> GitSdk.extractTagName(ref).matches(tagPattern)).findFirst();
        }
        ObjectId head = git.getRepository().resolve("HEAD");
        if (tag.isPresent()) {
            context.getLogger().debug("found tag {}", new Object[]{GitSdk.extractTagName((Ref)tag.get())});
            Ref peeled = git.getRepository().getRefDatabase().peel((Ref)tag.get());
            ObjectId fromRef = peeled.getPeeledObjectId() != null ? peeled.getPeeledObjectId() : peeled.getObjectId();
            return git.log().addRange((AnyObjectId)fromRef, (AnyObjectId)head).call();
        }
        return git.log().add((AnyObjectId)head).call();
    }
}

