/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.UnsupportedSigningFormatException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.GpgObjectSigner;
import org.eclipse.jgit.lib.GpgSignature;
import org.eclipse.jgit.lib.GpgSigner;
import org.eclipse.jgit.lib.ObjectBuilder;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Signing;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.signing.InMemoryKeyring;
import org.jreleaser.util.signing.SigningException;

public class InMemoryGpgSigner
extends GpgSigner
implements GpgObjectSigner {
    private final JReleaserContext context;

    public InMemoryGpgSigner(JReleaserContext context) {
        this.context = context;
    }

    public boolean canLocateSigningKey(String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider, GpgConfig config) throws CanceledException, UnsupportedSigningFormatException {
        return this.context.getModel().getSigning().isEnabled();
    }

    public boolean canLocateSigningKey(String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        return this.context.getModel().getSigning().isEnabled();
    }

    public void sign(CommitBuilder commit, String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider) throws CanceledException {
        try {
            this.signObject((ObjectBuilder)commit, gpgSigningKey, committer, credentialsProvider, null);
        }
        catch (UnsupportedSigningFormatException unsupportedSigningFormatException) {
            // empty catch block
        }
    }

    public void signObject(ObjectBuilder object, String gpgSigningKey, PersonIdent committer, CredentialsProvider credentialsProvider, GpgConfig config) throws CanceledException, UnsupportedSigningFormatException {
        try {
            InMemoryKeyring keyring = this.createInMemoryKeyring(this.context.getModel().getSigning());
            PGPSignatureGenerator signatureGenerator = this.initSignatureGenerator(this.context.getModel().getSigning(), keyring);
            this.adjustCommiterId(signatureGenerator, committer, keyring);
            this.signObject(signatureGenerator, object);
        }
        catch (SigningException e) {
            throw new JGitInternalException(e.getMessage(), (Throwable)e);
        }
    }

    private InMemoryKeyring createInMemoryKeyring(Signing sign) throws SigningException {
        try {
            InMemoryKeyring keyring = new InMemoryKeyring();
            keyring.addPublicKey(sign.getResolvedPublicKey().getBytes());
            keyring.addSecretKey(sign.getResolvedSecretKey().getBytes());
            return keyring;
        }
        catch (IOException | PGPException e) {
            throw new SigningException("Could not initialize keyring", e);
        }
    }

    private PGPSignatureGenerator initSignatureGenerator(Signing signing, InMemoryKeyring keyring) throws SigningException {
        try {
            PGPSecretKey secretKey = keyring.getSecretKey();
            PGPPrivateKey privateKey = secretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(signing.getResolvedPassphrase().toCharArray()));
            PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(secretKey.getPublicKey().getAlgorithm(), 8).setProvider("BC"));
            signatureGenerator.init(0, privateKey);
            return signatureGenerator;
        }
        catch (PGPException e) {
            throw new SigningException("Unexpected error when initializing signature generator", (Throwable)e);
        }
    }

    private void adjustCommiterId(PGPSignatureGenerator signatureGenerator, PersonIdent committer, InMemoryKeyring keyring) throws SigningException {
        String keyUserId;
        PGPPublicKey publicKey = keyring.readPublicKey();
        PGPSignatureSubpacketGenerator subpackets = new PGPSignatureSubpacketGenerator();
        subpackets.setIssuerFingerprint(false, publicKey);
        String userId = committer.getEmailAddress();
        Iterator userIds = publicKey.getUserIDs();
        if (userIds.hasNext() && StringUtils.isNotBlank((String)(keyUserId = (String)userIds.next())) && (StringUtils.isBlank((String)userId) || !keyUserId.contains(userId))) {
            userId = this.extractSignerId(keyUserId);
        }
        if (StringUtils.isNotBlank((String)userId)) {
            subpackets.addSignerUserID(false, userId);
        }
        signatureGenerator.setHashedSubpackets(subpackets.generate());
    }

    private String extractSignerId(String pgpUserId) {
        int to;
        int from = pgpUserId.indexOf(60);
        if (from >= 0 && (to = pgpUserId.indexOf(62, from + 1)) > from + 1) {
            return pgpUserId.substring(from + 1, to);
        }
        return pgpUserId;
    }

    private void signObject(PGPSignatureGenerator signatureGenerator, ObjectBuilder object) throws SigningException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try (BCPGOutputStream out = new BCPGOutputStream((OutputStream)new ArmoredOutputStream((OutputStream)buffer));){
                signatureGenerator.update(object.build());
                signatureGenerator.generate().encode((OutputStream)out);
            }
            object.setGpgSignature(new GpgSignature(buffer.toByteArray()));
        }
        catch (IOException | PGPException e) {
            throw new SigningException(e.getMessage(), e);
        }
    }

    static {
        Security.removeProvider("BC");
        Security.setProperty("crypto.policy", "unlimited");
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

