/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.releaser.spi.Commit;

public class GitSdk {
    public static final String REFS_TAGS = "refs/tags/";
    private final JReleaserContext context;

    private GitSdk(JReleaserContext context) {
        this.context = context;
    }

    public Git open() throws IOException {
        return Git.open((File)this.context.getBasedir().toFile());
    }

    public Commit head() throws IOException {
        Git git = this.open();
        RevWalk walk = new RevWalk(git.getRepository());
        ObjectId head = git.getRepository().resolve("HEAD");
        RevCommit commit = walk.parseCommit((AnyObjectId)head);
        return new Commit(commit.getId().abbreviate(7).name(), commit.getId().name());
    }

    public void deleteTag(String tagName) throws IOException {
        Git git = this.open();
        try {
            git.tagDelete().setTags(new String[]{tagName}).call();
        }
        catch (GitAPIException e) {
            throw new IOException("Could not delete tag " + tagName, e);
        }
    }

    public void tag(String tagName) throws IOException {
        this.tag(tagName, false);
    }

    public void tag(String tagName, boolean force) throws IOException {
        Git git = this.open();
        try {
            git.tag().setName(tagName).setForceUpdate(force).call();
        }
        catch (GitAPIException e) {
            throw new IOException("Could not create tag " + tagName, e);
        }
    }

    public static GitSdk of(JReleaserContext context) {
        return new GitSdk(context);
    }

    public static Commit head(Path basedir) throws IOException {
        Git git = Git.open((File)basedir.toFile());
        RevWalk walk = new RevWalk(git.getRepository());
        ObjectId head = git.getRepository().resolve("HEAD");
        RevCommit commit = walk.parseCommit((AnyObjectId)head);
        return new Commit(commit.getId().abbreviate(7).name(), commit.getId().name());
    }

    public static String extractTagName(Ref tag) {
        if (tag.getName().startsWith(REFS_TAGS)) {
            return tag.getName().substring(REFS_TAGS.length());
        }
        return "";
    }

    public static class TagComparator
    implements Comparator<Ref> {
        @Override
        public int compare(Ref tag1, Ref tag2) {
            String tagName1 = GitSdk.extractTagName(tag1);
            String tagName2 = GitSdk.extractTagName(tag2);
            return tagName1.compareTo(tagName2);
        }
    }
}

