/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.sql.parser;

import java.util.Arrays;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Scanners;
import org.codehaus.jparsec.Terminals;
import org.codehaus.jparsec.Tokens;
import org.codehaus.jparsec.examples.sql.ast.QualifiedName;
import org.codehaus.jparsec.misc.Mapper;

final class TerminalParser {
    private static final String[] OPERATORS = new String[]{"+", "-", "*", "/", "%", ">", "<", "=", ">=", "<=", "<>", ".", ",", "(", ")", "[", "]"};
    private static final String[] KEYWORDS = new String[]{"select", "distinct", "from", "as", "where", "group", "by", "having", "order", "asc", "desc", "and", "or", "not", "in", "exists", "between", "is", "null", "like", "escape", "inner", "outer", "left", "right", "full", "cross", "join", "on", "union", "all", "case", "when", "then", "else", "end"};
    private static final Terminals TERMS = Terminals.operators((String[])OPERATORS).words(Scanners.IDENTIFIER).caseInsensitiveKeywords(Arrays.asList(KEYWORDS)).build();
    private static final Parser<?> TOKENIZER = Parsers.or((Parser)Terminals.DecimalLiteral.TOKENIZER, (Parser)Terminals.StringLiteral.SINGLE_QUOTE_TOKENIZER, (Parser)TERMS.tokenizer());
    static final Parser<String> NUMBER = Terminals.DecimalLiteral.PARSER;
    static final Parser<String> STRING = Terminals.StringLiteral.PARSER;
    static final Parser<String> NAME = Parsers.between(TerminalParser.term("["), (Parser)Terminals.fragment((Object[])new Object[]{Tokens.Tag.RESERVED, Tokens.Tag.IDENTIFIER}), TerminalParser.term("]")).or(Terminals.Identifier.PARSER);
    static final Parser<QualifiedName> QUALIFIED_NAME = Mapper.curry(QualifiedName.class, (Object[])new Object[0]).sequence(new Parser[]{NAME.sepBy1(TerminalParser.term("."))});

    TerminalParser() {
    }

    static <T> T parse(Parser<T> parser, String source) {
        return (T)parser.from(TOKENIZER, Scanners.SQL_DELIMITER).parse((CharSequence)source);
    }

    public static Parser<?> term(String term) {
        return Mapper._((Parser)TERMS.token(term));
    }

    public static Parser<?> phrase(String phrase) {
        return Mapper._((Parser)TERMS.phrase(phrase.split("\\s")));
    }
}

