/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.java.parser;

import java.util.Collections;
import java.util.List;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Terminals;
import org.codehaus.jparsec.examples.java.ast.type.ArrayTypeLiteral;
import org.codehaus.jparsec.examples.java.ast.type.LowerBoundWildcard;
import org.codehaus.jparsec.examples.java.ast.type.SimpleTypeLiteral;
import org.codehaus.jparsec.examples.java.ast.type.TypeLiteral;
import org.codehaus.jparsec.examples.java.ast.type.UpperBoundWildcard;
import org.codehaus.jparsec.examples.java.parser.TerminalParser;
import org.codehaus.jparsec.functors.Maps;
import org.codehaus.jparsec.functors.Unary;
import org.codehaus.jparsec.misc.Mapper;

public final class TypeLiteralParser {
    static final List<TypeLiteral> EMPTY_TYPE_ARGUMENT_LIST = Collections.emptyList();
    static final Parser<Unary<TypeLiteral>> ARRAY_OF = TerminalParser.phrase("[ ]").next(TypeLiteralParser.curry(ArrayTypeLiteral.class, new Object[0]).unary());
    static final Parser<TypeLiteral> ELEMENT_TYPE_LITERAL = TypeLiteralParser.elementTypeLiteral();
    static final Parser<TypeLiteral> ARRAY_TYPE_LITERAL = TypeLiteralParser.curry(ArrayTypeLiteral.class, new Object[0]).sequence(new Parser[]{ELEMENT_TYPE_LITERAL, TerminalParser.phrase("[ ]")}).postfix(ARRAY_OF);
    static final Parser<TypeLiteral> TYPE_LITERAL = ELEMENT_TYPE_LITERAL.postfix(ARRAY_OF);

    static Parser<TypeLiteral> elementTypeLiteral() {
        Parser.Reference ref = Parser.newReference();
        Parser lazy = ref.lazy();
        Parser arg = TypeLiteralParser.wildcard((Parser<TypeLiteral>)lazy).or(lazy);
        Parser nativeTypeName = TerminalParser.oneOf("byte", "short", "int", "long", "boolean", "char", "float", "double", "void").map(Maps.mapToString());
        Parser typeName = nativeTypeName.or(Terminals.Identifier.PARSER);
        Parser parser = Mapper.curry(SimpleTypeLiteral.class, (Object[])new Object[0]).sequence(new Parser[]{typeName.sepBy1(TerminalParser.term(".")), TypeLiteralParser.optionalTypeArgs((Parser<TypeLiteral>)arg)});
        ref.set((Object)parser.postfix(ARRAY_OF));
        return parser;
    }

    static Parser<List<TypeLiteral>> optionalTypeArgs(Parser<TypeLiteral> parser) {
        return Parsers.between(TerminalParser.term("<"), (Parser)parser.sepBy1(TerminalParser.term(",")), TerminalParser.term(">")).optional(EMPTY_TYPE_ARGUMENT_LIST);
    }

    static Parser<TypeLiteral> wildcard(Parser<TypeLiteral> type) {
        return Parsers.or((Parser)TypeLiteralParser.curry(UpperBoundWildcard.class, new Object[0]).sequence(new Parser[]{TerminalParser.phrase("? extends"), type}), (Parser)TypeLiteralParser.curry(LowerBoundWildcard.class, new Object[0]).sequence(new Parser[]{TerminalParser.phrase("? super"), type}), (Parser)TerminalParser.term("?").retn((Object)new UpperBoundWildcard(null)));
    }

    private static Mapper<TypeLiteral> curry(Class<? extends TypeLiteral> clazz, Object ... curryArgs) {
        return Mapper.curry(clazz, (Object[])curryArgs);
    }
}

