/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.java.ast.expression;

import java.util.Collections;
import java.util.List;
import org.codehaus.jparsec.examples.common.Strings;
import org.codehaus.jparsec.examples.common.ValueObject;
import org.codehaus.jparsec.examples.java.ast.expression.Expression;
import org.codehaus.jparsec.examples.java.ast.type.TypeLiteral;

public final class MethodCallExpression
extends ValueObject
implements Expression {
    public final Expression target;
    public final List<TypeLiteral> typeParameters;
    public final String method;
    public final List<Expression> arguments;

    public MethodCallExpression(Expression target, List<TypeLiteral> typeParameters, String method, List<Expression> arguments) {
        this.target = target;
        this.typeParameters = Collections.unmodifiableList(typeParameters);
        this.method = method;
        this.arguments = Collections.unmodifiableList(arguments);
    }

    @Override
    public String toString() {
        return (this.target == null ? "" : this.target + ".") + (this.typeParameters.isEmpty() ? "" : "<" + Strings.join(", ", this.typeParameters) + ">") + this.method + "(" + Strings.join(", ", this.arguments) + ")";
    }
}

