/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.calculator;

import org.codehaus.jparsec.OperatorTable;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Scanners;
import org.codehaus.jparsec.functors.Binary;
import org.codehaus.jparsec.functors.Map;
import org.codehaus.jparsec.functors.Unary;

public final class Calculator {
    static final Parser<Integer> NUMBER = Scanners.INTEGER.map((Map)new Map<String, Integer>(){

        public Integer map(String text) {
            return Integer.valueOf(text);
        }
    });
    static final Binary<Integer> PLUS = new Binary<Integer>(){

        public Integer map(Integer a, Integer b) {
            return a + b;
        }
    };
    static final Binary<Integer> MINUS = new Binary<Integer>(){

        public Integer map(Integer a, Integer b) {
            return a - b;
        }
    };
    static final Binary<Integer> MUL = new Binary<Integer>(){

        public Integer map(Integer a, Integer b) {
            return a * b;
        }
    };
    static final Binary<Integer> DIV = new Binary<Integer>(){

        public Integer map(Integer a, Integer b) {
            return a / b;
        }
    };
    static final Binary<Integer> MOD = new Binary<Integer>(){

        public Integer map(Integer a, Integer b) {
            return a % b;
        }
    };
    static final Unary<Integer> NEG = new Unary<Integer>(){

        public Integer map(Integer i) {
            return -i.intValue();
        }
    };

    public static int evaluate(String source) {
        return (Integer)Calculator.parser().parse((CharSequence)source);
    }

    private static <T> Parser<T> op(char ch, T value) {
        return Scanners.isChar((char)ch).retn(value);
    }

    static Parser<Integer> parser() {
        Parser.Reference ref = Parser.newReference();
        Parser term = ref.lazy().between(Scanners.isChar((char)'('), Scanners.isChar((char)')')).or(NUMBER);
        Parser parser = new OperatorTable().prefix(Calculator.op('-', NEG), 100).infixl(Calculator.op('+', PLUS), 10).infixl(Calculator.op('-', MINUS), 10).infixl(Calculator.op('*', MUL), 20).infixl(Calculator.op('/', DIV), 20).infixl(Calculator.op('%', MOD), 20).build(term);
        ref.set((Object)parser);
        return parser;
    }
}

