/*
 * Decompiled with CFR 0.152.
 */
package org.joyrest.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joyrest.context.ApplicationContext;
import org.joyrest.context.DependencyInjectionConfigurer;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Configuration;

public final class SpringJavaConfigurer
extends DependencyInjectionConfigurer<Object> {
    private org.springframework.context.ApplicationContext context = null;

    public ApplicationContext initialize(Object applicationConfig) {
        Objects.requireNonNull(applicationConfig, "ApplicationConfig must be non-null for configuring Spring.");
        boolean isConfigAnnotated = applicationConfig.getClass().isAnnotationPresent(Configuration.class);
        if (!isConfigAnnotated) {
            throw new IllegalArgumentException("Provided config is @Configuration annotated Spring Java Config");
        }
        this.context = new AnnotationConfigApplicationContext(new Class[]{applicationConfig.getClass()});
        return this.initializeContext();
    }

    protected <B> List<B> getBeans(Class<B> clazz) {
        return new ArrayList(this.context.getBeansOfType(clazz).values());
    }
}

