/*
 * Decompiled with CFR 0.152.
 */
package org.joyrest.servlet.model;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.joyrest.model.http.HeaderName;
import org.joyrest.model.http.HttpStatus;
import org.joyrest.model.response.InternalResponse;
import org.joyrest.model.response.Response;

public class ServletResponseWrapper
extends InternalResponse<Object> {
    private final HttpServletResponse response;
    private final Map<HeaderName, String> headers = new HashMap<HeaderName, String>();
    private HttpStatus status;

    public ServletResponseWrapper(HttpServletResponse response) {
        this.response = response;
    }

    public OutputStream getOutputStream() {
        try {
            return this.response.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred during getting a Jetty InputStream");
        }
    }

    public Map<HeaderName, String> getHeaders() {
        return this.headers;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    public Response<Object> header(HeaderName name, String value) {
        this.response.addHeader(name.getValue(), value);
        this.headers.put(name, value);
        return this;
    }

    public Response<Object> status(HttpStatus status) {
        this.response.setStatus(status.code());
        this.status = status;
        return this;
    }
}

