/*
 * Decompiled with CFR 0.152.
 */
package org.joyrest.servlet.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletRequest;
import org.joyrest.common.UnmodifiableMapCollector;
import org.joyrest.model.http.HeaderName;
import org.joyrest.model.http.HttpMethod;
import org.joyrest.model.request.InternalRequest;

public class ServletRequestWrapper
extends InternalRequest<Object> {
    private final HttpServletRequest request;
    private final HttpMethod method;
    private final String path;
    private Map<HeaderName, String> headers;

    public ServletRequestWrapper(HttpServletRequest request) {
        this.request = request;
        this.method = HttpMethod.of((String)request.getMethod());
        this.path = ServletRequestWrapper.createPath(request.getRequestURI(), request.getContextPath(), request.getServletPath());
    }

    private static String createPath(String requestUri, String contextPath, String servletPath) {
        return requestUri.substring(contextPath.length()).substring(servletPath.length());
    }

    public Map<HeaderName, String> getHeaders() {
        if (Objects.nonNull(this.headers)) {
            return this.headers;
        }
        this.headers = (Map)StreamSupport.stream(Collections.list(this.request.getHeaderNames()).spliterator(), false).collect(UnmodifiableMapCollector.toUnmodifiableMap(HeaderName::of, name -> this.getHeader(HeaderName.of((String)name)).get()));
        return this.headers;
    }

    public Optional<String> getHeader(HeaderName name) {
        return Optional.ofNullable(this.request.getHeader(name.getValue()));
    }

    public String getPath() {
        return this.path;
    }

    public InputStream getInputStream() {
        try {
            return this.request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred during getting a Jetty InputStream");
        }
    }

    public Map<String, String[]> getQueryParams() {
        return this.request.getParameterMap();
    }

    public Optional<String[]> getQueryParams(String name) {
        return Optional.ofNullable(this.request.getParameterValues(name));
    }

    public HttpMethod getMethod() {
        return this.method;
    }
}

