/*
 * Decompiled with CFR 0.152.
 */
package org.joyrest.servlet;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joyrest.context.ApplicationContext;
import org.joyrest.context.Configurer;
import org.joyrest.context.NonDiConfigurer;
import org.joyrest.exception.type.InvalidConfigurationException;
import org.joyrest.logging.JoyLogger;
import org.joyrest.model.request.InternalRequest;
import org.joyrest.model.response.InternalResponse;
import org.joyrest.processor.RequestProcessor;
import org.joyrest.processor.RequestProcessorImpl;
import org.joyrest.servlet.model.ServletRequestWrapper;
import org.joyrest.servlet.model.ServletResponseWrapper;

public class ServletApplicationHandler
extends HttpServlet
implements Filter {
    private static final long serialVersionUID = -4298969347996942699L;
    private static final JoyLogger log = new JoyLogger(ServletApplicationHandler.class);
    private RequestProcessor processor;
    private Configurer configurer;
    private Object applicationConfig;

    public ServletApplicationHandler() {
    }

    public ServletApplicationHandler(Configurer<?> configurer, Object applicationConfig) {
        this.configurer = configurer;
        this.applicationConfig = applicationConfig;
    }

    private static Object getInstanceFromClazz(String clazzName) throws ServletException {
        return ServletApplicationHandler.getInstanceFromClazz(clazzName, Object.class);
    }

    private static <T> T getInstanceFromClazz(String clazzName, Class<T> expectedClazz) throws ServletException {
        try {
            Class<?> clazz = Class.forName(clazzName);
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ServletException("Invalid expected class", (Throwable)e);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.initializeProcessor(arg_0 -> ((ServletConfig)servletConfig).getInitParameter(arg_0));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initializeProcessor(arg_0 -> ((FilterConfig)filterConfig).getInitParameter(arg_0));
    }

    private void initializeProcessor(Function<String, String> paramProvider) throws ServletException {
        ApplicationContext context;
        String configClass;
        if (Objects.isNull(this.applicationConfig) && Objects.nonNull(configClass = paramProvider.apply("applicationJavaConfig"))) {
            this.applicationConfig = ServletApplicationHandler.getInstanceFromClazz(configClass);
        }
        if (Objects.isNull(this.configurer)) {
            String configurerClass = paramProvider.apply("configurer");
            if (Objects.nonNull(configurerClass)) {
                this.configurer = ServletApplicationHandler.getInstanceFromClazz(paramProvider.apply("configurer"), Configurer.class);
            } else {
                throw new InvalidConfigurationException("Servlet Handler cannot be initialized because property 'configurer' missing.");
            }
        }
        if (Objects.nonNull(this.applicationConfig)) {
            context = this.configurer.initialize(this.applicationConfig);
        } else if (this.configurer instanceof NonDiConfigurer) {
            context = ((NonDiConfigurer)this.configurer).initialize();
        } else {
            throw new InvalidConfigurationException("Servlet Handler cannot be initialized because of DI-dependent configurer without an application config.");
        }
        this.processor = new RequestProcessorImpl(context);
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        try {
            this.processRequest((HttpServletRequest)req, (HttpServletResponse)resp);
        }
        catch (ClassCastException cce) {
            throw new ServletException("This is not Http Servlet Filter", (Throwable)cce);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(request, resp);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if (req.getDispatcherType() == DispatcherType.ERROR) {
                return;
            }
            this.processor.process((InternalRequest)new ServletRequestWrapper(req), (InternalResponse)new ServletResponseWrapper(resp));
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }
}

