/*
 * Decompiled with CFR 0.152.
 */
package org.joyrest.grizzly.model;

import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.glassfish.grizzly.http.server.Request;
import org.joyrest.common.UnmodifiableMapCollector;
import org.joyrest.model.http.HeaderName;
import org.joyrest.model.http.HttpMethod;
import org.joyrest.model.request.InternalRequest;

public class GrizzlyRequestWrapper
extends InternalRequest<Object> {
    private final Request request;
    private final HttpMethod method;
    private final String path;
    private Map<HeaderName, String> headers;

    public GrizzlyRequestWrapper(Request request) {
        this.request = request;
        this.method = HttpMethod.of((String)request.getMethod().getMethodString());
        this.path = request.getRequestURI().substring(request.getContextPath().length());
    }

    public Map<HeaderName, String> getHeaders() {
        if (Objects.nonNull(this.headers)) {
            return this.headers;
        }
        this.headers = (Map)StreamSupport.stream(this.request.getHeaderNames().spliterator(), false).collect(UnmodifiableMapCollector.toUnmodifiableMap(HeaderName::of, name -> this.getHeader(HeaderName.of((String)name)).get()));
        return this.headers;
    }

    public Optional<String> getHeader(HeaderName name) {
        return Optional.ofNullable(this.request.getHeader(name.getValue()));
    }

    public String getPath() {
        return this.path;
    }

    public InputStream getInputStream() {
        return this.request.getInputStream();
    }

    public Map<String, String[]> getQueryParams() {
        return this.request.getParameterMap();
    }

    public Optional<String[]> getQueryParams(String name) {
        return Optional.ofNullable(this.request.getParameterValues(name));
    }

    public HttpMethod getMethod() {
        return this.method;
    }
}

