/*
 * Decompiled with CFR 0.152.
 */
package org.joyrest.grizzly;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.joyrest.context.ApplicationContext;
import org.joyrest.grizzly.handler.GrizzlyApplicationHandler;

public class GrizzlyServer {
    private static Logger LOG = Logger.getLogger(GrizzlyServer.class.getName());

    public static void start(ApplicationContext applicationConfig, int port, String path) {
        try {
            InputStream loggingStream = GrizzlyServer.class.getResourceAsStream("/logging.properties");
            if (Objects.nonNull(loggingStream)) {
                LogManager.getLogManager().readConfiguration(loggingStream);
            }
            HttpServer server = HttpServer.createSimpleServer(null, (int)port);
            server.getServerConfiguration().addHttpHandler((HttpHandler)new GrizzlyApplicationHandler(applicationConfig), new String[]{path});
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((HttpServer)server).shutdownNow()));
            server.start();
            LOG.info("Grizzly Server started. Stop the application using ^C.");
            Thread.currentThread().join();
        }
        catch (IOException | InterruptedException e) {
            LOG.log(Level.SEVERE, null, e);
        }
    }
}

