/*
 * Decompiled with CFR 0.152.
 */
package org.joyrest.dagger;

import dagger.ObjectGraph;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.joyrest.aspect.Aspect;
import org.joyrest.context.AbstractConfigurer;
import org.joyrest.context.ApplicationContext;
import org.joyrest.exception.configuration.ExceptionConfiguration;
import org.joyrest.routing.ControllerConfiguration;
import org.joyrest.transform.Reader;
import org.joyrest.transform.Writer;

public class DaggerConfigurer
extends AbstractConfigurer<Object> {
    private DaggerConfigurationProvider provider = null;

    public ApplicationContext initialize(Object applicationConfig) {
        Objects.requireNonNull(applicationConfig, "Application module must be non-null for configuring Dagger.");
        ObjectGraph graph = ObjectGraph.create((Object[])new Object[]{applicationConfig});
        this.provider = (DaggerConfigurationProvider)graph.inject((Object)new DaggerConfigurationProvider());
        return this.initializeContext();
    }

    protected Collection<Aspect> getAspects() {
        return this.createList(this.provider.aspects);
    }

    protected Collection<Reader> getReaders() {
        return this.createList(this.provider.readers);
    }

    protected Collection<Writer> getWriters() {
        return this.createList(this.provider.writers);
    }

    protected Collection<ExceptionConfiguration> getExceptionConfigurations() {
        return this.createList(this.provider.exceptionConfigurations);
    }

    protected Collection<ControllerConfiguration> getControllerConfiguration() {
        return this.createList(this.provider.controllerConfiguration);
    }

    private <E> Collection<E> createList(Collection<E> collection) {
        return collection.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static class DaggerConfigurationProvider {
        @Inject
        Set<Aspect> aspects;
        @Inject
        Set<Reader> readers;
        @Inject
        Set<Writer> writers;
        @Inject
        Set<ExceptionConfiguration> exceptionConfigurations;
        @Inject
        Set<ControllerConfiguration> controllerConfiguration;
    }
}

