/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.hbv;

import com.google.inject.Injector;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.jooby.Managed;
import org.jooby.hbv.HbvConstraintValidatorFactory;

class HbvFactory
implements Managed,
Provider<Validator> {
    private HibernateValidatorConfiguration conf;
    private Validator validator;
    private ValidatorFactory factory;

    @Inject
    public HbvFactory(HibernateValidatorConfiguration conf, Injector injector) {
        this.conf = Objects.requireNonNull(conf, "Validation config is required.");
        conf.constraintValidatorFactory((ConstraintValidatorFactory)new HbvConstraintValidatorFactory(injector));
    }

    public Validator get() {
        Objects.requireNonNull(this.validator, "No validator available");
        return this.validator;
    }

    public void start() throws Exception {
        this.factory = this.conf.buildValidatorFactory();
        this.validator = this.factory.getValidator();
    }

    public void stop() throws Exception {
        if (this.factory != null) {
            this.factory.close();
            this.validator = null;
            this.factory = null;
        }
    }
}

