/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.jomc.model.Argument;
import org.jomc.model.Dependency;
import org.jomc.model.Implementation;
import org.jomc.model.JavaIdentifier;
import org.jomc.model.Message;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.Property;
import org.jomc.model.Specification;
import org.jomc.model.SpecificationReference;
import org.jomc.model.Text;
import org.jomc.model.Texts;
import org.jomc.model.modlet.DefaultModelProvider;
import org.jomc.model.modlet.ModelHelper;
import org.jomc.modlet.Model;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelContextFactory;
import org.jomc.modlet.ModelException;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.tools.JomcTool;
import org.junit.Assert;
import org.junit.Test;

public class JomcToolTest {
    private static final String RESOURCE_ENCODING_PROPERTY_NAME = "jomc.test.resourceEncoding";
    private static final String OUTPUT_DIRECTORY_PROPERTY_NAME = "jomc.test.outputDirectory";
    private JomcTool jomcTool;
    private ModelContext modelContext;
    private Model model;
    private String resourceEncoding;
    private File outputDirectory;
    private volatile int outputDirectoryId;

    public final String getResourceEncoding() {
        if (this.resourceEncoding == null) {
            this.resourceEncoding = System.getProperty(RESOURCE_ENCODING_PROPERTY_NAME);
            Assert.assertNotNull((String)"Expected 'jomc.test.resourceEncoding' system property not found.", (Object)this.resourceEncoding);
        }
        return this.resourceEncoding;
    }

    public final void setResourceEncoding(String value) {
        this.resourceEncoding = value;
    }

    public final File getOutputDirectory() {
        if (this.outputDirectory == null) {
            String name = System.getProperty(OUTPUT_DIRECTORY_PROPERTY_NAME);
            Assert.assertNotNull((String)"Expected 'jomc.test.outputDirectory' system property not found.", (Object)name);
            this.outputDirectory = new File(new File(name), this.getClass().getSimpleName());
            Assert.assertTrue((String)"Expected 'jomc.test.outputDirectory' system property to hold an absolute path.", (boolean)this.outputDirectory.isAbsolute());
            if (!this.outputDirectory.exists()) {
                Assert.assertTrue((boolean)this.outputDirectory.mkdirs());
            }
        }
        return this.outputDirectory;
    }

    public final void setOutputDirectory(File value) {
        if (value != null) {
            Assert.assertTrue((String)"Expected absolute 'outputDirectory'.", (boolean)value.isAbsolute());
        }
        this.outputDirectory = value;
    }

    public final File getNextOutputDirectory() {
        try {
            File nextOutputDirectory = new File(this.getOutputDirectory(), Integer.toString(this.outputDirectoryId++));
            Assert.assertTrue((boolean)nextOutputDirectory.isAbsolute());
            if (nextOutputDirectory.exists()) {
                FileUtils.deleteDirectory((File)nextOutputDirectory);
            }
            return nextOutputDirectory;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public JomcTool getJomcTool() {
        if (this.jomcTool == null) {
            this.jomcTool = this.newJomcTool();
            this.jomcTool.setModel(this.getModel());
            this.jomcTool.getListeners().add(new JomcTool.Listener(){

                public void onLog(Level level, String message, Throwable throwable) {
                    super.onLog(level, message, throwable);
                    System.out.println("[" + level.getLocalizedName() + "] " + message);
                    if (throwable != null) {
                        throwable.printStackTrace(System.out);
                    }
                }
            });
        }
        return this.jomcTool;
    }

    protected JomcTool newJomcTool() {
        return new JomcTool();
    }

    public ModelContext getModelContext() {
        if (this.modelContext == null) {
            this.modelContext = this.newModelContext();
            this.modelContext.getListeners().add(new ModelContext.Listener(){

                public void onLog(Level level, String message, Throwable t) {
                    super.onLog(level, message, t);
                    System.out.println("[" + level.getLocalizedName() + "] " + message);
                    if (t != null) {
                        t.printStackTrace(System.out);
                    }
                }
            });
        }
        return this.modelContext;
    }

    protected ModelContext newModelContext() {
        return ModelContextFactory.newInstance().newModelContext();
    }

    public Model getModel() {
        if (this.model == null) {
            this.model = this.newModel();
        }
        return this.model;
    }

    protected Model newModel() {
        try {
            DefaultModelProvider.setDefaultModuleLocation((String)(this.getClass().getPackage().getName().replace('.', '/') + "/jomc.xml"));
            Model m = this.getModelContext().findModel("http://jomc.org/model");
            if (m != null) {
                Module cp;
                Modules modules = ModelHelper.getModules((Model)m);
                if (modules != null && (cp = modules.getClasspathModule(Modules.getDefaultClasspathModuleName(), this.getClass().getClassLoader())) != null) {
                    modules.getModule().add(cp);
                }
                if ((m = this.getModelContext().processModel(m)) != null) {
                    ModelValidationReport validationReport = this.getModelContext().validateModel(m);
                    int s0 = validationReport.getDetails().size();
                    for (int i = 0; i < s0; ++i) {
                        System.out.println(validationReport.getDetails().get(i));
                    }
                    Assert.assertTrue((String)("Unexpected invalid '" + m.getIdentifier() + "' model."), (boolean)validationReport.isModelValid());
                }
            }
            Model model = m;
            return model;
        }
        catch (ModelException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            DefaultModelProvider.setDefaultModuleLocation(null);
        }
    }

    @Test
    public final void testJomcToolNullPointerException() throws Exception {
        Assert.assertNotNull((Object)this.getJomcTool());
        try {
            this.getJomcTool().getDisplayLanguage(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getImplementedJavaTypeNames(null, false);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaClasspathLocation((Implementation)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaClasspathLocation((Specification)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaGetterMethodName((Dependency)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaGetterMethodName((Message)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaGetterMethodName((Property)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaMethodParameterName((Argument)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaMethodParameterName((Dependency)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaMethodParameterName((Message)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaMethodParameterName((Property)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaInterfaceNames(null, false);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaModifierName(null, (Dependency)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaModifierName(new Implementation(), (Dependency)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaModifierName(null, (Message)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaModifierName(new Implementation(), (Message)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaModifierName(null, (Property)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaModifierName(new Implementation(), (Property)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaPackageName((Implementation)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaPackageName((Specification)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaPackageName((SpecificationReference)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaSetterMethodName((Dependency)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaSetterMethodName((Message)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaSetterMethodName((Property)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaTypeName((Argument)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaTypeName((Dependency)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaTypeName((Implementation)null, true);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaTypeName((Property)null, true);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaTypeName((Specification)null, true);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavaTypeName((SpecificationReference)null, true);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavadocComment((Text)null, 0, "\n");
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavadocComment(new Text(), 0, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavadocComment(new Text(), Integer.MIN_VALUE, "\n");
            Assert.fail((String)"Expected IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException e) {
            JomcToolTest.assertIllegalArgumentException(e);
        }
        try {
            this.getJomcTool().getJavadocComment((Texts)null, 0, "\n");
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavadocComment(new Texts(), 0, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getJavadocComment(new Texts(), Integer.MIN_VALUE, "\n");
            Assert.fail((String)"Expected IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException e) {
            JomcToolTest.assertIllegalArgumentException(e);
        }
        try {
            this.getJomcTool().getLongDate(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getLongDateTime(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getLongTime(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getMediumDate(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getMediumDateTime(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getMediumTime(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getShortDate(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getShortDateTime(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getShortTime(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getVelocityTemplate(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getYears(null, Calendar.getInstance());
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getYears(Calendar.getInstance(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().isJavaDefaultPackage((Implementation)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().isJavaDefaultPackage((Specification)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().isJavaPrimitiveType(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().isLoggable(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getIsoDate(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getIsoTime(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getIsoDateTime(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getTemplateEncoding(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getParentTemplateProfile(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            JomcToolTest.assertNullPointerException(e);
        }
    }

    @Test
    public final void testJomcToolNotNull() throws Exception {
        Specification specification = new Specification();
        specification.setClazz("java.lang.Object");
        specification.setIdentifier("java.lang.Object");
        Specification defaultPackageSpecification = new Specification();
        defaultPackageSpecification.setClazz("Object");
        defaultPackageSpecification.setIdentifier("Object");
        Implementation implementation = new Implementation();
        implementation.setIdentifier("java.lang.Object");
        implementation.setName("java.lang.Object");
        implementation.setClazz("java.lang.Object");
        Implementation defaultPackageImplementation = new Implementation();
        defaultPackageImplementation.setIdentifier("Object");
        defaultPackageImplementation.setName("Object");
        defaultPackageImplementation.setClazz("Object");
        Dependency d = new Dependency();
        d.setIdentifier("java.util.Locale");
        d.setName("locale");
        d.setImplementationName("default");
        Property p = new Property();
        p.setName("property");
        p.setValue("Test");
        Message m = new Message();
        m.setName("message");
        Calendar now = Calendar.getInstance();
        Calendar nextYear = Calendar.getInstance();
        nextYear.set(1, nextYear.get(1) + 1);
        Assert.assertNotNull((Object)this.getJomcTool().getListeners());
        Assert.assertNotNull((Object)this.getJomcTool().getInputEncoding());
        Assert.assertNotNull((Object)this.getJomcTool().getModel());
        Assert.assertNotNull((Object)this.getJomcTool().getModules());
        Assert.assertNotNull((Object)this.getJomcTool().getOutputEncoding());
        Assert.assertNotNull((Object)this.getJomcTool().getTemplateProfile());
        Assert.assertNotNull((Object)this.getJomcTool().getTemplateEncoding());
        Assert.assertNotNull((Object)this.getJomcTool().getDefaultTemplateEncoding());
        Assert.assertNotNull((Object)this.getJomcTool().getTemplateParameters());
        Assert.assertNotNull((Object)this.getJomcTool().getIndentation());
        Assert.assertNotNull((Object)this.getJomcTool().getLineSeparator());
        Assert.assertNotNull((Object)this.getJomcTool().getVelocityContext());
        Assert.assertNotNull((Object)this.getJomcTool().getVelocityEngine());
        Assert.assertNotNull((Object)JomcTool.getDefaultLogLevel());
        Assert.assertNotNull((Object)this.getJomcTool().getLongDate(now));
        Assert.assertNotNull((Object)this.getJomcTool().getLongDateTime(now));
        Assert.assertNotNull((Object)this.getJomcTool().getLongTime(now));
        Assert.assertNotNull((Object)this.getJomcTool().getMediumDate(now));
        Assert.assertNotNull((Object)this.getJomcTool().getMediumDateTime(now));
        Assert.assertNotNull((Object)this.getJomcTool().getMediumTime(now));
        Assert.assertNotNull((Object)this.getJomcTool().getShortDate(now));
        Assert.assertNotNull((Object)this.getJomcTool().getShortDateTime(now));
        Assert.assertNotNull((Object)this.getJomcTool().getShortTime(now));
        Assert.assertNotNull((Object)this.getJomcTool().getIsoDate(now));
        Assert.assertNotNull((Object)this.getJomcTool().getIsoDateTime(now));
        Assert.assertNotNull((Object)this.getJomcTool().getIsoTime(now));
        Assert.assertNotNull((Object)this.getJomcTool().getYears(now, now));
        Assert.assertNotNull((Object)this.getJomcTool().getYears(now, nextYear));
        Assert.assertNotNull((Object)this.getJomcTool().getYears(nextYear, now));
        Assert.assertNotNull((Object)this.getJomcTool().getDisplayLanguage("en"));
        Assert.assertEquals((Object)this.getJomcTool().getYears(now, nextYear), (Object)this.getJomcTool().getYears(nextYear, now));
        Assert.assertEquals((Object)Locale.getDefault().getDisplayLanguage(), (Object)this.getJomcTool().getDisplayLanguage(Locale.getDefault().getLanguage()));
        Assert.assertEquals((Object)"java/lang/Object", (Object)this.getJomcTool().getJavaClasspathLocation(implementation));
        Assert.assertEquals((Object)"Object", (Object)this.getJomcTool().getJavaClasspathLocation(defaultPackageImplementation));
        Assert.assertEquals((Object)"java/lang/Object", (Object)this.getJomcTool().getJavaClasspathLocation(specification));
        Assert.assertEquals((Object)"Object", (Object)this.getJomcTool().getJavaClasspathLocation(defaultPackageSpecification));
        Assert.assertEquals((Object)"getLocale", (Object)this.getJomcTool().getJavaGetterMethodName(d));
        Assert.assertEquals((Object)"getMessage", (Object)this.getJomcTool().getJavaGetterMethodName(m));
        Assert.assertEquals((Object)"getProperty", (Object)this.getJomcTool().getJavaGetterMethodName(p));
        Assert.assertEquals((long)0L, (long)this.getJomcTool().getJavaInterfaceNames(implementation, true).size());
        Assert.assertEquals((long)0L, (long)this.getJomcTool().getImplementedJavaTypeNames(implementation, true).size());
        Assert.assertEquals((Object)"private", (Object)this.getJomcTool().getJavaModifierName(implementation, d));
        Assert.assertEquals((Object)"private", (Object)this.getJomcTool().getJavaModifierName(implementation, m));
        Assert.assertEquals((Object)"private", (Object)this.getJomcTool().getJavaModifierName(implementation, p));
        Assert.assertEquals((Object)"java.lang", (Object)this.getJomcTool().getJavaPackageName(implementation));
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaPackageName(defaultPackageImplementation));
        Assert.assertEquals((Object)"java.lang", (Object)this.getJomcTool().getJavaPackageName(specification));
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaPackageName(defaultPackageSpecification));
        Assert.assertEquals((Object)"java.util", (Object)this.getJomcTool().getJavaPackageName((SpecificationReference)d));
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaString(""));
        Assert.assertEquals((Object)this.getJomcTool().getIndentation(), (Object)this.getJomcTool().getIndentation(1));
        Assert.assertEquals((Object)this.getJomcTool().getDefaultTemplateEncoding(), (Object)this.getJomcTool().getTemplateEncoding("DOES_NOT_EXIST"));
        this.getJomcTool();
        Assert.assertEquals((Object)JomcTool.getDefaultTemplateProfile(), (Object)this.getJomcTool().getParentTemplateProfile("DOES_NOT_EXIST"));
    }

    @Test
    public final void testVelocityTemplates() throws Exception {
        Assert.assertNotNull((Object)this.getJomcTool().getVelocityTemplate("Implementation.java.vm"));
        this.getJomcTool().setTemplateProfile("DOES_NOT_EXIST");
        Assert.assertNotNull((Object)this.getJomcTool().getVelocityTemplate("Implementation.java.vm"));
        this.getJomcTool().setTemplateProfile(null);
        try {
            this.getJomcTool().getVelocityTemplate("DOES_NOT_EXIST");
            Assert.fail((String)"Expected FileNotFoundException not thrown.");
        }
        catch (FileNotFoundException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        try {
            this.getJomcTool().setTemplateProfile("DOES_NOT_EXIST");
            this.getJomcTool().getVelocityTemplate("DOES_NOT_EXIST");
            Assert.fail((String)"Expected FileNotFoundException not thrown.");
        }
        catch (FileNotFoundException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
    }

    @Test
    public final void testDefaultLogLevel() throws Exception {
        String testLogLevel = System.getProperty("org.jomc.tools.JomcTool.defaultLogLevel");
        Assert.assertNotNull((Object)JomcTool.getDefaultLogLevel());
        JomcTool.setDefaultLogLevel(null);
        System.setProperty("org.jomc.tools.JomcTool.defaultLogLevel", "OFF");
        Assert.assertEquals((Object)Level.OFF, (Object)JomcTool.getDefaultLogLevel());
        if (testLogLevel != null) {
            System.setProperty("org.jomc.tools.JomcTool.defaultLogLevel", testLogLevel);
        } else {
            System.clearProperty("org.jomc.tools.JomcTool.defaultLogLevel");
        }
        JomcTool.setDefaultLogLevel(null);
    }

    @Test
    public final void testLogLevel() throws Exception {
        JomcTool.setDefaultLogLevel(null);
        this.getJomcTool().setLogLevel(null);
        Assert.assertNotNull((Object)this.getJomcTool().getLogLevel());
        JomcTool.setDefaultLogLevel((Level)Level.OFF);
        this.getJomcTool().setLogLevel(null);
        Assert.assertEquals((Object)Level.OFF, (Object)this.getJomcTool().getLogLevel());
        JomcTool.setDefaultLogLevel(null);
        this.getJomcTool().setLogLevel(null);
    }

    @Test
    public final void testDefaultTemplateProfile() throws Exception {
        Assert.assertNotNull((Object)JomcTool.getDefaultTemplateProfile());
        System.setProperty("org.jomc.tools.JomcTool.defaultTemplateProfile", "TEST");
        JomcTool.setDefaultTemplateProfile(null);
        Assert.assertEquals((Object)"TEST", (Object)JomcTool.getDefaultTemplateProfile());
        System.clearProperty("org.jomc.tools.JomcTool.defaultTemplateProfile");
        JomcTool.setDefaultTemplateProfile(null);
    }

    @Test
    public final void testTemplateProfile() throws Exception {
        JomcTool.setDefaultTemplateProfile(null);
        this.getJomcTool().setTemplateProfile(null);
        Assert.assertNotNull((Object)this.getJomcTool().getTemplateProfile());
        JomcTool.setDefaultTemplateProfile((String)"TEST");
        this.getJomcTool().setTemplateProfile(null);
        Assert.assertEquals((Object)"TEST", (Object)this.getJomcTool().getTemplateProfile());
        JomcTool.setDefaultTemplateProfile(null);
        this.getJomcTool().setTemplateProfile(null);
    }

    @Test
    public final void testIndentation() throws Exception {
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getIndentation(0));
        Assert.assertEquals((Object)this.getJomcTool().getIndentation(), (Object)this.getJomcTool().getIndentation(1));
        try {
            this.getJomcTool().getIndentation(Integer.MIN_VALUE);
            Assert.fail((String)"Expected IllegalArgumentException not thrown.");
        }
        catch (IllegalArgumentException e) {
            JomcToolTest.assertIllegalArgumentException(e);
        }
        this.getJomcTool().setIndentation("    TEST    ");
        Assert.assertEquals((Object)"    TEST    ", (Object)this.getJomcTool().getIndentation());
        Assert.assertEquals((Object)"    TEST    ", (Object)this.getJomcTool().getIndentation(1));
        this.getJomcTool().setIndentation(null);
    }

    @Test
    public final void testModel() throws Exception {
        Model m = this.getJomcTool().getModel();
        this.getJomcTool().setModel(null);
        Assert.assertNotNull((Object)this.getJomcTool().getModel());
        this.getJomcTool().setModel(m);
    }

    @Test
    public final void testVelocityEngine() throws Exception {
        this.getJomcTool().setVelocityEngine(null);
        Assert.assertNotNull((Object)this.getJomcTool().getVelocityEngine());
        this.getJomcTool().setVelocityEngine(null);
    }

    @Test
    public final void testVelocityContext() throws Exception {
        Assert.assertNotNull((Object)this.getJomcTool().getVelocityContext());
        this.getJomcTool().setTemplateProfile("test");
        Assert.assertNotNull((Object)this.getJomcTool().getVelocityContext());
        Assert.assertNotNull((Object)this.getJomcTool().getVelocityContext().get("test-object"));
        Assert.assertTrue((boolean)(this.getJomcTool().getVelocityContext().get("test-object") instanceof JomcTool));
        Assert.assertNotNull((Object)this.getJomcTool().getVelocityContext().get("test-url"));
        Assert.assertTrue((boolean)(this.getJomcTool().getVelocityContext().get("test-url") instanceof URL));
        Assert.assertEquals((Object)new URL("file:///tmp"), (Object)this.getJomcTool().getVelocityContext().get("test-url"));
        Assert.assertNotNull((Object)this.getJomcTool().getVelocityContext().get("test-string"));
        Assert.assertTrue((boolean)(this.getJomcTool().getVelocityContext().get("test-string") instanceof String));
        Assert.assertEquals((Object)"Test", (Object)this.getJomcTool().getVelocityContext().get("test-string"));
        this.getJomcTool().setTemplateProfile(null);
    }

    @Test
    public final void testDefaultTemplateEncoding() throws Exception {
        this.getJomcTool().setDefaultTemplateEncoding(null);
        Assert.assertNotNull((Object)this.getJomcTool().getDefaultTemplateEncoding());
        this.getJomcTool().setDefaultTemplateEncoding(null);
    }

    @Test
    public final void testTemplateEncoding() throws Exception {
        File templateLocation = this.getNextOutputDirectory();
        File templatesDir = new File(templateLocation, "org");
        templatesDir = new File(templatesDir, "jomc");
        templatesDir = new File(templatesDir, "tools");
        templatesDir = new File(templatesDir, "templates");
        templatesDir = new File(templatesDir, "tmp");
        Assert.assertTrue((boolean)templatesDir.mkdirs());
        Properties p = new Properties();
        p.setProperty("template-encoding", "ISO-8859-1");
        FileOutputStream profileProperties = new FileOutputStream(new File(templatesDir, "profile.properties"));
        p.store(profileProperties, this.getClass().getName());
        ((OutputStream)profileProperties).close();
        this.getJomcTool().setDefaultTemplateEncoding(null);
        this.getJomcTool().setTemplateLocation(templateLocation.toURI().toURL());
        Assert.assertEquals((Object)"ISO-8859-1", (Object)this.getJomcTool().getTemplateEncoding("tmp"));
        Assert.assertEquals((Object)"US-ASCII", (Object)this.getJomcTool().getTemplateEncoding("test"));
        Assert.assertEquals((Object)this.getJomcTool().getDefaultTemplateEncoding(), (Object)this.getJomcTool().getTemplateEncoding("jomc-java-bundles"));
        this.getJomcTool().setTemplateLocation(null);
        this.getJomcTool().setDefaultTemplateEncoding(null);
    }

    @Test
    public final void testInputEncoding() throws Exception {
        this.getJomcTool().setInputEncoding(null);
        Assert.assertNotNull((Object)this.getJomcTool().getInputEncoding());
        this.getJomcTool().setInputEncoding(null);
    }

    @Test
    public final void testOutputEncoding() throws Exception {
        this.getJomcTool().setOutputEncoding(null);
        Assert.assertNotNull((Object)this.getJomcTool().getOutputEncoding());
        this.getJomcTool().setOutputEncoding(null);
    }

    @Test
    public final void testLineSeparator() throws Exception {
        this.getJomcTool().setLineSeparator(null);
        Assert.assertNotNull((Object)this.getJomcTool().getLineSeparator());
        this.getJomcTool().setLineSeparator(null);
    }

    @Test
    public final void testJomcToolModelObjectsNotFound() throws Exception {
        SpecificationReference ref = new SpecificationReference();
        ref.setIdentifier("DOES_NOT_EXIST");
        Implementation i = new Implementation();
        i.setIdentifier("DOES_NOT_EXSIST");
        Dependency d = new Dependency();
        d.setIdentifier("DOES_NOT_EXIST");
        Property p = new Property();
        p.setName("DOES_NOT_EXIST");
        Assert.assertNull((Object)this.getJomcTool().getJavaPackageName(ref));
        Assert.assertNull((Object)this.getJomcTool().getJavaTypeName(ref, false));
        Assert.assertNull((Object)this.getJomcTool().getJavaTypeName(d));
        Model oldModel = this.getJomcTool().getModel();
        this.getJomcTool().setModel(null);
        Assert.assertTrue((boolean)this.getJomcTool().getImplementedJavaTypeNames(i, true).isEmpty());
        Assert.assertEquals((Object)"private", (Object)this.getJomcTool().getJavaModifierName(i, p));
        this.getJomcTool().setModel(oldModel);
    }

    @Test
    public final void testJavaIdentifier() throws Exception {
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaIdentifier("", true));
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaIdentifier("", false));
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaIdentifier("  ", true));
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaIdentifier("  ", false));
        Assert.assertEquals((Object)"testTestTest", (Object)this.getJomcTool().getJavaIdentifier("  test test test  ", false));
        Assert.assertEquals((Object)"testTestTest", (Object)this.getJomcTool().getJavaIdentifier("  test  test  test  ", false));
        Assert.assertEquals((Object)"TestTestTest", (Object)this.getJomcTool().getJavaIdentifier("  test test test  ", true));
        Assert.assertEquals((Object)"TestTestTest", (Object)this.getJomcTool().getJavaIdentifier("  test  test  test  ", true));
        Assert.assertEquals((Object)"testTestTest", (Object)this.getJomcTool().getJavaIdentifier("  Test test test  ", false));
        Assert.assertEquals((Object)"testTestTest", (Object)this.getJomcTool().getJavaIdentifier("  Test  test  test  ", false));
        Assert.assertEquals((Object)"TestTestTest", (Object)this.getJomcTool().getJavaIdentifier("  test test test  ", true));
        Assert.assertEquals((Object)"TestTestTest", (Object)this.getJomcTool().getJavaIdentifier("  test  test  test  ", true));
    }

    @Test
    public final void testJavaConstantName() throws Exception {
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaConstantName(""));
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaConstantName("  "));
        Assert.assertEquals((Object)"TEST_TEST_TEST", (Object)this.getJomcTool().getJavaConstantName("  test test test  "));
        Assert.assertEquals((Object)"TEST_TEST_TEST", (Object)this.getJomcTool().getJavaConstantName("  test  test  test  "));
        Assert.assertEquals((Object)"TEST_T_EST_TE_ST_TES_T", (Object)this.getJomcTool().getJavaConstantName("  Test   tEst   teSt   tesT  "));
    }

    @Test
    public final void testJavaFieldName() throws Exception {
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaFieldName(""));
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaFieldName("  "));
        Assert.assertEquals((Object)"testTestTest", (Object)this.getJomcTool().getJavaFieldName("  test test test  "));
        Assert.assertEquals((Object)"testTestTest", (Object)this.getJomcTool().getJavaFieldName("  test  test  test  "));
        Assert.assertEquals((Object)"testTEstTeStTesT", (Object)this.getJomcTool().getJavaFieldName("  Test tEst teSt tesT  "));
        Assert.assertEquals((Object)"testTEstTeStTesT", (Object)this.getJomcTool().getJavaFieldName("  Test  tEst  teSt  tesT  "));
        Assert.assertEquals((Object)"_package", (Object)this.getJomcTool().getJavaFieldName("  Package "));
        Assert.assertEquals((Object)"_new", (Object)this.getJomcTool().getJavaFieldName("  New "));
    }

    @Test
    public final void testJavaMethodParameterName() throws Exception {
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaMethodParameterName(""));
        Assert.assertEquals((Object)"", (Object)this.getJomcTool().getJavaMethodParameterName("  "));
        Assert.assertEquals((Object)"testTestTest", (Object)this.getJomcTool().getJavaMethodParameterName("  test test test  "));
        Assert.assertEquals((Object)"testTEstTeStTesT", (Object)this.getJomcTool().getJavaMethodParameterName("  Test tEst teSt tesT  "));
        Assert.assertEquals((Object)"testTEstTeStTesT", (Object)this.getJomcTool().getJavaMethodParameterName("  Test  tEst  teSt  tesT  "));
        Assert.assertEquals((Object)"_package", (Object)this.getJomcTool().getJavaMethodParameterName("  Package "));
        Assert.assertEquals((Object)"_new", (Object)this.getJomcTool().getJavaMethodParameterName("  New "));
    }

    @Test
    public final void testToJavaConstantName() throws Exception {
        try {
            this.getJomcTool().toJavaConstantName("");
            Assert.fail((String)"Expected 'ParseException' not thrown.");
        }
        catch (ParseException e) {
            System.out.println(e.toString());
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            this.getJomcTool().toJavaConstantName("  ");
            Assert.fail((String)"Expected 'ParseException' not thrown.");
        }
        catch (ParseException e) {
            System.out.println(e.toString());
            Assert.assertNotNull((Object)e.getMessage());
        }
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"TEST_TEST_TEST"), (Object)this.getJomcTool().toJavaConstantName("  test test test  "));
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"TEST_TEST_TEST_TEST"), (Object)this.getJomcTool().toJavaConstantName("  Test tEst teSt tesT  "));
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"TEST_TEST_TEST_TEST"), (Object)this.getJomcTool().toJavaConstantName("  Test  tEst  teSt  tesT  "));
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"PACKAGE"), (Object)this.getJomcTool().toJavaConstantName("  Package "));
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"NEW"), (Object)this.getJomcTool().toJavaConstantName("  New "));
    }

    @Test
    public final void testToJavaMethodName() throws Exception {
        try {
            this.getJomcTool().toJavaMethodName("");
            Assert.fail((String)"Expected 'ParseException' not thrown.");
        }
        catch (ParseException e) {
            System.out.println(e.toString());
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            this.getJomcTool().toJavaMethodName("  ");
            Assert.fail((String)"Expected 'ParseException' not thrown.");
        }
        catch (ParseException e) {
            System.out.println(e.toString());
            Assert.assertNotNull((Object)e.getMessage());
        }
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"testTestTest"), (Object)this.getJomcTool().toJavaMethodName("  test test test  "));
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"testTestTestTest"), (Object)this.getJomcTool().toJavaMethodName("  Test tEst teSt tesT  "));
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"testTestTestTest"), (Object)this.getJomcTool().toJavaMethodName("  Test  tEst  teSt  tesT  "));
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"_package"), (Object)this.getJomcTool().toJavaMethodName("  Package "));
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"_new"), (Object)this.getJomcTool().toJavaMethodName("  New "));
    }

    @Test
    public final void testToJavaVariableName() throws Exception {
        try {
            this.getJomcTool().toJavaVariableName("");
            Assert.fail((String)"Expected 'ParseException' not thrown.");
        }
        catch (ParseException e) {
            System.out.println(e.toString());
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            this.getJomcTool().toJavaVariableName("  ");
            Assert.fail((String)"Expected 'ParseException' not thrown.");
        }
        catch (ParseException e) {
            System.out.println(e.toString());
            Assert.assertNotNull((Object)e.getMessage());
        }
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"testTestTest"), (Object)this.getJomcTool().toJavaVariableName("  test test test  "));
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"testTestTestTest"), (Object)this.getJomcTool().toJavaVariableName("  Test tEst teSt tesT  "));
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"testTestTestTest"), (Object)this.getJomcTool().toJavaVariableName("  Test  tEst  teSt  tesT  "));
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"_package"), (Object)this.getJomcTool().toJavaVariableName("  Package "));
        Assert.assertEquals((Object)JavaIdentifier.valueOf((String)"_new"), (Object)this.getJomcTool().toJavaVariableName("  New "));
    }

    @Test
    public final void testParentTemplateProfile() throws Exception {
        File templateLocation = this.getNextOutputDirectory();
        File templatesDir = new File(templateLocation, "org");
        templatesDir = new File(templatesDir, "jomc");
        templatesDir = new File(templatesDir, "tools");
        templatesDir = new File(templatesDir, "templates");
        templatesDir = new File(templatesDir, "tmp");
        Assert.assertTrue((boolean)templatesDir.mkdirs());
        Properties p = new Properties();
        p.setProperty("parent-template-profile", "test");
        FileOutputStream profileProperties = new FileOutputStream(new File(templatesDir, "profile.properties"));
        p.store(profileProperties, this.getClass().getName());
        ((OutputStream)profileProperties).close();
        this.getJomcTool();
        JomcTool.setDefaultTemplateProfile(null);
        this.getJomcTool().setTemplateLocation(templateLocation.toURI().toURL());
        Assert.assertEquals((Object)"test", (Object)this.getJomcTool().getParentTemplateProfile("tmp"));
        Assert.assertEquals((Object)"jomc-java-bundles", (Object)this.getJomcTool().getParentTemplateProfile("test"));
        this.getJomcTool();
        Assert.assertEquals((Object)JomcTool.getDefaultTemplateProfile(), (Object)this.getJomcTool().getParentTemplateProfile("jomc-java-bundles"));
        JomcTool jomcTool = this.getJomcTool();
        this.getJomcTool();
        Assert.assertNull((Object)jomcTool.getParentTemplateProfile(JomcTool.getDefaultTemplateProfile()));
        this.getJomcTool().setTemplateLocation(null);
        this.getJomcTool().setDefaultTemplateEncoding(null);
    }

    @Test
    public final void testHtmlString() throws Exception {
        Assert.assertEquals((Object)"&lt;&gt;&quot;&lowast;&amp;", (Object)this.getJomcTool().getHtmlString("<>\"*&"));
    }

    public static void assertNullPointerException(NullPointerException e) {
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getMessage());
        System.out.println(e.toString());
    }

    public static void assertIllegalArgumentException(IllegalArgumentException e) {
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getMessage());
        System.out.println(e.toString());
    }
}

