/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools.modlet.test;

import org.jomc.model.Implementation;
import org.jomc.model.Implementations;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.Specification;
import org.jomc.model.Specifications;
import org.jomc.model.modlet.ModelHelper;
import org.jomc.modlet.Model;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelContextFactory;
import org.jomc.tools.model.SourceFileType;
import org.jomc.tools.model.SourceFilesType;
import org.jomc.tools.model.SourceSectionType;
import org.jomc.tools.model.SourceSectionsType;
import org.jomc.tools.modlet.ToolsModelProcessor;
import org.junit.Assert;
import org.junit.Test;

public class ToolsModelProcessorTest {
    private ToolsModelProcessor toolsModelProcessor;

    public ToolsModelProcessor getModelProcessor() {
        if (this.toolsModelProcessor == null) {
            this.toolsModelProcessor = this.newModelProcessor();
        }
        return this.toolsModelProcessor;
    }

    protected ToolsModelProcessor newModelProcessor() {
        return new ToolsModelProcessor();
    }

    @Test
    public final void testProcessModel() throws Exception {
        ModelContext context = ModelContextFactory.newInstance().newModelContext();
        Model model = new Model();
        model.setIdentifier("http://jomc.org/model");
        Modules modules = new Modules();
        Module module = new Module();
        module.setName(this.getClass().getName());
        module.setSpecifications(new Specifications());
        module.setImplementations(new Implementations());
        Specification specification = new Specification();
        specification.setClassDeclaration(Boolean.valueOf(true));
        specification.setClazz(this.getClass().getName());
        specification.setIdentifier(this.getClass().getName() + " Specification");
        Implementation implementation = new Implementation();
        implementation.setClassDeclaration(Boolean.valueOf(true));
        implementation.setClazz(this.getClass().getName());
        implementation.setIdentifier(this.getClass().getName() + " Implementation");
        implementation.setName(this.getClass().getName() + " Implementation");
        module.getSpecifications().getSpecification().add(specification);
        module.getImplementations().getImplementation().add(implementation);
        modules.getModule().add(module);
        ModelHelper.setModules((Model)model, (Modules)modules);
        try {
            this.getModelProcessor().processModel(null, model);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        try {
            this.getModelProcessor().processModel(context, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        Model processed = this.getModelProcessor().processModel(context, model);
        Assert.assertNotNull((Object)processed);
        modules = ModelHelper.getModules((Model)processed);
        Assert.assertNotNull((Object)modules);
        specification = modules.getSpecification(this.getClass().getName() + " Specification");
        Assert.assertNotNull((Object)specification);
        implementation = modules.getImplementation(this.getClass().getName() + " Implementation");
        Assert.assertNotNull((Object)implementation);
        SourceFileType ss = (SourceFileType)specification.getAnyObject(SourceFileType.class);
        Assert.assertNull((Object)ss);
        SourceFileType is = (SourceFileType)implementation.getAnyObject(SourceFileType.class);
        Assert.assertNull((Object)is);
        ss = new SourceFileType();
        ss.setIdentifier(this.getClass().getName() + " Specification");
        is = new SourceFileType();
        is.setIdentifier(this.getClass().getName() + " Implementation");
        specification.getAny().add(ss);
        implementation.getAny().add(is);
        processed = this.getModelProcessor().processModel(context, processed);
        Assert.assertNotNull((Object)processed);
        modules = ModelHelper.getModules((Model)processed);
        Assert.assertNotNull((Object)modules);
        specification = modules.getSpecification(this.getClass().getName() + " Specification");
        Assert.assertNotNull((Object)specification);
        implementation = modules.getImplementation(this.getClass().getName() + " Implementation");
        Assert.assertNotNull((Object)implementation);
        ss = (SourceFileType)specification.getAnyObject(SourceFileType.class);
        Assert.assertNotNull((Object)ss);
        Assert.assertNotNull((Object)ss.getLocation());
        Assert.assertNotNull((Object)ss.getHeadComment());
        is = (SourceFileType)implementation.getAnyObject(SourceFileType.class);
        Assert.assertNotNull((Object)is);
        Assert.assertNotNull((Object)is.getLocation());
        Assert.assertNotNull((Object)is.getHeadComment());
        specification.getAny().clear();
        implementation.getAny().clear();
        SourceFilesType specificationSourceFiles = new SourceFilesType();
        ss = new SourceFileType();
        ss.setIdentifier(this.getClass().getSimpleName());
        ss.setSourceSections(new SourceSectionsType());
        specificationSourceFiles.getSourceFile().add(ss);
        specification.getAny().add(specificationSourceFiles);
        SourceFilesType implementationSourceFiles = new SourceFilesType();
        is = new SourceFileType();
        is.setIdentifier(this.getClass().getSimpleName());
        is.setSourceSections(new SourceSectionsType());
        implementationSourceFiles.getSourceFile().add(is);
        implementation.getAny().add(implementationSourceFiles);
        SourceSectionType sourceSection = new SourceSectionType();
        sourceSection.setName("License Header");
        ss.getSourceSections().getSourceSection().add(sourceSection);
        is.getSourceSections().getSourceSection().add(sourceSection);
        sourceSection = new SourceSectionType();
        sourceSection.setName("Annotations");
        ss.getSourceSections().getSourceSection().add(sourceSection);
        is.getSourceSections().getSourceSection().add(sourceSection);
        sourceSection = new SourceSectionType();
        sourceSection.setName("Documentation");
        ss.getSourceSections().getSourceSection().add(sourceSection);
        is.getSourceSections().getSourceSection().add(sourceSection);
        sourceSection = new SourceSectionType();
        sourceSection.setName(this.getClass().getSimpleName());
        ss.getSourceSections().getSourceSection().add(sourceSection);
        is.getSourceSections().getSourceSection().add(sourceSection);
        sourceSection = new SourceSectionType();
        sourceSection.setName("Constructors");
        is.getSourceSections().getSourceSection().add(sourceSection);
        sourceSection = new SourceSectionType();
        sourceSection.setName("Default Constructor");
        is.getSourceSections().getSourceSection().add(sourceSection);
        sourceSection = new SourceSectionType();
        sourceSection.setName("Dependencies");
        is.getSourceSections().getSourceSection().add(sourceSection);
        sourceSection = new SourceSectionType();
        sourceSection.setName("Properties");
        is.getSourceSections().getSourceSection().add(sourceSection);
        sourceSection = new SourceSectionType();
        sourceSection.setName("Messages");
        is.getSourceSections().getSourceSection().add(sourceSection);
        processed = this.getModelProcessor().processModel(context, processed);
        Assert.assertNotNull((Object)processed);
        modules = ModelHelper.getModules((Model)processed);
        Assert.assertNotNull((Object)modules);
        specification = modules.getSpecification(this.getClass().getName() + " Specification");
        Assert.assertNotNull((Object)specification);
        implementation = modules.getImplementation(this.getClass().getName() + " Implementation");
        Assert.assertNotNull((Object)implementation);
        specificationSourceFiles = (SourceFilesType)specification.getAnyObject(SourceFilesType.class);
        Assert.assertNotNull((Object)specificationSourceFiles);
        ss = specificationSourceFiles.getSourceFile(this.getClass().getSimpleName());
        Assert.assertNotNull((Object)ss);
        Assert.assertNotNull((Object)ss.getHeadComment());
        Assert.assertNotNull((Object)ss.getLocation());
        Assert.assertNotNull((Object)ss.getTemplate());
        implementationSourceFiles = (SourceFilesType)implementation.getAnyObject(SourceFilesType.class);
        Assert.assertNotNull((Object)implementationSourceFiles);
        is = implementationSourceFiles.getSourceFile(this.getClass().getSimpleName());
        Assert.assertNotNull((Object)is);
        Assert.assertNotNull((Object)is.getHeadComment());
        Assert.assertNotNull((Object)is.getLocation());
        Assert.assertNotNull((Object)is.getTemplate());
        sourceSection = ss.getSourceSections().getSourceSection("License Header");
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertTrue((boolean)sourceSection.isOptional());
        Assert.assertNotNull((Object)sourceSection.getHeadTemplate());
        sourceSection = is.getSourceSections().getSourceSection("License Header");
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertTrue((boolean)sourceSection.isOptional());
        Assert.assertNotNull((Object)sourceSection.getHeadTemplate());
        sourceSection = ss.getSourceSections().getSourceSection("Annotations");
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertNotNull((Object)sourceSection.getHeadTemplate());
        sourceSection = is.getSourceSections().getSourceSection("Annotations");
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertNotNull((Object)sourceSection.getHeadTemplate());
        sourceSection = ss.getSourceSections().getSourceSection("Documentation");
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertTrue((boolean)sourceSection.isOptional());
        Assert.assertNotNull((Object)sourceSection.getHeadTemplate());
        sourceSection = is.getSourceSections().getSourceSection("Documentation");
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertTrue((boolean)sourceSection.isOptional());
        Assert.assertNotNull((Object)sourceSection.getHeadTemplate());
        sourceSection = ss.getSourceSections().getSourceSection(this.getClass().getSimpleName());
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertTrue((boolean)sourceSection.isEditable());
        Assert.assertEquals((long)1L, (long)sourceSection.getIndentationLevel());
        sourceSection = is.getSourceSections().getSourceSection(this.getClass().getSimpleName());
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertTrue((boolean)sourceSection.isEditable());
        Assert.assertEquals((long)1L, (long)sourceSection.getIndentationLevel());
        sourceSection = is.getSourceSections().getSourceSection("Constructors");
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertNotNull((Object)sourceSection.getHeadTemplate());
        Assert.assertNotNull((Object)sourceSection.getTailTemplate());
        Assert.assertEquals((long)1L, (long)sourceSection.getIndentationLevel());
        Assert.assertTrue((boolean)sourceSection.isOptional());
        sourceSection = is.getSourceSections().getSourceSection("Default Constructor");
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertNotNull((Object)sourceSection.getHeadTemplate());
        Assert.assertEquals((long)2L, (long)sourceSection.getIndentationLevel());
        Assert.assertTrue((boolean)sourceSection.isEditable());
        sourceSection = is.getSourceSections().getSourceSection("Dependencies");
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertNotNull((Object)sourceSection.getHeadTemplate());
        Assert.assertEquals((long)1L, (long)sourceSection.getIndentationLevel());
        Assert.assertTrue((boolean)sourceSection.isOptional());
        sourceSection = is.getSourceSections().getSourceSection("Properties");
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertNotNull((Object)sourceSection.getHeadTemplate());
        Assert.assertEquals((long)1L, (long)sourceSection.getIndentationLevel());
        Assert.assertTrue((boolean)sourceSection.isOptional());
        sourceSection = is.getSourceSections().getSourceSection("Messages");
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertNotNull((Object)sourceSection.getHeadTemplate());
        Assert.assertEquals((long)1L, (long)sourceSection.getIndentationLevel());
        Assert.assertTrue((boolean)sourceSection.isOptional());
        sourceSection = is.getSourceSections().getSourceSection(this.getClass().getSimpleName());
        Assert.assertNotNull((Object)sourceSection);
        Assert.assertEquals((long)1L, (long)sourceSection.getIndentationLevel());
        Assert.assertTrue((boolean)sourceSection.isEditable());
    }

    @Test
    public final void testDefaultEnabled() throws Exception {
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProcessor.defaultEnabled");
        ToolsModelProcessor.setDefaultEnabled(null);
        Assert.assertTrue((boolean)ToolsModelProcessor.isDefaultEnabled());
        System.setProperty("org.jomc.tools.modlet.ToolsModelProcessor.defaultEnabled", Boolean.toString(false));
        ToolsModelProcessor.setDefaultEnabled(null);
        Assert.assertFalse((boolean)ToolsModelProcessor.isDefaultEnabled());
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProcessor.defaultEnabled");
        ToolsModelProcessor.setDefaultEnabled(null);
        Assert.assertTrue((boolean)ToolsModelProcessor.isDefaultEnabled());
        System.setProperty("org.jomc.tools.modlet.ToolsModelProcessor.defaultEnabled", Boolean.toString(true));
        ToolsModelProcessor.setDefaultEnabled(null);
        Assert.assertTrue((boolean)ToolsModelProcessor.isDefaultEnabled());
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProcessor.defaultEnabled");
        ToolsModelProcessor.setDefaultEnabled(null);
        Assert.assertTrue((boolean)ToolsModelProcessor.isDefaultEnabled());
    }

    @Test
    public final void testEnabled() throws Exception {
        Model model = new Model();
        model.setIdentifier("http://jomc.org/model");
        ToolsModelProcessor.setDefaultEnabled(null);
        this.getModelProcessor().setEnabled(null);
        Assert.assertTrue((boolean)this.getModelProcessor().isEnabled());
        this.getModelProcessor().processModel(ModelContextFactory.newInstance().newModelContext(), model);
        ToolsModelProcessor.setDefaultEnabled((Boolean)false);
        this.getModelProcessor().setEnabled(null);
        Assert.assertFalse((boolean)this.getModelProcessor().isEnabled());
        this.getModelProcessor().processModel(ModelContextFactory.newInstance().newModelContext(), model);
        ToolsModelProcessor.setDefaultEnabled(null);
        this.getModelProcessor().setEnabled(null);
    }

    @Test
    public final void testDefaultHeadComment() throws Exception {
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProcessor.defaultHeadComment");
        ToolsModelProcessor.setDefaultHeadComment(null);
        Assert.assertEquals((Object)"//", (Object)ToolsModelProcessor.getDefaultHeadComment());
        System.setProperty("org.jomc.tools.modlet.ToolsModelProcessor.defaultHeadComment", "/*");
        ToolsModelProcessor.setDefaultHeadComment(null);
        Assert.assertEquals((Object)"/*", (Object)ToolsModelProcessor.getDefaultHeadComment());
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProcessor.defaultHeadComment");
        ToolsModelProcessor.setDefaultHeadComment(null);
        Assert.assertEquals((Object)"//", (Object)ToolsModelProcessor.getDefaultHeadComment());
    }

    @Test
    public final void testHeadComment() throws Exception {
        ToolsModelProcessor.setDefaultHeadComment(null);
        this.getModelProcessor().setHeadComment(null);
        Assert.assertEquals((Object)"//", (Object)this.getModelProcessor().getHeadComment());
        ToolsModelProcessor.setDefaultHeadComment((String)"/*");
        this.getModelProcessor().setHeadComment(null);
        Assert.assertEquals((Object)"/*", (Object)this.getModelProcessor().getHeadComment());
        ToolsModelProcessor.setDefaultHeadComment(null);
        this.getModelProcessor().setHeadComment(null);
        Assert.assertEquals((Object)"//", (Object)this.getModelProcessor().getHeadComment());
    }

    @Test
    public final void testDefaultTailComment() throws Exception {
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProcessor.defaultTailComment");
        ToolsModelProcessor.setDefaultTailComment(null);
        Assert.assertNull((Object)ToolsModelProcessor.getDefaultTailComment());
        System.setProperty("org.jomc.tools.modlet.ToolsModelProcessor.defaultTailComment", "*/");
        ToolsModelProcessor.setDefaultTailComment(null);
        Assert.assertEquals((Object)"*/", (Object)ToolsModelProcessor.getDefaultTailComment());
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProcessor.defaultTailComment");
        ToolsModelProcessor.setDefaultTailComment(null);
        Assert.assertNull((Object)ToolsModelProcessor.getDefaultTailComment());
    }

    @Test
    public final void testTailComment() throws Exception {
        ToolsModelProcessor.setDefaultTailComment(null);
        this.getModelProcessor().setTailComment(null);
        Assert.assertNull((Object)this.getModelProcessor().getTailComment());
        ToolsModelProcessor.setDefaultTailComment((String)"*/");
        this.getModelProcessor().setTailComment(null);
        Assert.assertEquals((Object)"*/", (Object)this.getModelProcessor().getTailComment());
        ToolsModelProcessor.setDefaultTailComment(null);
        this.getModelProcessor().setTailComment(null);
        Assert.assertNull((Object)this.getModelProcessor().getTailComment());
    }
}

