/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools.model.test;

import java.lang.reflect.InvocationTargetException;
import org.jomc.model.ModelObjectException;
import org.jomc.tools.model.TemplateParameterType;
import org.junit.Assert;
import org.junit.Test;

public class TemplateParameterTypeTest {
    @Test
    public final void testGetJavaValue() throws Exception {
        TemplateParameterType p = new TemplateParameterType();
        Assert.assertNull((Object)p.getJavaValue(this.getClass().getClassLoader()));
        p.setAny(new Object());
        try {
            p.getJavaValue(this.getClass().getClassLoader());
            Assert.fail((String)"Expected ModelObjectException not thrown for missing mandatory type.");
        }
        catch (ModelObjectException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println((Object)e);
        }
        p.setType(UnsupportedJavaValue.class.getName());
        p.setAny((Object)new UnsupportedJavaValue());
        try {
            p.getJavaValue(this.getClass().getClassLoader());
            Assert.fail((String)"Expected ModelObjectException not thrown for unsupported getJavaValue operation.");
        }
        catch (ModelObjectException e) {
            Assert.assertNotNull((Object)e.getMessage());
            Assert.assertTrue((boolean)(e.getCause() instanceof InvocationTargetException));
            System.out.println((Object)e);
            System.out.println(e.getCause());
        }
        p.setType(Object.class.getName());
        p.setAny(new Object(){

            public Object getJavaValue(ClassLoader classLoader) {
                return new Object();
            }
        });
        try {
            p.getJavaValue(this.getClass().getClassLoader());
            Assert.fail((String)"Expected ModelObjectException not thrown for inaccessible getJavaValue method.");
        }
        catch (ModelObjectException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println((Object)e);
            System.out.println(e.getCause());
        }
        p.setType("java.lang.String");
        p.setAny((Object)new ObjectJavaValue());
        try {
            p.getJavaValue(this.getClass().getClassLoader());
            Assert.fail((String)"Expected ModelObjectException not thrown for incompatible getJavaValue method.");
        }
        catch (ModelObjectException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println((Object)e);
        }
        p.setType("int");
        p.setAny(null);
        p.setValue(null);
        try {
            p.getJavaValue(this.getClass().getClassLoader());
            Assert.fail((String)"Expected ModelObjectException not thrown for mandatory primitive value.");
        }
        catch (ModelObjectException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println((Object)e);
        }
        p.setType("DOES_NOT_EXIST");
        p.setAny(null);
        p.setValue("STRING VALUE");
        try {
            p.getJavaValue(this.getClass().getClassLoader());
            Assert.fail((String)"Expected ModelObjectException not thrown for missing class.");
        }
        catch (ModelObjectException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println((Object)e);
        }
        p.setType("char");
        p.setValue("NO CHAR VALUE");
        try {
            p.getJavaValue(this.getClass().getClassLoader());
            Assert.fail((String)"Expected ModelObjectException not thrown for illegal char value.");
        }
        catch (ModelObjectException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println((Object)e);
        }
        p.setType(AbstractJavaValue.class.getName());
        p.setAny(null);
        p.setValue("STRING VALUE");
        try {
            p.getJavaValue(this.getClass().getClassLoader());
            Assert.fail((String)"Expected ModelObjectException not thrown for non-instantiable class.");
        }
        catch (ModelObjectException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println((Object)e);
        }
        p.setType(ObjectJavaValue.class.getName());
        p.setAny(null);
        p.setValue("STRING VALUE");
        try {
            p.getJavaValue(this.getClass().getClassLoader());
            Assert.fail((String)"Expected ModelObjectException not thrown for missing constructor.");
        }
        catch (ModelObjectException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println((Object)e);
        }
        p.setType(UnsupportedJavaValue.class.getName());
        p.setAny(null);
        p.setValue("STRING VALUE");
        try {
            p.getJavaValue(this.getClass().getClassLoader());
            Assert.fail((String)"Expected ModelObjectException not thrown for unsupported constructor.");
        }
        catch (ModelObjectException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println((Object)e);
        }
        p.setType(InaccessibleJavaValue.class.getName());
        p.setAny(null);
        p.setValue("STRING VALUE");
        try {
            p.getJavaValue(this.getClass().getClassLoader());
            Assert.fail((String)"Expected ModelObjectException not thrown for inaccessible constructor.");
        }
        catch (ModelObjectException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println((Object)e);
        }
        p.setType(Thread.State.class.getName());
        p.setAny(null);
        p.setValue("RUNNABLE");
        Assert.assertEquals((Object)((Object)Thread.State.RUNNABLE), (Object)p.getJavaValue(this.getClass().getClassLoader()));
        p.setType(FactoryMethodTestClass.class.getName());
        p.setAny(null);
        p.setValue("TEST");
        try {
            p.getJavaValue(this.getClass().getClassLoader());
            Assert.fail((String)"Expected ModelObjectException not thrown for illegal factory method.");
        }
        catch (ModelObjectException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println((Object)e);
        }
    }

    private static class FactoryMethodTestClass {
        private FactoryMethodTestClass() {
        }

        public static Object valueOf(String string) {
            return null;
        }
    }

    private static class InaccessibleJavaValue {
        private InaccessibleJavaValue(String value) {
        }

        private Object getJavaValue(ClassLoader classLoader) {
            return null;
        }
    }

    public static class ObjectJavaValue {
        public Object getJavaValue(ClassLoader classLoader) {
            return new Object();
        }
    }

    public static class UnsupportedJavaValue {
        public UnsupportedJavaValue() {
        }

        public UnsupportedJavaValue(String value) {
            throw new UnsupportedOperationException();
        }

        public Object getJavaValue(ClassLoader classLoader) {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class AbstractJavaValue {
        public AbstractJavaValue(String value) {
        }
    }
}

