/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jomc.model.Dependency;
import org.jomc.model.Implementation;
import org.jomc.model.Message;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.Multiplicity;
import org.jomc.model.Property;
import org.jomc.model.Specification;
import org.jomc.model.modlet.DefaultModelProvider;
import org.jomc.model.modlet.ModelHelper;
import org.jomc.modlet.Model;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelContextFactory;
import org.jomc.modlet.ModelException;
import org.jomc.tools.ClassFileProcessor;
import org.jomc.tools.ResourceFileProcessor;
import org.jomc.tools.SourceFileProcessor;
import org.jomc.tools.test.JomcToolTest;
import org.junit.Assert;
import org.junit.Test;

public class ClassFileProcessorTest
extends JomcToolTest {
    public ClassFileProcessor getJomcTool() {
        return (ClassFileProcessor)super.getJomcTool();
    }

    protected ClassFileProcessor newJomcTool() {
        return new ClassFileProcessor();
    }

    protected Model newModel() {
        try {
            DefaultModelProvider.setDefaultModuleLocation((String)(this.getClass().getPackage().getName().replace('.', '/') + "/jomc-tools.xml"));
            Model m = this.getModelContext().findModel("http://jomc.org/model");
            if (m != null) {
                Module cp;
                Modules modules = ModelHelper.getModules((Model)m);
                if (modules != null && (cp = modules.getClasspathModule(Modules.getDefaultClasspathModuleName(), this.getClass().getClassLoader())) != null) {
                    modules.getModule().add(cp);
                }
                m = this.getModelContext().processModel(m);
            }
            Model model = m;
            return model;
        }
        catch (ModelException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            DefaultModelProvider.setDefaultModuleLocation(null);
        }
    }

    public final File getNextClassesDirectory() {
        try {
            File classesDirectory = this.getNextOutputDirectory();
            this.unzipResource("classfiles.zip", classesDirectory);
            return classesDirectory;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testClassFileProcessorNullPointerException() throws Exception {
        Marshaller marshaller = this.getModelContext().createMarshaller("http://jomc.org/model");
        Unmarshaller unmarshaller = this.getModelContext().createUnmarshaller("http://jomc.org/model");
        URL object = this.getClass().getResource("/java/lang/Object.class");
        InputStream in = null;
        JavaClass objectClass = null;
        boolean suppressExceptionOnClose = true;
        try {
            in = object.openStream();
            objectClass = new ClassParser(in, object.toExternalForm()).parse();
            suppressExceptionOnClose = false;
        }
        finally {
            block159: {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    if (suppressExceptionOnClose) break block159;
                    throw e;
                }
            }
        }
        try {
            this.getJomcTool().commitModelObjects(null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects(this.getModelContext(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects((Implementation)null, (ModelContext)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects(new Implementation(), (ModelContext)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects(new Implementation(), this.getModelContext(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects((Implementation)null, (Marshaller)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects(new Implementation(), (Marshaller)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects(new Implementation(), marshaller, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects((Module)null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects(new Module(), null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects(new Module(), this.getModelContext(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects((Specification)null, (ModelContext)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects(new Specification(), (ModelContext)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects(new Specification(), this.getModelContext(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects((Specification)null, (Marshaller)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects(new Specification(), (Marshaller)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().commitModelObjects(new Specification(), marshaller, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().decodeModelObject(null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().decodeModelObject(unmarshaller, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().decodeModelObject(unmarshaller, new byte[0], null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().encodeModelObject(null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().encodeModelObject(marshaller, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getClassfileAttribute(null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getClassfileAttribute(objectClass, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().setClassfileAttribute(null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().setClassfileAttribute(objectClass, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(this.getModelContext(), null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(this.getModelContext(), new File("/"), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects((Module)null, null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Module(), null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Module(), this.getModelContext(), null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Module(), this.getModelContext(), new File("/"), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects((Specification)null, null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Specification(), null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Specification(), this.getModelContext(), null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Specification(), this.getModelContext(), new File("/"), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects((Implementation)null, null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Implementation(), null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Implementation(), this.getModelContext(), null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Implementation(), this.getModelContext(), new File("/"), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects((Specification)null, null, null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Specification(), null, null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Specification(), marshaller, null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Specification(), marshaller, unmarshaller, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Specification(), marshaller, unmarshaller, objectClass, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects((Implementation)null, null, null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Implementation(), null, null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Implementation(), marshaller, null, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Implementation(), marshaller, unmarshaller, null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().transformModelObjects(new Implementation(), marshaller, unmarshaller, objectClass, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(null, (File)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(this.getModelContext(), (File)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects((Module)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Module(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects((Module)null, null, (File)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Module(), null, (File)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Module(), this.getModelContext(), (File)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects((Specification)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Specification(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects((Specification)null, (ModelContext)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Specification(), (ModelContext)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Specification(), this.getModelContext(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects((Implementation)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Implementation(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects((Implementation)null, (ModelContext)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Implementation(), (ModelContext)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Implementation(), this.getModelContext(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects((Specification)null, (Unmarshaller)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Specification(), (Unmarshaller)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Specification(), unmarshaller, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects((Implementation)null, (Unmarshaller)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Implementation(), (Unmarshaller)null, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().validateModelObjects(new Implementation(), unmarshaller, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ClassFileProcessorTest.assertNullPointerException(e);
        }
    }

    @Test
    public final void testCommitTransformValidateClasses() throws Exception {
        File nonExistentDirectory = this.getNextOutputDirectory();
        File emptyDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)emptyDirectory.mkdirs());
        File allClasses = this.getNextClassesDirectory();
        URLClassLoader allClassesLoader = new URLClassLoader(new URL[]{allClasses.toURI().toURL()});
        File moduleClasses = this.getNextClassesDirectory();
        URLClassLoader moduleClassesLoader = new URLClassLoader(new URL[]{moduleClasses.toURI().toURL()});
        File implementationClasses = this.getNextClassesDirectory();
        URLClassLoader implementationClassesLoader = new URLClassLoader(new URL[]{implementationClasses.toURI().toURL()});
        File specificationClasses = this.getNextClassesDirectory();
        URLClassLoader specificationClassesLoader = new URLClassLoader(new URL[]{specificationClasses.toURI().toURL()});
        File uncommittedClasses = this.getNextClassesDirectory();
        URLClassLoader uncommittedClassesLoader = new URLClassLoader(new URL[]{uncommittedClasses.toURI().toURL()});
        Module m = this.getJomcTool().getModules().getModule("JOMC Tools");
        Specification s = this.getJomcTool().getModules().getSpecification("org.jomc.tools.ClassFileProcessor");
        Implementation i = this.getJomcTool().getModules().getImplementation("org.jomc.tools.ClassFileProcessor");
        Assert.assertNotNull((Object)m);
        Assert.assertNotNull((Object)s);
        Assert.assertNotNull((Object)i);
        List<Transformer> transformers = Arrays.asList(this.getTransformer("no-op.xsl"));
        List<Transformer> illegalSpecificationTransformers = Arrays.asList(this.getTransformer("illegal-specification-transformation.xsl"));
        List<Transformer> illegalSpecificationsTransformers = Arrays.asList(this.getTransformer("illegal-specifications-transformation.xsl"));
        List<Transformer> illegalDependenciesTransformers = Arrays.asList(this.getTransformer("illegal-dependencies-transformation.xsl"));
        List<Transformer> illegalMessagesTransformers = Arrays.asList(this.getTransformer("illegal-messages-transformation.xsl"));
        List<Transformer> illegalPropertiesTransformers = Arrays.asList(this.getTransformer("illegal-properties-transformation.xsl"));
        try {
            this.getJomcTool().commitModelObjects(this.getModelContext(), nonExistentDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().commitModelObjects(this.getModelContext(), emptyDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().commitModelObjects(m, this.getModelContext(), nonExistentDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().commitModelObjects(m, this.getModelContext(), emptyDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().commitModelObjects(s, this.getModelContext(), nonExistentDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().commitModelObjects(s, this.getModelContext(), emptyDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().commitModelObjects(i, this.getModelContext(), nonExistentDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().commitModelObjects(i, this.getModelContext(), emptyDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(this.getModelContext(), nonExistentDirectory, transformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(this.getModelContext(), emptyDirectory, transformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(m, this.getModelContext(), nonExistentDirectory, transformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(m, this.getModelContext(), emptyDirectory, transformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(s, this.getModelContext(), nonExistentDirectory, transformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(s, this.getModelContext(), emptyDirectory, transformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(i, this.getModelContext(), nonExistentDirectory, transformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(i, this.getModelContext(), emptyDirectory, transformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(this.getModelContext(), nonExistentDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(this.getModelContext(), emptyDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(m, this.getModelContext(), nonExistentDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(m, this.getModelContext(), emptyDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(s, this.getModelContext(), nonExistentDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(s, this.getModelContext(), emptyDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(i, this.getModelContext(), nonExistentDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(i, this.getModelContext(), emptyDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        this.getJomcTool().commitModelObjects(this.getModelContext(), allClasses);
        this.getJomcTool().commitModelObjects(m, this.getModelContext(), moduleClasses);
        this.getJomcTool().commitModelObjects(s, this.getModelContext(), specificationClasses);
        this.getJomcTool().commitModelObjects(i, this.getModelContext(), implementationClasses);
        try {
            this.getJomcTool().transformModelObjects(this.getModelContext(), allClasses, illegalSpecificationTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(this.getModelContext(), allClasses, illegalSpecificationsTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(this.getModelContext(), allClasses, illegalDependenciesTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(this.getModelContext(), allClasses, illegalMessagesTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(this.getModelContext(), allClasses, illegalPropertiesTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(m, this.getModelContext(), moduleClasses, illegalSpecificationTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(m, this.getModelContext(), moduleClasses, illegalSpecificationsTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(m, this.getModelContext(), moduleClasses, illegalDependenciesTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(m, this.getModelContext(), moduleClasses, illegalMessagesTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(m, this.getModelContext(), moduleClasses, illegalPropertiesTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(s, this.getModelContext(), specificationClasses, illegalSpecificationTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(i, this.getModelContext(), implementationClasses, illegalSpecificationsTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(i, this.getModelContext(), implementationClasses, illegalDependenciesTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(i, this.getModelContext(), implementationClasses, illegalMessagesTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().transformModelObjects(i, this.getModelContext(), implementationClasses, illegalPropertiesTransformers);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        this.getJomcTool().transformModelObjects(this.getModelContext(), allClasses, transformers);
        this.getJomcTool().transformModelObjects(m, this.getModelContext(), moduleClasses, transformers);
        this.getJomcTool().transformModelObjects(s, this.getModelContext(), specificationClasses, transformers);
        this.getJomcTool().transformModelObjects(i, this.getModelContext(), implementationClasses, transformers);
        this.getJomcTool().validateModelObjects(ModelContextFactory.newInstance().newModelContext((ClassLoader)allClassesLoader));
        this.getJomcTool().validateModelObjects(m, ModelContextFactory.newInstance().newModelContext((ClassLoader)moduleClassesLoader));
        this.getJomcTool().validateModelObjects(s, ModelContextFactory.newInstance().newModelContext((ClassLoader)specificationClassesLoader));
        this.getJomcTool().validateModelObjects(i, ModelContextFactory.newInstance().newModelContext((ClassLoader)implementationClassesLoader));
        this.getJomcTool().validateModelObjects(this.getModelContext(), allClasses);
        this.getJomcTool().validateModelObjects(m, this.getModelContext(), moduleClasses);
        this.getJomcTool().validateModelObjects(s, this.getModelContext(), specificationClasses);
        this.getJomcTool().validateModelObjects(i, this.getModelContext(), implementationClasses);
        this.getJomcTool().validateModelObjects(ModelContextFactory.newInstance().newModelContext((ClassLoader)uncommittedClassesLoader));
        this.getJomcTool().validateModelObjects(this.getModelContext(), uncommittedClasses);
        Model model = this.getJomcTool().getModel();
        Model copy = model.clone();
        Modules modules = ModelHelper.getModules((Model)copy);
        Module testModule = modules.getModule("JOMC Tools");
        Assert.assertNotNull((Object)testModule);
        Specification classFileProcessor = testModule.getSpecifications().getSpecification(ClassFileProcessor.class.getName());
        Specification resourceFileProcessor = testModule.getSpecifications().getSpecification(ResourceFileProcessor.class.getName());
        Specification sourceFileProcessor = testModule.getSpecifications().getSpecification(SourceFileProcessor.class.getName());
        Implementation classFileProcessorImpl = testModule.getImplementations().getImplementation(ClassFileProcessor.class.getName());
        Implementation resourceFileProcessorImpl = testModule.getImplementations().getImplementation(ResourceFileProcessor.class.getName());
        Implementation sourceFileProcessorImpl = testModule.getImplementations().getImplementation(SourceFileProcessor.class.getName());
        Assert.assertNotNull((Object)classFileProcessor);
        Assert.assertNotNull((Object)resourceFileProcessor);
        Assert.assertNotNull((Object)sourceFileProcessor);
        Assert.assertNotNull((Object)classFileProcessorImpl);
        Assert.assertNotNull((Object)resourceFileProcessorImpl);
        Assert.assertNotNull((Object)sourceFileProcessorImpl);
        classFileProcessor.setMultiplicity(Multiplicity.ONE);
        classFileProcessor.setScope("TEST");
        resourceFileProcessor.setMultiplicity(Multiplicity.ONE);
        resourceFileProcessor.setScope("TEST");
        sourceFileProcessor.setMultiplicity(Multiplicity.ONE);
        sourceFileProcessor.setScope("TEST");
        Property p = classFileProcessorImpl.getProperties().getProperty("TestStringProperty");
        Assert.assertNotNull((Object)p);
        Assert.assertNotNull((Object)classFileProcessorImpl.getProperties().getProperty().remove(p));
        p = classFileProcessorImpl.getProperties().getProperty("TestPrimitiveProperty");
        Assert.assertNotNull((Object)p);
        p.setType(null);
        p = resourceFileProcessorImpl.getProperties().getProperty("TestStringProperty");
        Assert.assertNotNull((Object)p);
        Assert.assertNotNull((Object)resourceFileProcessorImpl.getProperties().getProperty().remove(p));
        p = resourceFileProcessorImpl.getProperties().getProperty("TestPrimitiveProperty");
        Assert.assertNotNull((Object)p);
        p.setType(null);
        p = sourceFileProcessorImpl.getProperties().getProperty("TestStringProperty");
        Assert.assertNotNull((Object)p);
        Assert.assertNotNull((Object)sourceFileProcessorImpl.getProperties().getProperty().remove(p));
        p = sourceFileProcessorImpl.getProperties().getProperty("TestPrimitiveProperty");
        Assert.assertNotNull((Object)p);
        p.setType(null);
        Message message = classFileProcessorImpl.getMessages().getMessage("TestMessage");
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)classFileProcessorImpl.getMessages().getMessage().remove(message));
        message = resourceFileProcessorImpl.getMessages().getMessage("TestMessage");
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)resourceFileProcessorImpl.getMessages().getMessage().remove(message));
        message = sourceFileProcessorImpl.getMessages().getMessage("TestMessage");
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)sourceFileProcessorImpl.getMessages().getMessage().remove(message));
        Dependency dependency = classFileProcessorImpl.getDependencies().getDependency("Locale");
        Assert.assertNotNull((Object)dependency);
        dependency.setImplementationName(null);
        dependency.setVersion(Integer.toString(Integer.MAX_VALUE));
        dependency = classFileProcessorImpl.getDependencies().getDependency("JavaClasses");
        Assert.assertNotNull((Object)dependency);
        Assert.assertNotNull((Object)classFileProcessorImpl.getDependencies().getDependency().remove(dependency));
        dependency = resourceFileProcessorImpl.getDependencies().getDependency("Locale");
        Assert.assertNotNull((Object)dependency);
        dependency.setImplementationName(null);
        dependency.setVersion(Integer.toString(Integer.MAX_VALUE));
        dependency = resourceFileProcessorImpl.getDependencies().getDependency("JavaBundles");
        Assert.assertNotNull((Object)dependency);
        Assert.assertNotNull((Object)resourceFileProcessorImpl.getDependencies().getDependency().remove(dependency));
        dependency = sourceFileProcessorImpl.getDependencies().getDependency("Locale");
        Assert.assertNotNull((Object)dependency);
        dependency.setImplementationName(null);
        dependency.setVersion(Integer.toString(Integer.MAX_VALUE));
        dependency = sourceFileProcessorImpl.getDependencies().getDependency("JavaSources");
        Assert.assertNotNull((Object)dependency);
        Assert.assertNotNull((Object)sourceFileProcessorImpl.getDependencies().getDependency().remove(dependency));
        this.getJomcTool().setModel(copy);
        this.getJomcTool().validateModelObjects(ModelContextFactory.newInstance().newModelContext((ClassLoader)allClassesLoader));
        this.getJomcTool().validateModelObjects(testModule, ModelContextFactory.newInstance().newModelContext((ClassLoader)moduleClassesLoader));
        this.getJomcTool().validateModelObjects(classFileProcessor, ModelContextFactory.newInstance().newModelContext((ClassLoader)specificationClassesLoader));
        this.getJomcTool().validateModelObjects(classFileProcessorImpl, ModelContextFactory.newInstance().newModelContext((ClassLoader)implementationClassesLoader));
        this.getJomcTool().validateModelObjects(this.getModelContext(), allClasses);
        this.getJomcTool().validateModelObjects(testModule, this.getModelContext(), moduleClasses);
        this.getJomcTool().validateModelObjects(classFileProcessor, this.getModelContext(), specificationClasses);
        this.getJomcTool().validateModelObjects(classFileProcessorImpl, this.getModelContext(), implementationClasses);
        this.getJomcTool().validateModelObjects(ModelContextFactory.newInstance().newModelContext((ClassLoader)uncommittedClassesLoader));
        this.getJomcTool().validateModelObjects(this.getModelContext(), uncommittedClasses);
        classFileProcessor.setClazz(this.getClass().getPackage().getName() + ".DoesNotExist");
        classFileProcessorImpl.setClazz(this.getClass().getPackage().getName() + ".DoesNotExist");
        resourceFileProcessor.setClazz(this.getClass().getPackage().getName() + ".DoesNotExist");
        resourceFileProcessorImpl.setClazz(this.getClass().getPackage().getName() + ".DoesNotExist");
        sourceFileProcessor.setClazz(this.getClass().getPackage().getName() + ".DoesNotExist");
        sourceFileProcessorImpl.setClazz(this.getClass().getPackage().getName() + ".DoesNotExist");
        try {
            this.getJomcTool().validateModelObjects(ModelContextFactory.newInstance().newModelContext((ClassLoader)allClassesLoader));
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(testModule, ModelContextFactory.newInstance().newModelContext((ClassLoader)moduleClassesLoader));
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(classFileProcessor, ModelContextFactory.newInstance().newModelContext((ClassLoader)specificationClassesLoader));
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(classFileProcessorImpl, ModelContextFactory.newInstance().newModelContext((ClassLoader)implementationClassesLoader));
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(this.getModelContext(), allClasses);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(testModule, this.getModelContext(), moduleClasses);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(classFileProcessor, this.getModelContext(), specificationClasses);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(classFileProcessorImpl, this.getModelContext(), implementationClasses);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(ModelContextFactory.newInstance().newModelContext((ClassLoader)uncommittedClassesLoader));
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().validateModelObjects(this.getModelContext(), uncommittedClasses);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        this.getJomcTool().setModel(model);
    }

    @Test
    public final void testCopyConstructor() throws Exception {
        try {
            new ClassFileProcessor(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        new ClassFileProcessor(this.getJomcTool());
    }

    private Transformer getTransformer(String resource) throws URISyntaxException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        URL url = this.getClass().getResource(resource);
        Assert.assertNotNull((Object)url);
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(url.toURI().toASCIIString()));
        return transformer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipResource(String resourceName, File targetDirectory) throws IOException {
        URL resource = this.getClass().getResource(resourceName);
        Assert.assertNotNull((String)("Expected '" + resourceName + "' not found."), (Object)resource);
        Assert.assertTrue((boolean)targetDirectory.isAbsolute());
        FileUtils.deleteDirectory((File)targetDirectory);
        Assert.assertTrue((boolean)targetDirectory.mkdirs());
        ZipInputStream in = null;
        boolean suppressExceptionOnClose = true;
        try {
            ZipEntry e;
            in = new ZipInputStream(resource.openStream());
            while ((e = in.getNextEntry()) != null) {
                if (e.isDirectory()) continue;
                File dest = new File(targetDirectory, e.getName());
                Assert.assertTrue((boolean)dest.isAbsolute());
                FileOutputStream out = null;
                try {
                    out = FileUtils.openOutputStream((File)dest);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    suppressExceptionOnClose = false;
                }
                finally {
                    block18: {
                        try {
                            if (out != null) {
                                ((OutputStream)out).close();
                            }
                            suppressExceptionOnClose = true;
                        }
                        catch (IOException ex) {
                            if (suppressExceptionOnClose) break block18;
                            throw ex;
                        }
                    }
                }
                in.closeEntry();
            }
            suppressExceptionOnClose = false;
        }
        finally {
            block20: {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    if (suppressExceptionOnClose) break block20;
                    throw e;
                }
            }
        }
    }
}

