/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools.modlet.test;

import java.util.List;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.jomc.model.Dependencies;
import org.jomc.model.Dependency;
import org.jomc.model.Implementation;
import org.jomc.model.Implementations;
import org.jomc.model.Message;
import org.jomc.model.Messages;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.Specification;
import org.jomc.model.Specifications;
import org.jomc.model.Text;
import org.jomc.model.Texts;
import org.jomc.model.modlet.ModelHelper;
import org.jomc.modlet.Model;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelContextFactory;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.tools.model.ObjectFactory;
import org.jomc.tools.model.SourceFileType;
import org.jomc.tools.model.SourceFilesType;
import org.jomc.tools.model.SourceSectionType;
import org.jomc.tools.model.SourceSectionsType;
import org.jomc.tools.modlet.ToolsModelValidator;
import org.junit.Assert;
import org.junit.Test;

public class ToolsModelValidatorTest {
    private ToolsModelValidator toolsModelValidator;

    public ToolsModelValidator getModelValidator() {
        if (this.toolsModelValidator == null) {
            this.toolsModelValidator = this.newModelValidator();
        }
        return this.toolsModelValidator;
    }

    protected ToolsModelValidator newModelValidator() {
        return new ToolsModelValidator();
    }

    @Test
    public final void testValidateModel() throws Exception {
        ModelContext modelContext = ModelContextFactory.newInstance().newModelContext();
        try {
            this.getModelValidator().validateModel(modelContext, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        try {
            this.getModelValidator().validateModel(null, new Model());
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        ModelValidationReport report = this.getModelValidator().validateModel(modelContext, new Model());
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((boolean)report.isModelValid());
        Model model = new Model();
        model.setIdentifier("http://jomc.org/model");
        SourceFileType sourceFile1 = new SourceFileType();
        sourceFile1.setIdentifier(this.getClass().getSimpleName() + " 1");
        SourceFileType sourceFile2 = new SourceFileType();
        sourceFile2.setIdentifier(this.getClass().getSimpleName() + " 2");
        SourceFilesType sourceFiles1 = new SourceFilesType();
        sourceFiles1.getSourceFile().add(sourceFile1);
        sourceFiles1.getSourceFile().add(sourceFile2);
        SourceFilesType sourceFiles2 = new SourceFilesType();
        sourceFiles2.getSourceFile().add(sourceFile1);
        sourceFiles2.getSourceFile().add(sourceFile2);
        SourceSectionType sourceSection1 = new SourceSectionType();
        sourceSection1.setName(this.getClass().getSimpleName() + " 1");
        SourceSectionType sourceSection2 = new SourceSectionType();
        sourceSection2.setName(this.getClass().getSimpleName() + " 2");
        SourceSectionsType sourceSections1 = new SourceSectionsType();
        sourceSections1.getSourceSection().add(sourceSection1);
        sourceSections1.getSourceSection().add(sourceSection2);
        SourceSectionsType sourceSections2 = new SourceSectionsType();
        sourceSections2.getSourceSection().add(sourceSection1);
        sourceSections2.getSourceSection().add(sourceSection2);
        model.getAny().add(new ObjectFactory().createSourceFile(sourceFile1));
        model.getAny().add(new ObjectFactory().createSourceFile(sourceFile2));
        model.getAny().add(new ObjectFactory().createSourceFiles(sourceFiles1));
        model.getAny().add(new ObjectFactory().createSourceFiles(sourceFiles2));
        model.getAny().add(new ObjectFactory().createSourceFiles(new SourceFilesType()));
        model.getAny().add(new ObjectFactory().createSourceSection(sourceSection1));
        model.getAny().add(new ObjectFactory().createSourceSection(sourceSection2));
        model.getAny().add(new ObjectFactory().createSourceSections(sourceSections1));
        model.getAny().add(new ObjectFactory().createSourceSections(sourceSections2));
        model.getAny().add(new ObjectFactory().createSourceSections(new SourceSectionsType()));
        Modules modules = new Modules();
        ModelHelper.setModules((Model)model, (Modules)modules);
        Module module = new Module();
        modules.getModule().add(module);
        module.setSpecifications(new Specifications());
        module.setImplementations(new Implementations());
        module.setName(this.getClass().getSimpleName());
        module.getAny().add(new ObjectFactory().createSourceFile(sourceFile1));
        module.getAny().add(new ObjectFactory().createSourceFile(sourceFile2));
        module.getAny().add(new ObjectFactory().createSourceFiles(sourceFiles1));
        module.getAny().add(new ObjectFactory().createSourceFiles(sourceFiles2));
        module.getAny().add(new ObjectFactory().createSourceFiles(new SourceFilesType()));
        module.getAny().add(new ObjectFactory().createSourceSection(sourceSection1));
        module.getAny().add(new ObjectFactory().createSourceSection(sourceSection2));
        module.getAny().add(new ObjectFactory().createSourceSections(sourceSections1));
        module.getAny().add(new ObjectFactory().createSourceSections(sourceSections2));
        module.getAny().add(new ObjectFactory().createSourceSections(new SourceSectionsType()));
        module.setMessages(new Messages());
        Specification specification = new Specification();
        specification.setIdentifier(this.getClass().getSimpleName());
        specification.getAny().add(new ObjectFactory().createSourceFile(sourceFile1));
        specification.getAny().add(new ObjectFactory().createSourceFile(sourceFile2));
        specification.getAny().add(new ObjectFactory().createSourceFiles(sourceFiles1));
        specification.getAny().add(new ObjectFactory().createSourceFiles(sourceFiles2));
        specification.getAny().add(new ObjectFactory().createSourceFiles(new SourceFilesType()));
        specification.getAny().add(new ObjectFactory().createSourceSection(sourceSection1));
        specification.getAny().add(new ObjectFactory().createSourceSection(sourceSection2));
        specification.getAny().add(new ObjectFactory().createSourceSections(sourceSections1));
        specification.getAny().add(new ObjectFactory().createSourceSections(sourceSections2));
        specification.getAny().add(new ObjectFactory().createSourceSections(new SourceSectionsType()));
        Implementation implementation = new Implementation();
        implementation.setIdentifier(this.getClass().getSimpleName());
        implementation.setName(this.getClass().getSimpleName());
        implementation.getAny().add(new ObjectFactory().createSourceFile(sourceFile1));
        implementation.getAny().add(new ObjectFactory().createSourceFile(sourceFile2));
        implementation.getAny().add(new ObjectFactory().createSourceFiles(sourceFiles1));
        implementation.getAny().add(new ObjectFactory().createSourceFiles(sourceFiles2));
        implementation.getAny().add(new ObjectFactory().createSourceFiles(new SourceFilesType()));
        implementation.getAny().add(new ObjectFactory().createSourceSection(sourceSection1));
        implementation.getAny().add(new ObjectFactory().createSourceSection(sourceSection2));
        implementation.getAny().add(new ObjectFactory().createSourceSections(sourceSections1));
        implementation.getAny().add(new ObjectFactory().createSourceSections(sourceSections2));
        implementation.getAny().add(new ObjectFactory().createSourceSections(new SourceSectionsType()));
        implementation.setDependencies(new Dependencies());
        implementation.setMessages(new Messages());
        Dependency dependency = new Dependency();
        dependency.setName(this.getClass().getSimpleName());
        dependency.setIdentifier(this.getClass().getSimpleName());
        dependency.getAny().add(new ObjectFactory().createSourceFile(sourceFile1));
        dependency.getAny().add(new ObjectFactory().createSourceFile(sourceFile2));
        dependency.getAny().add(new ObjectFactory().createSourceFiles(sourceFiles1));
        dependency.getAny().add(new ObjectFactory().createSourceFiles(sourceFiles2));
        dependency.getAny().add(new ObjectFactory().createSourceFiles(new SourceFilesType()));
        dependency.getAny().add(new ObjectFactory().createSourceSection(sourceSection1));
        dependency.getAny().add(new ObjectFactory().createSourceSection(sourceSection2));
        dependency.getAny().add(new ObjectFactory().createSourceSections(sourceSections1));
        dependency.getAny().add(new ObjectFactory().createSourceSections(sourceSections2));
        dependency.getAny().add(new ObjectFactory().createSourceSections(new SourceSectionsType()));
        Message message = new Message();
        message.setName(this.getClass().getSimpleName());
        message.setTemplate(new Texts());
        message.getTemplate().setDefaultLanguage("en");
        Text text = new Text();
        text.setLanguage("en");
        message.getTemplate().getText().add(text);
        message.getAny().add(new ObjectFactory().createSourceFile(sourceFile1));
        message.getAny().add(new ObjectFactory().createSourceFile(sourceFile2));
        message.getAny().add(new ObjectFactory().createSourceFiles(sourceFiles1));
        message.getAny().add(new ObjectFactory().createSourceFiles(sourceFiles2));
        message.getAny().add(new ObjectFactory().createSourceFiles(new SourceFilesType()));
        message.getAny().add(new ObjectFactory().createSourceSection(sourceSection1));
        message.getAny().add(new ObjectFactory().createSourceSection(sourceSection2));
        message.getAny().add(new ObjectFactory().createSourceSections(sourceSections1));
        message.getAny().add(new ObjectFactory().createSourceSections(sourceSections2));
        message.getAny().add(new ObjectFactory().createSourceSections(new SourceSectionsType()));
        implementation.getDependencies().getDependency().add(dependency);
        implementation.getMessages().getMessage().add(message);
        module.getImplementations().getImplementation().add(implementation);
        module.getMessages().getMessage().add(message);
        module.getSpecifications().getSpecification().add(specification);
        Specification deprecatedSpecification = new Specification();
        deprecatedSpecification.setIdentifier(this.getClass().getSimpleName() + " 2");
        deprecatedSpecification.getAny().add(new ObjectFactory().createSourceFile(sourceFile1));
        Implementation deprecatedImplementation = new Implementation();
        deprecatedImplementation.setIdentifier(this.getClass().getSimpleName() + " 2");
        deprecatedImplementation.setName(this.getClass().getSimpleName());
        deprecatedImplementation.getAny().add(new ObjectFactory().createSourceFile(sourceFile1));
        module.getSpecifications().getSpecification().add(deprecatedSpecification);
        module.getImplementations().getImplementation().add(deprecatedImplementation);
        JAXBSource jaxbSource = new JAXBSource(modelContext.createMarshaller("http://jomc.org/model"), (Object)new org.jomc.modlet.ObjectFactory().createModel(model));
        report = modelContext.validateModel("http://jomc.org/model", (Source)jaxbSource);
        ToolsModelValidatorTest.assertValidModel(report);
        report = this.getModelValidator().validateModel(modelContext, model);
        ToolsModelValidatorTest.assertInvalidModel(report);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "MODEL_SOURCE_FILE_CONSTRAINT", 6);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "MODEL_SOURCE_FILES_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "MODEL_SOURCE_SECTION_CONSTRAINT", 6);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "MODEL_SOURCE_SECTIONS_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "MODULE_SOURCE_FILE_CONSTRAINT", 6);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "MODULE_SOURCE_FILES_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "MODULE_SOURCE_SECTION_CONSTRAINT", 6);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "MODULE_SOURCE_SECTIONS_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_SOURCE_FILE_MULTIPLICITY_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_SOURCE_FILES_MULTIPLICITY_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_SOURCE_SECTION_CONSTRAINT", 6);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_SOURCE_SECTIONS_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_SOURCE_FILE_INFORMATION", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_DEPENDENCY_SOURCE_FILE_CONSTRAINT", 6);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_DEPENDENCY_SOURCE_FILES_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_DEPENDENCY_SOURCE_SECTION_CONSTRAINT", 6);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_DEPENDENCY_SOURCE_SECTIONS_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_MESSAGE_SOURCE_FILE_CONSTRAINT", 6);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_MESSAGE_SOURCE_FILES_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_MESSAGE_SOURCE_SECTION_CONSTRAINT", 6);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "IMPLEMENTATION_MESSAGE_SOURCE_SECTIONS_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "SPECIFICATION_SOURCE_FILE_MULTIPLICITY_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "SPECIFICATION_SOURCE_FILES_MULTIPLICITY_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "SPECIFICATION_SOURCE_SECTION_CONSTRAINT", 6);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "SPECIFICATION_SOURCE_SECTIONS_CONSTRAINT", 1);
        ToolsModelValidatorTest.assertModelValidationReportDetail(report, "SPECIFICATION_SOURCE_FILE_INFORMATION", 1);
    }

    private static void assertValidModel(ModelValidationReport report) {
        Assert.assertNotNull((Object)report);
        if (!report.isModelValid()) {
            System.out.println(">>>Unexpected invalid model:");
            ToolsModelValidatorTest.logModelValidationReport(report);
            Assert.fail((String)report.toString());
        } else {
            System.out.println(">>>Valid model:");
            ToolsModelValidatorTest.logModelValidationReport(report);
        }
    }

    private static void assertInvalidModel(ModelValidationReport report) {
        Assert.assertNotNull((Object)report);
        if (report.isModelValid()) {
            System.out.println(">>>Unexpected valid model:");
            ToolsModelValidatorTest.logModelValidationReport(report);
            Assert.fail((String)report.toString());
        } else {
            System.out.println(">>>Invalid model:");
            ToolsModelValidatorTest.logModelValidationReport(report);
        }
    }

    private static void assertModelValidationReportDetail(ModelValidationReport report, String identifier, Number count) {
        List details = report.getDetails(identifier);
        if (Integer.valueOf(details.size()) != count) {
            System.out.println(">>>Unexpected number of '" + identifier + "' details. Expected " + count + " - found " + details.size() + ".");
            ToolsModelValidatorTest.logModelValidationReport(report);
            Assert.fail((String)report.toString());
        }
    }

    private static void logModelValidationReport(ModelValidationReport report) {
        for (ModelValidationReport.Detail d : report.getDetails()) {
            System.out.println("\t" + d);
        }
    }
}

