/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools.modlet.test;

import org.jomc.model.Implementation;
import org.jomc.model.Implementations;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.Specification;
import org.jomc.model.Specifications;
import org.jomc.model.modlet.ModelHelper;
import org.jomc.modlet.Model;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelContextFactory;
import org.jomc.tools.model.SourceFilesType;
import org.jomc.tools.modlet.ToolsModelProvider;
import org.junit.Assert;
import org.junit.Test;

public class ToolsModelProviderTest {
    private ToolsModelProvider toolsModelProvider;

    public ToolsModelProvider getModelProvider() {
        if (this.toolsModelProvider == null) {
            this.toolsModelProvider = this.newModelProvider();
        }
        return this.toolsModelProvider;
    }

    protected ToolsModelProvider newModelProvider() {
        return new ToolsModelProvider();
    }

    @Test
    public final void testFindModel() throws Exception {
        ModelContext context = ModelContextFactory.newInstance().newModelContext();
        Model model = new Model();
        model.setIdentifier("http://jomc.org/model");
        Modules modules = new Modules();
        Module module = new Module();
        module.setName(this.getClass().getName());
        module.setSpecifications(new Specifications());
        module.setImplementations(new Implementations());
        Specification specification = new Specification();
        specification.setClassDeclaration(Boolean.valueOf(true));
        specification.setClazz(this.getClass().getName());
        specification.setIdentifier(this.getClass().getName() + " Specification");
        Implementation implementation = new Implementation();
        implementation.setClassDeclaration(Boolean.valueOf(true));
        implementation.setClazz(this.getClass().getName());
        implementation.setIdentifier(this.getClass().getName() + " Implementation");
        implementation.setName(this.getClass().getName() + " Implementation");
        module.getSpecifications().getSpecification().add(specification);
        module.getImplementations().getImplementation().add(implementation);
        modules.getModule().add(module);
        ModelHelper.setModules((Model)model, (Modules)modules);
        try {
            this.getModelProvider().findModel(null, model);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        try {
            this.getModelProvider().findModel(context, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        Model found = this.getModelProvider().findModel(context, model);
        Assert.assertNotNull((Object)found);
        modules = ModelHelper.getModules((Model)found);
        Assert.assertNotNull((Object)modules);
        specification = modules.getSpecification(this.getClass().getName() + " Specification");
        Assert.assertNotNull((Object)specification);
        implementation = modules.getImplementation(this.getClass().getName() + " Implementation");
        Assert.assertNotNull((Object)implementation);
        Assert.assertNotNull((Object)specification.getAnyObject(SourceFilesType.class));
        Assert.assertNotNull((Object)implementation.getAnyObject(SourceFilesType.class));
        this.getModelProvider().setEnabled(Boolean.valueOf(false));
        found = this.getModelProvider().findModel(context, model);
        Assert.assertNull((Object)found);
        this.getModelProvider().setEnabled(Boolean.valueOf(true));
    }

    @Test
    public final void testDefaultEnabled() throws Exception {
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultEnabled");
        ToolsModelProvider.setDefaultEnabled(null);
        Assert.assertTrue((boolean)ToolsModelProvider.isDefaultEnabled());
        System.setProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultEnabled", Boolean.toString(false));
        ToolsModelProvider.setDefaultEnabled(null);
        Assert.assertFalse((boolean)ToolsModelProvider.isDefaultEnabled());
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultEnabled");
        ToolsModelProvider.setDefaultEnabled(null);
        Assert.assertTrue((boolean)ToolsModelProvider.isDefaultEnabled());
        System.setProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultEnabled", Boolean.toString(true));
        ToolsModelProvider.setDefaultEnabled(null);
        Assert.assertTrue((boolean)ToolsModelProvider.isDefaultEnabled());
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultEnabled");
        ToolsModelProvider.setDefaultEnabled(null);
        Assert.assertTrue((boolean)ToolsModelProvider.isDefaultEnabled());
    }

    @Test
    public final void testEnabled() throws Exception {
        Model model = new Model();
        model.setIdentifier("http://jomc.org/model");
        ToolsModelProvider.setDefaultEnabled(null);
        this.getModelProvider().setEnabled(null);
        Assert.assertTrue((boolean)this.getModelProvider().isEnabled());
        this.getModelProvider().findModel(ModelContextFactory.newInstance().newModelContext(), model);
        ToolsModelProvider.setDefaultEnabled((Boolean)false);
        this.getModelProvider().setEnabled(null);
        Assert.assertFalse((boolean)this.getModelProvider().isEnabled());
        this.getModelProvider().findModel(ModelContextFactory.newInstance().newModelContext(), model);
        ToolsModelProvider.setDefaultEnabled(null);
        this.getModelProvider().setEnabled(null);
    }
}

