/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools.test;

import java.io.File;
import java.io.IOException;
import org.jomc.model.Implementation;
import org.jomc.model.Module;
import org.jomc.model.Specification;
import org.jomc.tools.ResourceFileProcessor;
import org.jomc.tools.test.JomcToolTest;
import org.junit.Assert;
import org.junit.Test;

public class ResourceFileProcessorTest
extends JomcToolTest {
    public ResourceFileProcessor getJomcTool() {
        return (ResourceFileProcessor)super.getJomcTool();
    }

    protected ResourceFileProcessor newJomcTool() {
        return new ResourceFileProcessor();
    }

    @Test
    public final void testResourceFileProcessorNullPointerException() throws Exception {
        try {
            this.getJomcTool().getResourceBundleResources((Specification)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ResourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getResourceBundleResources((Implementation)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ResourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().writeResourceBundleResourceFiles(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ResourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().writeResourceBundleResourceFiles((Module)null, new File("/"));
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ResourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().writeResourceBundleResourceFiles(new Module(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ResourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().writeResourceBundleResourceFiles((Specification)null, new File("/"));
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ResourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().writeResourceBundleResourceFiles(new Specification(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ResourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().writeResourceBundleResourceFiles((Implementation)null, new File("/"));
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ResourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().writeResourceBundleResourceFiles(new Implementation(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            ResourceFileProcessorTest.assertNullPointerException(e);
        }
    }

    @Test
    public final void testResourceFileProcessorNotNull() throws Exception {
        Assert.assertNotNull((Object)this.getJomcTool().getResourceBundleDefaultLocale());
        Assert.assertNotNull((Object)this.getJomcTool().getResourceBundleResources(this.getJomcTool().getModules().getSpecification("Specification")));
        Assert.assertNotNull((Object)this.getJomcTool().getResourceBundleResources(this.getJomcTool().getModules().getImplementation("Implementation")));
    }

    @Test
    public final void testResourceBundleDefaultLocale() throws Exception {
        this.getJomcTool().setResourceBundleDefaultLocale(null);
        Assert.assertNotNull((Object)this.getJomcTool().getResourceBundleDefaultLocale());
        this.getJomcTool().setResourceBundleDefaultLocale(null);
    }

    @Test
    public final void testWriteResourceBundleResourceFiles() throws Exception {
        File nonExistentDirectory = this.getNextOutputDirectory();
        try {
            this.getJomcTool().writeResourceBundleResourceFiles(nonExistentDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().writeResourceBundleResourceFiles(this.getJomcTool().getModules().getModule("Module"), nonExistentDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().writeResourceBundleResourceFiles(this.getJomcTool().getModules().getSpecification("Specification"), nonExistentDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().writeResourceBundleResourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), nonExistentDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        File resourcesDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)resourcesDirectory.mkdirs());
        this.getJomcTool().writeResourceBundleResourceFiles(resourcesDirectory);
        resourcesDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)resourcesDirectory.mkdirs());
        this.getJomcTool().writeResourceBundleResourceFiles(this.getJomcTool().getModules().getModule("Module"), resourcesDirectory);
        resourcesDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)resourcesDirectory.mkdirs());
        this.getJomcTool().writeResourceBundleResourceFiles(this.getJomcTool().getModules().getSpecification("Specification"), resourcesDirectory);
        resourcesDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)resourcesDirectory.mkdirs());
        this.getJomcTool().writeResourceBundleResourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), resourcesDirectory);
    }

    @Test
    public final void testCopyConstructor() throws Exception {
        try {
            new ResourceFileProcessor(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        new ResourceFileProcessor(this.getJomcTool());
    }
}

