/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.jomc.model.Implementation;
import org.jomc.model.Module;
import org.jomc.model.Specification;
import org.jomc.modlet.Model;
import org.jomc.tools.SourceFileProcessor;
import org.jomc.tools.test.JomcToolTest;
import org.jomc.util.SectionEditor;
import org.junit.Assert;
import org.junit.Test;

public class SourceFileProcessorTest
extends JomcToolTest {
    private static final String ABSOLUTE_RESOURCE_NAME_PREFIX = "/" + SourceFileProcessorTest.class.getPackage().getName().replace('.', '/') + "/";

    public SourceFileProcessor getJomcTool() {
        return (SourceFileProcessor)super.getJomcTool();
    }

    protected SourceFileProcessor newJomcTool() {
        return new SourceFileProcessor();
    }

    @Test
    public final void testSourceFileProcessorNullPointerException() throws Exception {
        try {
            this.getJomcTool().getSourceFileType((Specification)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getSourceFileType((Implementation)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getSourceFilesType((Specification)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getSourceFilesType((Implementation)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getSourceFileEditor((Specification)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().getSourceFileEditor((Implementation)null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().manageSourceFiles(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().manageSourceFiles((Implementation)null, new File("/"));
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().manageSourceFiles(new Implementation(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().manageSourceFiles((Module)null, new File("/"));
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().manageSourceFiles(new Module(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().manageSourceFiles((Specification)null, new File("/"));
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
        try {
            this.getJomcTool().manageSourceFiles(new Specification(), null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            SourceFileProcessorTest.assertNullPointerException(e);
        }
    }

    @Test
    public final void testSourceFileProcessorNotNull() throws Exception {
        Assert.assertNotNull((Object)this.getJomcTool().getSourceFilesType(this.getJomcTool().getModules().getImplementation("Implementation")));
        Assert.assertNotNull((Object)this.getJomcTool().getSourceFilesType(this.getJomcTool().getModules().getSpecification("Specification")));
        Assert.assertNotNull((Object)this.getJomcTool().getSourceFileEditor());
    }

    @Test
    public final void testManageSources() throws Exception {
        this.getJomcTool().setInputEncoding(this.getResourceEncoding());
        this.getJomcTool().setOutputEncoding(this.getResourceEncoding());
        File nonExistingDirectory = this.getNextOutputDirectory();
        try {
            this.getJomcTool().manageSourceFiles(nonExistingDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getModule("Module"), nonExistingDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), nonExistingDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        try {
            this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getSpecification("Specification"), nonExistingDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e);
        }
        File sourcesDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)sourcesDirectory.mkdirs());
        this.getJomcTool().manageSourceFiles(sourcesDirectory);
        this.getJomcTool().manageSourceFiles(sourcesDirectory);
        sourcesDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)sourcesDirectory.mkdirs());
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getModule("Module"), sourcesDirectory);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getModule("Module"), sourcesDirectory);
        File implementationDirectory = this.getNextOutputDirectory();
        File implementationSourceFile = new File(implementationDirectory, "Implementation.java");
        Assert.assertTrue((boolean)implementationDirectory.mkdirs());
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        long implementationSourceFileLength = implementationSourceFile.length();
        Assert.assertTrue((boolean)implementationSourceFile.exists());
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        Assert.assertTrue((boolean)implementationSourceFile.exists());
        Assert.assertEquals((long)implementationSourceFileLength, (long)implementationSourceFile.length());
        this.getJomcTool().getTemplateParameters().put("with-assertions", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-author-copyright", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-editor-fold", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-javadoc", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-javadoc-author", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-javadoc-version", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-jsr-250", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-project-name", null);
        this.getJomcTool().getTemplateParameters().put("with-revision-keyword", null);
        this.getJomcTool().getTemplateParameters().put("with-suppress-warnings", null);
        this.getJomcTool().getTemplateParameters().put("with-vendor-copyright", null);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        Assert.assertTrue((boolean)implementationSourceFile.exists());
        Assert.assertTrue((implementationSourceFile.length() < implementationSourceFileLength ? 1 : 0) != 0);
        this.getJomcTool().getTemplateParameters().clear();
        this.getJomcTool().setTemplateProfile("jomc-java-bundles");
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        this.getJomcTool().getTemplateParameters().put("with-assertions", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-author-copyright", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-editor-fold", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-javadoc", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-javadoc-author", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-javadoc-version", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-jsr-250", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-project-name", null);
        this.getJomcTool().getTemplateParameters().put("with-revision-keyword", null);
        this.getJomcTool().getTemplateParameters().put("with-suppress-warnings", null);
        this.getJomcTool().getTemplateParameters().put("with-vendor-copyright", null);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        this.getJomcTool().getTemplateParameters().clear();
        this.getJomcTool().setTemplateProfile(null);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("ImplementationWithSourceFilesModel"), implementationDirectory);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("ImplementationWithSourceFilesModel"), implementationDirectory);
        File specificationDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)specificationDirectory.mkdirs());
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getSpecification("Specification"), specificationDirectory);
        this.getJomcTool().getTemplateParameters().put("with-assertions", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-author-copyright", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-editor-fold", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-javadoc", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-javadoc-author", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-javadoc-version", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-jsr-250", Boolean.FALSE);
        this.getJomcTool().getTemplateParameters().put("with-project-name", null);
        this.getJomcTool().getTemplateParameters().put("with-revision-keyword", null);
        this.getJomcTool().getTemplateParameters().put("with-suppress-warnings", null);
        this.getJomcTool().getTemplateParameters().put("with-vendor-copyright", null);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getSpecification("Specification"), specificationDirectory);
        this.getJomcTool().getTemplateParameters().clear();
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getSpecification("SpecificationWithSourceFilesModel"), specificationDirectory);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getSpecification("SpecificationWithSourceFilesModel"), specificationDirectory);
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "IllegalImplementationSource.java.txt", new File(implementationDirectory, "Implementation.java"));
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "IllegalSpecificationSource.java.txt", new File(specificationDirectory, "Specification.java"));
        try {
            this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        try {
            this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getSpecification("Specification"), specificationDirectory);
            Assert.fail((String)"Expected IOException not thrown.");
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "EmptyImplementationSource.java.txt", new File(implementationDirectory, "Implementation.java"));
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "EmptySpecificationSource.java.txt", new File(specificationDirectory, "Specification.java"));
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getSpecification("Specification"), specificationDirectory);
        this.getJomcTool().setTemplateProfile("DOES_NOT_EXIST");
        sourcesDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)sourcesDirectory.mkdirs());
        this.getJomcTool().manageSourceFiles(sourcesDirectory);
        sourcesDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)sourcesDirectory.mkdirs());
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getModule("Module"), sourcesDirectory);
        sourcesDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)sourcesDirectory.mkdirs());
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), sourcesDirectory);
        sourcesDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)sourcesDirectory.mkdirs());
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getSpecification("Specification"), sourcesDirectory);
        this.getJomcTool().setInputEncoding(null);
        this.getJomcTool().setOutputEncoding(null);
    }

    @Test
    public final void testMandatorySections() throws Exception {
        SectionEditor editor = new SectionEditor();
        File specificationDirectory = this.getNextOutputDirectory();
        File implementationDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)specificationDirectory.mkdirs());
        Assert.assertTrue((boolean)implementationDirectory.mkdirs());
        this.getJomcTool().setInputEncoding(this.getResourceEncoding());
        this.getJomcTool().setOutputEncoding(this.getResourceEncoding());
        File f = new File(implementationDirectory, "Implementation.java");
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "ImplementationWithoutAnnotationsSection.java.txt", f);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        String edited = this.toString(f);
        editor.edit(edited);
        Assert.assertTrue((boolean)editor.isSectionPresent("Annotations"));
        f = new File(implementationDirectory, "Implementation.java");
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "ImplementationWithoutDependenciesSection.java.txt", f);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        edited = this.toString(f);
        editor.edit(edited);
        Assert.assertTrue((boolean)editor.isSectionPresent("Dependencies"));
        f = new File(implementationDirectory, "Implementation.java");
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "ImplementationWithoutMessagesSection.java.txt", f);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        edited = this.toString(f);
        editor.edit(edited);
        Assert.assertTrue((boolean)editor.isSectionPresent("Messages"));
        f = new File(implementationDirectory, "Implementation.java");
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "ImplementationWithoutPropertiesSection.java.txt", f);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        edited = this.toString(f);
        editor.edit(edited);
        Assert.assertTrue((boolean)editor.isSectionPresent("Properties"));
        f = new File(implementationDirectory, "ImplementationOfSpecification.java");
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "ImplementationOfSpecificationWithoutConstructorsSection.java.txt", f);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("ImplementationOfSpecification"), implementationDirectory);
        edited = this.toString(f);
        editor.edit(edited);
        Assert.assertTrue((boolean)editor.isSectionPresent("Constructors"));
        f = new File(specificationDirectory, "Specification.java");
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "SpecificationWithoutAnnotationsSection.java.txt", f);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getSpecification("Specification"), specificationDirectory);
        edited = this.toString(f);
        editor.edit(edited);
        Assert.assertTrue((boolean)editor.isSectionPresent("Annotations"));
        this.getJomcTool().setInputEncoding(null);
        this.getJomcTool().setOutputEncoding(null);
    }

    @Test
    public final void testOptionalSections() throws Exception {
        SectionEditor editor = new SectionEditor();
        File implementationDirectory = this.getNextOutputDirectory();
        File specificationDirectory = this.getNextOutputDirectory();
        Assert.assertTrue((boolean)specificationDirectory.mkdirs());
        Assert.assertTrue((boolean)implementationDirectory.mkdirs());
        this.getJomcTool().setInputEncoding(this.getResourceEncoding());
        this.getJomcTool().setOutputEncoding(this.getResourceEncoding());
        File f = new File(implementationDirectory, "Implementation.java");
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "ImplementationWithoutConstructorsSection.java.txt", f);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        String edited = this.toString(f);
        editor.edit(edited);
        Assert.assertFalse((boolean)editor.isSectionPresent("Constructors"));
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "ImplementationWithoutDefaultConstructorSection.java.txt", f);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        edited = this.toString(f);
        editor.edit(edited);
        Assert.assertTrue((boolean)editor.isSectionPresent("Constructors"));
        Assert.assertTrue((boolean)editor.isSectionPresent("Default Constructor"));
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "ImplementationWithoutDocumentationSection.java.txt", f);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        edited = this.toString(f);
        editor.edit(edited);
        Assert.assertFalse((boolean)editor.isSectionPresent("Documentation"));
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "ImplementationWithoutLicenseSection.java.txt", f);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getImplementation("Implementation"), implementationDirectory);
        edited = this.toString(f);
        editor.edit(edited);
        Assert.assertFalse((boolean)editor.isSectionPresent("License Header"));
        f = new File(specificationDirectory, "Specification.java");
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "SpecificationWithoutDocumentationSection.java.txt", f);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getSpecification("Specification"), specificationDirectory);
        edited = this.toString(f);
        editor.edit(edited);
        Assert.assertFalse((boolean)editor.isSectionPresent("Documentation"));
        this.copyResource(ABSOLUTE_RESOURCE_NAME_PREFIX + "SpecificationWithoutLicenseSection.java.txt", f);
        this.getJomcTool().manageSourceFiles(this.getJomcTool().getModules().getSpecification("Specification"), specificationDirectory);
        edited = this.toString(f);
        editor.edit(edited);
        Assert.assertFalse((boolean)editor.isSectionPresent("License Header"));
        this.getJomcTool().setInputEncoding(null);
        this.getJomcTool().setOutputEncoding(null);
    }

    @Test
    public final void testSourceFileEditor() throws Exception {
        Assert.assertNotNull((Object)this.getJomcTool().getSourceFileEditor());
        this.getJomcTool().setSourceFileEditor(null);
        Assert.assertNotNull((Object)this.getJomcTool().getSourceFileEditor());
    }

    @Test
    public final void testCopyConstructor() throws Exception {
        try {
            new SourceFileProcessor(null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        new SourceFileProcessor(this.getJomcTool());
    }

    @Test
    public final void testSourceFileProcessorModelObjectsNotFound() throws Exception {
        File tmpDir = new File(System.getProperty("java.io.tmpdir", "/tmp"));
        Module m = new Module();
        m.setName("DOES_NOT_EXIST");
        Specification s = new Specification();
        s.setIdentifier("DOES_NOT_EXIST)");
        Implementation i = new Implementation();
        i.setIdentifier("DOES_NOT_EXIST");
        Model oldModel = this.getJomcTool().getModel();
        this.getJomcTool().setModel(null);
        Assert.assertNull((Object)this.getJomcTool().getSourceFilesType(s));
        Assert.assertNull((Object)this.getJomcTool().getSourceFilesType(i));
        this.getJomcTool().manageSourceFiles(tmpDir);
        this.getJomcTool().manageSourceFiles(m, tmpDir);
        this.getJomcTool().manageSourceFiles(s, tmpDir);
        this.getJomcTool().manageSourceFiles(i, tmpDir);
        this.getJomcTool().setModel(oldModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void copyResource(String resourceName, File file) throws IOException {
        Assert.assertTrue((boolean)resourceName.startsWith("/"));
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.getClass().getResourceAsStream(resourceName);
            Assert.assertNotNull((String)("Resource '" + resourceName + "' not found."), (Object)in);
            out = new FileOutputStream(file);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.close();
            out = null;
            in.close();
            in = null;
        }
        finally {
            block28: {
                block27: {
                    if (out == null) break block27;
                    out.close();
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                    break block28;
                }
                catch (IOException iOException) {}
                break block28;
                catch (IOException iOException) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException2) {}
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException iOException3) {}
                        throw throwable;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toString(File f) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            String str = IOUtils.toString((InputStream)in, (String)this.getResourceEncoding());
            ((InputStream)in).close();
            in = null;
            String string = str;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

