/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.jomc.model.Dependencies;
import org.jomc.model.Implementation;
import org.jomc.model.Messages;
import org.jomc.model.Module;
import org.jomc.model.Properties;
import org.jomc.model.Specification;
import org.jomc.model.Specifications;
import org.jomc.tools.JomcTool;
import org.jomc.tools.model.SourceFileType;
import org.jomc.tools.model.SourceFilesType;
import org.jomc.tools.model.SourceSectionType;
import org.jomc.tools.model.SourceSectionsType;
import org.jomc.util.LineEditor;
import org.jomc.util.Section;
import org.jomc.util.SectionEditor;
import org.jomc.util.TrailingWhitespaceEditor;

public class SourceFileProcessor
extends JomcTool {
    private static final String CONSTRUCTORS_SECTION_NAME = "Constructors";
    private static final String DEFAULT_CONSTRUCTOR_SECTION_NAME = "Default Constructor";
    private static final String DEPENDENCIES_SECTION_NAME = "Dependencies";
    private static final String PROPERTIES_SECTION_NAME = "Properties";
    private static final String MESSAGES_SECTION_NAME = "Messages";
    private static final String LICENSE_SECTION_NAME = "License Header";
    private static final String DOCUMENTATION_SECTION_NAME = "Documentation";
    private static final String ANNOTATIONS_SECTION_NAME = "Annotations";
    private static final String CONSTRUCTORS_HEAD_TEMPLATE = "implementation-constructors-head.vm";
    private static final String CONSTRUCTORS_TAIL_TEMPLATE = "implementation-constructors-tail.vm";
    private static final String DEFAULT_CONSTRUCTOR_TEMPLATE = "implementation-default-constructor.vm";
    private static final String DEPENDENCIES_TEMPLATE = "implementation-dependencies.vm";
    private static final String PROPERTIES_TEMPLATE = "implementation-properties.vm";
    private static final String MESSAGES_TEMPLATE = "implementation-messages.vm";
    private static final String SPECIFICATION_LICENSE_TEMPLATE = "specification-license.vm";
    private static final String IMPLEMENTATION_LICENSE_TEMPLATE = "implementation-license.vm";
    private static final String SPECIFICATION_DOCUMENTATION_TEMPLATE = "specification-documentation.vm";
    private static final String IMPLEMENTATION_DOCUMENTATION_TEMPLATE = "implementation-documentation.vm";
    private static final String IMPLEMENTATION_TEMPLATE = "Implementation.java.vm";
    private static final String SPECIFICATION_TEMPLATE = "Specification.java.vm";
    private static final String SPECIFICATION_ANNOTATIONS_TEMPLATE = "specification-annotations.vm";
    private static final String IMPLEMENTATION_ANNOTATIONS_TEMPLATE = "implementation-annotations.vm";
    private SourceFilesType sourceFilesType;

    public SourceFileProcessor() {
    }

    public SourceFileProcessor(SourceFileProcessor tool) throws IOException {
        super(tool);
        this.sourceFilesType = tool.sourceFilesType != null ? new SourceFilesType(tool.sourceFilesType) : null;
    }

    public SourceFilesType getSourceFilesType() {
        if (this.sourceFilesType == null) {
            this.sourceFilesType = new SourceFilesType();
        }
        return this.sourceFilesType;
    }

    public SourceFileType getSourceFileType(Specification specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        assert (this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        SourceFileType sourceFileType = this.getSourceFilesType().getSourceFile(specification.getIdentifier());
        if (sourceFileType == null) {
            sourceFileType = (SourceFileType)specification.getAnyObject(SourceFileType.class);
        }
        if (sourceFileType == null) {
            sourceFileType = new SourceFileType();
            sourceFileType.setIdentifier(specification.getIdentifier());
            sourceFileType.setLocation(specification.getClazz().replace('.', '/') + ".java");
            sourceFileType.setTemplate(SPECIFICATION_TEMPLATE);
            sourceFileType.setSourceSections(new SourceSectionsType());
            SourceSectionType s = new SourceSectionType();
            s.setName(LICENSE_SECTION_NAME);
            s.setHeadTemplate(SPECIFICATION_LICENSE_TEMPLATE);
            s.setOptional(true);
            sourceFileType.getSourceSections().getSourceSection().add(s);
            s = new SourceSectionType();
            s.setName(ANNOTATIONS_SECTION_NAME);
            s.setHeadTemplate(SPECIFICATION_ANNOTATIONS_TEMPLATE);
            s.setOptional(false);
            sourceFileType.getSourceSections().getSourceSection().add(s);
            s = new SourceSectionType();
            s.setName(DOCUMENTATION_SECTION_NAME);
            s.setHeadTemplate(SPECIFICATION_DOCUMENTATION_TEMPLATE);
            s.setOptional(true);
            sourceFileType.getSourceSections().getSourceSection().add(s);
            String javaTypeName = this.getJavaTypeName(specification, false);
            if (javaTypeName != null) {
                s = new SourceSectionType();
                s.setName(javaTypeName);
                s.setIndentationLevel(1);
                s.setOptional(false);
                s.setEditable(true);
                sourceFileType.getSourceSections().getSourceSection().add(s);
            }
        }
        return sourceFileType;
    }

    public SourceFileType getSourceFileType(Implementation implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        assert (this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        SourceFileType sourceFileType = this.getSourceFilesType().getSourceFile(implementation.getIdentifier());
        if (sourceFileType == null) {
            sourceFileType = (SourceFileType)implementation.getAnyObject(SourceFileType.class);
        }
        if (sourceFileType == null) {
            Specifications specifications = this.getModules().getSpecifications(implementation.getIdentifier());
            Dependencies dependencies = this.getModules().getDependencies(implementation.getIdentifier());
            Messages messages = this.getModules().getMessages(implementation.getIdentifier());
            Properties properties = this.getModules().getProperties(implementation.getIdentifier());
            sourceFileType = new SourceFileType();
            sourceFileType.setIdentifier(implementation.getIdentifier());
            sourceFileType.setLocation(implementation.getClazz().replace('.', '/') + ".java");
            sourceFileType.setTemplate(IMPLEMENTATION_TEMPLATE);
            sourceFileType.setSourceSections(new SourceSectionsType());
            SourceSectionType s = new SourceSectionType();
            s.setName(LICENSE_SECTION_NAME);
            s.setHeadTemplate(IMPLEMENTATION_LICENSE_TEMPLATE);
            s.setOptional(true);
            sourceFileType.getSourceSections().getSourceSection().add(s);
            s = new SourceSectionType();
            s.setName(ANNOTATIONS_SECTION_NAME);
            s.setHeadTemplate(IMPLEMENTATION_ANNOTATIONS_TEMPLATE);
            s.setOptional(false);
            sourceFileType.getSourceSections().getSourceSection().add(s);
            s = new SourceSectionType();
            s.setName(DOCUMENTATION_SECTION_NAME);
            s.setHeadTemplate(IMPLEMENTATION_DOCUMENTATION_TEMPLATE);
            s.setOptional(true);
            sourceFileType.getSourceSections().getSourceSection().add(s);
            for (String interfaceName : this.getJavaInterfaceNames(implementation, false)) {
                s = new SourceSectionType();
                s.setName(interfaceName);
                s.setIndentationLevel(1);
                s.setOptional(false);
                s.setEditable(true);
                sourceFileType.getSourceSections().getSourceSection().add(s);
            }
            s = new SourceSectionType();
            s.setName(this.getJavaTypeName(implementation, false));
            s.setIndentationLevel(1);
            s.setOptional(false);
            s.setEditable(true);
            sourceFileType.getSourceSections().getSourceSection().add(s);
            s = new SourceSectionType();
            s.setName(CONSTRUCTORS_SECTION_NAME);
            s.setIndentationLevel(1);
            s.setHeadTemplate(CONSTRUCTORS_HEAD_TEMPLATE);
            s.setTailTemplate(CONSTRUCTORS_TAIL_TEMPLATE);
            s.setOptional(specifications == null || specifications.getSpecification().isEmpty() && specifications.getReference().isEmpty());
            s.setSourceSections(new SourceSectionsType());
            sourceFileType.getSourceSections().getSourceSection().add(s);
            SourceSectionType defaultCtor = new SourceSectionType();
            defaultCtor.setName(DEFAULT_CONSTRUCTOR_SECTION_NAME);
            defaultCtor.setIndentationLevel(2);
            defaultCtor.setHeadTemplate(DEFAULT_CONSTRUCTOR_TEMPLATE);
            defaultCtor.setOptional(false);
            defaultCtor.setEditable(true);
            s.getSourceSections().getSourceSection().add(defaultCtor);
            s = new SourceSectionType();
            s.setName(DEPENDENCIES_SECTION_NAME);
            s.setIndentationLevel(1);
            s.setHeadTemplate(DEPENDENCIES_TEMPLATE);
            s.setOptional(dependencies == null || dependencies.getDependency().isEmpty());
            sourceFileType.getSourceSections().getSourceSection().add(s);
            s = new SourceSectionType();
            s.setName(PROPERTIES_SECTION_NAME);
            s.setIndentationLevel(1);
            s.setHeadTemplate(PROPERTIES_TEMPLATE);
            s.setOptional(properties == null || properties.getProperty().isEmpty());
            sourceFileType.getSourceSections().getSourceSection().add(s);
            s = new SourceSectionType();
            s.setName(MESSAGES_SECTION_NAME);
            s.setIndentationLevel(1);
            s.setHeadTemplate(MESSAGES_TEMPLATE);
            s.setOptional(messages == null || messages.getMessage().isEmpty());
            sourceFileType.getSourceSections().getSourceSection().add(s);
        }
        return sourceFileType;
    }

    public void manageSourceFiles(File sourcesDirectory) throws IOException {
        if (sourcesDirectory == null) {
            throw new NullPointerException("sourcesDirectory");
        }
        for (Module m : this.getModules().getModule()) {
            this.manageSourceFiles(m, sourcesDirectory);
        }
    }

    public void manageSourceFiles(Module module, File sourcesDirectory) throws IOException {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (sourcesDirectory == null) {
            throw new NullPointerException("sourcesDirectory");
        }
        assert (this.getModules().getModule(module.getName()) != null) : "Module '" + module.getName() + "' not found.";
        if (module.getSpecifications() != null) {
            for (Specification s : module.getSpecifications().getSpecification()) {
                this.manageSourceFiles(s, sourcesDirectory);
            }
        }
        if (module.getImplementations() != null) {
            for (Implementation i : module.getImplementations().getImplementation()) {
                this.manageSourceFiles(i, sourcesDirectory);
            }
        }
    }

    public void manageSourceFiles(Specification specification, File sourcesDirectory) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (sourcesDirectory == null) {
            throw new NullPointerException("sourcesDirectory");
        }
        assert (this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        Implementation i = this.getModules().getImplementation(specification.getIdentifier());
        if (i != null && i.isClassDeclaration()) {
            this.manageSourceFiles(i, sourcesDirectory);
        } else if (specification.isClassDeclaration()) {
            this.editSourceFile(sourcesDirectory, this.getSourceFileEditor(specification));
        }
    }

    public void manageSourceFiles(Implementation implementation, File sourcesDirectory) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (sourcesDirectory == null) {
            throw new NullPointerException("sourcesDirectory");
        }
        assert (this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        if (implementation.isClassDeclaration()) {
            this.editSourceFile(sourcesDirectory, this.getSourceFileEditor(implementation));
        }
    }

    public SourceFileEditor getSourceFileEditor(Specification specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        assert (this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        return new SourceFileEditor(specification, (LineEditor)new TrailingWhitespaceEditor(this.getLineSeparator()), this.getLineSeparator());
    }

    public SourceFileEditor getSourceFileEditor(Implementation implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        assert (this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        return new SourceFileEditor(implementation, (LineEditor)new TrailingWhitespaceEditor(this.getLineSeparator()), this.getLineSeparator());
    }

    private void editSourceFile(File sourcesDirectory, SourceFileEditor editor) throws IOException {
        if (sourcesDirectory == null) {
            throw new NullPointerException("sourcesDirectory");
        }
        if (editor == null) {
            throw new NullPointerException("editor");
        }
        SourceFileType sourceFileType = editor.getSourceFileType();
        if (sourceFileType != null) {
            String content = "";
            String edited = null;
            File f = new File(sourcesDirectory, sourceFileType.getLocation());
            if (!f.exists()) {
                if (sourceFileType.getTemplate() != null) {
                    if (this.isLoggable(Level.FINE)) {
                        this.log(Level.FINE, SourceFileProcessor.getMessage("creating", this.getClass().getName(), f.getAbsolutePath()), null);
                    }
                    StringWriter writer = new StringWriter();
                    Template template = this.getVelocityTemplate(sourceFileType.getTemplate());
                    VelocityContext ctx = editor.getVelocityContext();
                    ctx.put("template", (Object)template);
                    template.merge((Context)ctx, (Writer)writer);
                    writer.close();
                    content = writer.toString();
                }
            } else {
                if (this.isLoggable(Level.FINE)) {
                    this.log(Level.FINE, SourceFileProcessor.getMessage("reading", this.getClass().getName(), f.getAbsolutePath()), null);
                }
                content = FileUtils.readFileToString((File)f, (String)this.getInputEncoding());
            }
            try {
                edited = editor.edit(content);
            }
            catch (IOException e) {
                throw (IOException)new IOException(SourceFileProcessor.getMessage("failedEditing", f.getAbsolutePath(), e.getMessage())).initCause(e);
            }
            if (this.isLoggable(Level.FINE)) {
                for (Section s : editor.getAddedSections()) {
                    this.log(Level.FINE, SourceFileProcessor.getMessage("addedSection", this.getClass().getName(), f.getAbsolutePath(), s.getName()), null);
                }
            }
            if (this.isLoggable(Level.WARNING)) {
                for (Section s : editor.getUnknownSections()) {
                    this.log(Level.WARNING, SourceFileProcessor.getMessage("unknownSection", f.getAbsolutePath(), s.getName()), null);
                }
            }
            if (!edited.equals(content) || edited.length() == 0) {
                if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
                    throw new IOException(SourceFileProcessor.getMessage("failedCreatingDirectory", f.getParentFile().getAbsolutePath()));
                }
                if (this.isLoggable(Level.INFO)) {
                    this.log(Level.INFO, SourceFileProcessor.getMessage("editing", f.getAbsolutePath()), null);
                }
                FileUtils.writeStringToFile((File)f, (String)edited, (String)this.getOutputEncoding());
            } else if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, SourceFileProcessor.getMessage("unchanged", this.getClass().getName(), f.getAbsolutePath()), null);
            }
        }
    }

    private static String getMessage(String key, Object ... arguments) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return MessageFormat.format(ResourceBundle.getBundle(SourceFileProcessor.class.getName().replace('.', '/')).getString(key), arguments);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SourceFileEditor
    extends SectionEditor {
        private final Specification specification;
        private final Implementation implementation;
        private List<Section> addedSections;
        private List<Section> unknownSections;

        public SourceFileEditor(Specification specification) {
            this(specification, null, null);
        }

        public SourceFileEditor(Specification specification, String lineSeparator) {
            this(specification, null, lineSeparator);
        }

        public SourceFileEditor(Specification specification, LineEditor lineEditor) {
            this(specification, lineEditor, null);
        }

        public SourceFileEditor(Specification specification, LineEditor lineEditor, String lineSeparator) {
            super(lineEditor, lineSeparator);
            this.specification = specification;
            this.implementation = null;
            assert (SourceFileProcessor.this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        }

        public SourceFileEditor(Implementation implementation) {
            this(implementation, null, null);
        }

        public SourceFileEditor(Implementation implementation, String lineSeparator) {
            this(implementation, null, lineSeparator);
        }

        public SourceFileEditor(Implementation implementation, LineEditor lineEditor) {
            this(implementation, lineEditor, null);
        }

        public SourceFileEditor(Implementation implementation, LineEditor lineEditor, String lineSeparator) {
            super(lineEditor, lineSeparator);
            this.implementation = implementation;
            this.specification = null;
            assert (SourceFileProcessor.this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        }

        public List<Section> getAddedSections() {
            if (this.addedSections == null) {
                this.addedSections = new LinkedList<Section>();
            }
            return this.addedSections;
        }

        public List<Section> getUnknownSections() {
            if (this.unknownSections == null) {
                this.unknownSections = new LinkedList<Section>();
            }
            return this.unknownSections;
        }

        protected SourceFileType getSourceFileType() {
            if (this.specification != null) {
                return SourceFileProcessor.this.getSourceFileType(this.specification);
            }
            if (this.implementation != null) {
                return SourceFileProcessor.this.getSourceFileType(this.implementation);
            }
            return null;
        }

        protected VelocityContext getVelocityContext() {
            VelocityContext ctx = SourceFileProcessor.this.getVelocityContext();
            if (this.specification != null) {
                ctx.put("specification", (Object)this.specification);
            }
            if (this.implementation != null) {
                ctx.put("implementation", (Object)this.implementation);
            }
            return ctx;
        }

        protected String getOutput(Section section) throws IOException {
            this.getAddedSections().clear();
            this.getUnknownSections().clear();
            SourceFileType sourceFileType = this.getSourceFileType();
            if (sourceFileType != null) {
                this.createSections(sourceFileType.getSourceSections(), section);
            }
            return super.getOutput(section);
        }

        protected void editSection(Section s) throws IOException {
            super.editSection(s);
            SourceFileType sourceFileType = this.getSourceFileType();
            if (s.getName() != null && sourceFileType != null && sourceFileType.getSourceSections() != null) {
                SourceSectionType sourceSectionType = sourceFileType.getSourceSections().getSourceSection(s.getName());
                if (sourceSectionType != null) {
                    VelocityContext ctx;
                    Template template;
                    StringWriter writer;
                    if (s.getStartingLine() != null) {
                        s.setStartingLine(SourceFileProcessor.this.getIndentation(sourceSectionType.getIndentationLevel()) + s.getStartingLine().trim());
                    }
                    if (s.getEndingLine() != null) {
                        s.setEndingLine(SourceFileProcessor.this.getIndentation(sourceSectionType.getIndentationLevel()) + s.getEndingLine().trim());
                    }
                    if (!(sourceSectionType.getHeadTemplate() == null || sourceSectionType.isEditable() && s.getHeadContent().toString().trim().length() != 0)) {
                        writer = new StringWriter();
                        template = SourceFileProcessor.this.getVelocityTemplate(sourceSectionType.getHeadTemplate());
                        ctx = this.getVelocityContext();
                        ctx.put("template", (Object)template);
                        template.merge((Context)ctx, (Writer)writer);
                        writer.close();
                        s.getHeadContent().setLength(0);
                        s.getHeadContent().append(writer.toString());
                    }
                    if (!(sourceSectionType.getTailTemplate() == null || sourceSectionType.isEditable() && s.getTailContent().toString().trim().length() != 0)) {
                        writer = new StringWriter();
                        template = SourceFileProcessor.this.getVelocityTemplate(sourceSectionType.getTailTemplate());
                        ctx = this.getVelocityContext();
                        ctx.put("template", (Object)template);
                        template.merge((Context)ctx, (Writer)writer);
                        writer.close();
                        s.getTailContent().setLength(0);
                        s.getTailContent().append(writer.toString());
                    }
                } else {
                    this.getUnknownSections().add(s);
                }
            }
        }

        private void createSections(SourceSectionsType sourceSectionsType, Section section) {
            if (sourceSectionsType != null && section != null) {
                for (SourceSectionType sourceSectionType : sourceSectionsType.getSourceSection()) {
                    Section childSection = section.getSection(sourceSectionType.getName());
                    if (childSection == null && !sourceSectionType.isOptional()) {
                        childSection = new Section();
                        childSection.setName(sourceSectionType.getName());
                        childSection.setStartingLine(SourceFileProcessor.this.getIndentation(sourceSectionType.getIndentationLevel()) + "// SECTION-START[" + sourceSectionType.getName() + "]");
                        childSection.setEndingLine(SourceFileProcessor.this.getIndentation(sourceSectionType.getIndentationLevel()) + "// SECTION-END");
                        section.getSections().add(childSection);
                        this.getAddedSections().add(childSection);
                    }
                    this.createSections(sourceSectionType.getSourceSections(), childSection);
                }
            }
        }
    }
}

