/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.velocity.VelocityContext;
import org.jomc.model.Implementation;
import org.jomc.model.Message;
import org.jomc.model.Messages;
import org.jomc.model.Module;
import org.jomc.model.Specification;
import org.jomc.model.Text;
import org.jomc.tools.JomcTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFileProcessor
extends JomcTool {
    private Locale resourceBundleDefaultLocale;

    public ResourceFileProcessor() {
    }

    public ResourceFileProcessor(ResourceFileProcessor tool) throws IOException {
        super(tool);
        this.resourceBundleDefaultLocale = tool.resourceBundleDefaultLocale;
    }

    public final Locale getResourceBundleDefaultLocale() {
        if (this.resourceBundleDefaultLocale == null) {
            this.resourceBundleDefaultLocale = Locale.getDefault();
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, ResourceFileProcessor.getMessage("resourceBundleDefaultLocale", this.getClass().getName(), this.resourceBundleDefaultLocale), null);
            }
        }
        return this.resourceBundleDefaultLocale;
    }

    public final void setResourceBundleDefaultLocale(Locale value) {
        this.resourceBundleDefaultLocale = value;
    }

    public void writeResourceBundleResourceFiles(File resourcesDirectory) throws IOException {
        if (resourcesDirectory == null) {
            throw new NullPointerException("resourcesDirectory");
        }
        for (Module m : this.getModules().getModule()) {
            this.writeResourceBundleResourceFiles(m, resourcesDirectory);
        }
    }

    public void writeResourceBundleResourceFiles(Module module, File resourcesDirectory) throws IOException {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (resourcesDirectory == null) {
            throw new NullPointerException("resourcesDirectory");
        }
        assert (this.getModules().getModule(module.getName()) != null) : "Module '" + module.getName() + "' not found.";
        if (module.getSpecifications() != null) {
            for (Specification s : module.getSpecifications().getSpecification()) {
                this.writeResourceBundleResourceFiles(s, resourcesDirectory);
            }
        }
        if (module.getImplementations() != null) {
            for (Implementation i : module.getImplementations().getImplementation()) {
                this.writeResourceBundleResourceFiles(i, resourcesDirectory);
            }
        }
    }

    public void writeResourceBundleResourceFiles(Specification specification, File resourcesDirectory) throws IOException {
        if (specification == null) {
            throw new NullPointerException("implementation");
        }
        if (resourcesDirectory == null) {
            throw new NullPointerException("resourcesDirectory");
        }
        assert (this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        if (specification.isClassDeclaration()) {
            this.assertValidTemplates(specification);
            String bundlePath = this.getJavaTypeName(specification, true).replace('.', File.separatorChar);
            this.writeResourceBundleResourceFiles(this.getResourceBundleResources(specification), resourcesDirectory, bundlePath);
        }
    }

    public void writeResourceBundleResourceFiles(Implementation implementation, File resourcesDirectory) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (resourcesDirectory == null) {
            throw new NullPointerException("resourcesDirectory");
        }
        assert (this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        if (implementation.isClassDeclaration()) {
            this.assertValidTemplates(implementation);
            String bundlePath = this.getJavaTypeName(implementation, true).replace('.', File.separatorChar);
            this.writeResourceBundleResourceFiles(this.getResourceBundleResources(implementation), resourcesDirectory, bundlePath);
        }
    }

    public Map<Locale, Properties> getResourceBundleResources(Specification specification) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        assert (this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        return new HashMap<Locale, Properties>();
    }

    public Map<Locale, Properties> getResourceBundleResources(Implementation implementation) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        assert (this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        HashMap<Locale, Properties> properties = new HashMap<Locale, Properties>(10);
        Messages messages = this.getModules().getMessages(implementation.getIdentifier());
        if (messages != null) {
            for (Message message : messages.getMessage()) {
                if (message.getTemplate() == null) continue;
                for (Text text : message.getTemplate().getText()) {
                    Locale locale = new Locale(text.getLanguage().toLowerCase());
                    Properties bundleProperties = (Properties)properties.get(locale);
                    if (bundleProperties == null) {
                        bundleProperties = new Properties();
                        properties.put(locale, bundleProperties);
                    }
                    bundleProperties.setProperty(message.getName(), text.getValue());
                }
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResourceBundleResourceFiles(Map<Locale, Properties> resources, File resourcesDirectory, String bundlePath) throws IOException {
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        if (resourcesDirectory == null) {
            throw new NullPointerException("resourcesDirectory");
        }
        if (bundlePath == null) {
            throw new NullPointerException("bundlePath");
        }
        Properties defProperties = null;
        Properties fallbackProperties = null;
        VelocityContext ctx = this.getVelocityContext();
        String toolName = ctx.get("toolName").toString();
        String toolVersion = ctx.get("toolVersion").toString();
        String toolUrl = ctx.get("toolUrl").toString();
        for (Map.Entry<Locale, Properties> e : resources.entrySet()) {
            String language = e.getKey().getLanguage().toLowerCase();
            Properties p = e.getValue();
            File file = new File(resourcesDirectory, bundlePath + "_" + language + ".properties");
            if (this.getResourceBundleDefaultLocale().getLanguage().equalsIgnoreCase(language)) {
                defProperties = p;
            }
            fallbackProperties = p;
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException(ResourceFileProcessor.getMessage("failedCreatingDirectory", file.getParentFile().getAbsolutePath()));
            }
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ResourceFileProcessor.getMessage("writing", file.getCanonicalPath()), null);
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                p.store(out, toolName + ' ' + toolVersion + " - See " + toolUrl);
            }
            finally {
                if (out == null) continue;
                ((OutputStream)out).close();
            }
        }
        if (defProperties == null) {
            defProperties = fallbackProperties;
        }
        if (defProperties != null) {
            File file = new File(resourcesDirectory, bundlePath + ".properties");
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException(ResourceFileProcessor.getMessage("failedCreatingDirectory", file.getParentFile().getAbsolutePath()));
            }
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ResourceFileProcessor.getMessage("writing", file.getCanonicalPath()), null);
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                defProperties.store(out, toolName + ' ' + toolVersion + " - See " + toolUrl);
            }
            finally {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
        }
    }

    private void assertValidTemplates(Specification specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
    }

    private void assertValidTemplates(Implementation implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        Messages messages = this.getModules().getMessages(implementation.getIdentifier());
        if (messages != null) {
            for (Message m : messages.getMessage()) {
                if (m.getTemplate() == null) continue;
                for (Text t : m.getTemplate().getText()) {
                    new MessageFormat(t.getValue());
                }
            }
        }
    }

    private static String getMessage(String key, Object ... arguments) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return MessageFormat.format(ResourceBundle.getBundle(ResourceFileProcessor.class.getName().replace('.', '/')).getString(key), arguments);
    }
}

