/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.jomc.model.Argument;
import org.jomc.model.ArgumentType;
import org.jomc.model.Dependency;
import org.jomc.model.Implementation;
import org.jomc.model.Message;
import org.jomc.model.Modules;
import org.jomc.model.Multiplicity;
import org.jomc.model.Property;
import org.jomc.model.Specification;
import org.jomc.model.SpecificationReference;
import org.jomc.model.Specifications;
import org.jomc.model.Text;
import org.jomc.model.modlet.ModelHelper;
import org.jomc.modlet.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JomcTool {
    private static final byte[] NO_BYTES = new byte[0];
    private static final String TEMPLATE_PREFIX = JomcTool.class.getPackage().getName().replace('.', '/') + "/templates/";
    private static final String VELOCITY_RESOURCE_LOADER = ClasspathResourceLoader.class.getName();
    private static final String DEFAULT_TEMPLATE_PROFILE = "jomc-java";
    private static volatile String defaultTemplateProfile;
    private static final Level DEFAULT_LOG_LEVEL;
    private static volatile Level defaultLogLevel;
    private Model model;
    private VelocityEngine velocityEngine;
    private String templateEncoding;
    private String inputEncoding;
    private String outputEncoding;
    private String templateProfile;
    private String indentation;
    private String lineSeparator;
    private List<Listener> listeners;
    private Level logLevel;
    private final Map<Integer, String> indentationCache = new HashMap<Integer, String>();

    public JomcTool() {
    }

    public JomcTool(JomcTool tool) throws IOException {
        this();
        if (tool == null) {
            throw new NullPointerException("tool");
        }
        this.indentation = tool.indentation;
        this.inputEncoding = tool.inputEncoding;
        this.lineSeparator = tool.lineSeparator;
        this.listeners = tool.listeners != null ? new LinkedList<Listener>(tool.listeners) : null;
        this.logLevel = tool.logLevel;
        this.model = tool.model != null ? new Model(tool.model) : null;
        this.outputEncoding = tool.outputEncoding;
        this.templateEncoding = tool.templateEncoding;
        this.templateProfile = tool.templateProfile;
        this.velocityEngine = tool.velocityEngine;
    }

    public List<Listener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new LinkedList<Listener>();
        }
        return this.listeners;
    }

    public static Level getDefaultLogLevel() {
        if (defaultLogLevel == null) {
            defaultLogLevel = Level.parse(System.getProperty("org.jomc.tools.JomcTool.defaultLogLevel", DEFAULT_LOG_LEVEL.getName()));
        }
        return defaultLogLevel;
    }

    public static void setDefaultLogLevel(Level value) {
        defaultLogLevel = value;
    }

    public final Level getLogLevel() {
        if (this.logLevel == null) {
            this.logLevel = JomcTool.getDefaultLogLevel();
            this.log(Level.CONFIG, JomcTool.getMessage("defaultLogLevelInfo", this.getClass().getName(), this.logLevel.getLocalizedName()), null);
        }
        return this.logLevel;
    }

    public final void setLogLevel(Level value) {
        this.logLevel = value;
    }

    public boolean isLoggable(Level level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        return level.intValue() >= this.getLogLevel().intValue();
    }

    public String getJavaPackageName(Specification specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        return specification.getClazz() != null ? this.getJavaPackageName(specification.getClazz()) : null;
    }

    public String getJavaTypeName(Specification specification, boolean qualified) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (specification.getClazz() != null) {
            StringBuilder typeName = new StringBuilder();
            String javaPackageName = this.getJavaPackageName(specification);
            if (qualified && javaPackageName.length() > 0) {
                typeName.append(javaPackageName).append('.');
            }
            typeName.append(javaPackageName.length() > 0 ? specification.getClazz().substring(javaPackageName.length() + 1) : specification.getClazz());
            return typeName.toString();
        }
        return null;
    }

    public String getJavaClasspathLocation(Specification specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        return specification.getClazz() != null ? this.getJavaTypeName(specification, true).replace('.', '/') : null;
    }

    public String getJavaPackageName(SpecificationReference reference) {
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        Specification s = this.getModules().getSpecification(reference.getIdentifier());
        assert (s != null) : "Specification '" + reference.getIdentifier() + "' not found.";
        return s.getClazz() != null ? this.getJavaPackageName(s) : null;
    }

    public String getJavaTypeName(SpecificationReference reference, boolean qualified) {
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        Specification s = this.getModules().getSpecification(reference.getIdentifier());
        assert (s != null) : "Specification '" + reference.getIdentifier() + "' not found.";
        return s.getClazz() != null ? this.getJavaTypeName(s, qualified) : null;
    }

    public String getJavaPackageName(Implementation implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        return implementation.getClazz() != null ? this.getJavaPackageName(implementation.getClazz()) : null;
    }

    public String getJavaTypeName(Implementation implementation, boolean qualified) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (implementation.getClazz() != null) {
            StringBuilder typeName = new StringBuilder();
            String javaPackageName = this.getJavaPackageName(implementation);
            if (qualified && javaPackageName.length() > 0) {
                typeName.append(javaPackageName).append('.');
            }
            typeName.append(javaPackageName.length() > 0 ? implementation.getClazz().substring(javaPackageName.length() + 1) : implementation.getClazz());
            return typeName.toString();
        }
        return null;
    }

    public String getJavaClasspathLocation(Implementation implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        return implementation.getClazz() != null ? this.getJavaTypeName(implementation, true).replace('.', '/') : null;
    }

    public List<String> getJavaInterfaceNames(Implementation implementation, boolean qualified) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        Specifications specs = this.getModules().getSpecifications(implementation.getIdentifier());
        ArrayList<String> col = new ArrayList<String>(specs == null ? 0 : specs.getSpecification().size());
        if (specs != null) {
            for (Specification s : specs.getSpecification()) {
                String typeName;
                if (s.getClazz() == null || col.contains(typeName = this.getJavaTypeName(s, qualified))) continue;
                col.add(typeName);
            }
        }
        return Collections.unmodifiableList(col);
    }

    public String getJavaTypeName(Argument argument) {
        if (argument == null) {
            throw new NullPointerException("argument");
        }
        String javaTypeName = "java.lang.String";
        if (argument.getType() == ArgumentType.DATE || argument.getType() == ArgumentType.TIME) {
            javaTypeName = "java.util.Date";
        } else if (argument.getType() == ArgumentType.NUMBER) {
            javaTypeName = "java.lang.Number";
        }
        return javaTypeName;
    }

    public String getJavaTypeName(Property property, boolean boxify) {
        if (property == null) {
            throw new NullPointerException("property");
        }
        if (property.getType() != null) {
            String typeName = property.getType();
            if (boxify) {
                if (Boolean.TYPE.getName().equals(typeName)) {
                    return Boolean.class.getName();
                }
                if (Byte.TYPE.getName().equals(typeName)) {
                    return Byte.class.getName();
                }
                if (Character.TYPE.getName().equals(typeName)) {
                    return Character.class.getName();
                }
                if (Double.TYPE.getName().equals(typeName)) {
                    return Double.class.getName();
                }
                if (Float.TYPE.getName().equals(typeName)) {
                    return Float.class.getName();
                }
                if (Integer.TYPE.getName().equals(typeName)) {
                    return Integer.class.getName();
                }
                if (Long.TYPE.getName().equals(typeName)) {
                    return Long.class.getName();
                }
                if (Short.TYPE.getName().equals(typeName)) {
                    return Short.class.getName();
                }
            }
            return typeName;
        }
        return property.getAny() != null ? Object.class.getName() : String.class.getName();
    }

    public boolean isJavaPrimitiveType(Property property) {
        if (property == null) {
            throw new NullPointerException("property");
        }
        return !this.getJavaTypeName(property, false).equals(this.getJavaTypeName(property, true));
    }

    public String getJavaGetterMethodName(Property property) {
        if (property == null) {
            throw new NullPointerException("property");
        }
        String prefix = "get";
        String javaTypeName = this.getJavaTypeName(property, true);
        if (Boolean.class.getName().equals(javaTypeName)) {
            prefix = "is";
        }
        return prefix + this.getJavaIdentifier(property.getName());
    }

    public String getJavaTypeName(Dependency dependency) {
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        Specification s = this.getModules().getSpecification(dependency.getIdentifier());
        if (s != null && s.getClazz() != null) {
            StringBuilder typeName = new StringBuilder();
            typeName.append(this.getJavaTypeName(s, true));
            if (s.getMultiplicity() == Multiplicity.MANY && dependency.getImplementationName() == null) {
                typeName.append("[]");
            }
            return typeName.toString();
        }
        return null;
    }

    public String getJavaGetterMethodName(Dependency dependency) {
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        return "get" + this.getJavaIdentifier(dependency.getName());
    }

    public String getJavaGetterMethodName(Message message) {
        if (message == null) {
            throw new NullPointerException("message");
        }
        return "get" + this.getJavaIdentifier(message.getName());
    }

    public String getJavaModifierName(Implementation implementation, Dependency dependency) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        return "private";
    }

    public String getJavaModifierName(Implementation implementation, Message message) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        return "private";
    }

    public String getJavaModifierName(Implementation implementation, Property property) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (property == null) {
            throw new NullPointerException("property");
        }
        String modifier = "private";
        org.jomc.model.Properties specified = this.getModules().getSpecifiedProperties(implementation.getIdentifier());
        if (specified != null && specified.getProperty(property.getName()) != null) {
            modifier = "public";
        }
        return modifier;
    }

    public String getJavadocComment(Text text, int indentationLevel, String suffix) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix");
        }
        if (indentationLevel < 0) {
            throw new IllegalArgumentException(Integer.toString(indentationLevel));
        }
        try {
            String javadoc = text.getValue();
            if (javadoc != null) {
                String line;
                String indent = this.getIndentation(indentationLevel);
                BufferedReader reader = new BufferedReader(new StringReader(javadoc));
                StringBuilder builder = new StringBuilder(javadoc.length());
                while ((line = reader.readLine()) != null) {
                    builder.append(this.getLineSeparator()).append(indent).append(suffix).append(line.replaceAll("\\/\\*\\*", "/*").replaceAll("\\*/", "/"));
                }
                javadoc = builder.length() == 0 ? "" : StringEscapeUtils.escapeHtml((String)builder.substring(this.getLineSeparator().length() + indent.length() + suffix.length()));
            }
            return javadoc;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getJavaString(String str) {
        return StringEscapeUtils.escapeJava((String)str);
    }

    public boolean isJavaDefaultPackage(Specification specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        return specification.getClazz() != null && this.getJavaPackageName(specification).length() == 0;
    }

    public boolean isJavaDefaultPackage(Implementation implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        return implementation.getClazz() != null && this.getJavaPackageName(implementation).length() == 0;
    }

    public String getDisplayLanguage(String language) {
        if (language == null) {
            throw new NullPointerException("language");
        }
        Locale locale = new Locale(language);
        return locale.getDisplayLanguage(locale);
    }

    public String getShortDate(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getDateInstance(3).format(calendar.getTime());
    }

    public String getLongDate(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getDateInstance(1).format(calendar.getTime());
    }

    public String getShortTime(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getTimeInstance(3).format(calendar.getTime());
    }

    public String getLongTime(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getTimeInstance(1).format(calendar.getTime());
    }

    public String getShortDateTime(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getDateTimeInstance(3, 3).format(calendar.getTime());
    }

    public String getLongDateTime(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getDateTimeInstance(1, 1).format(calendar.getTime());
    }

    public String getYears(Calendar start, Calendar end) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        if (end == null) {
            throw new NullPointerException("end");
        }
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
        int s = start.get(1);
        int e = end.get(1);
        StringBuilder years = new StringBuilder();
        if (s != e) {
            if (s < e) {
                years.append(yearFormat.format((Object)start.getTime())).append(" - ").append(yearFormat.format((Object)end.getTime()));
            } else {
                years.append(yearFormat.format((Object)end.getTime())).append(" - ").append(yearFormat.format((Object)start.getTime()));
            }
        } else {
            years.append(yearFormat.format((Object)start.getTime()));
        }
        return years.toString();
    }

    public Model getModel() {
        if (this.model == null) {
            this.model = new Model();
            this.model.setIdentifier("http://jomc.org/model");
        }
        return this.model;
    }

    public void setModel(Model value) {
        this.model = value;
    }

    public Modules getModules() {
        Modules modules = ModelHelper.getModules((Model)this.getModel());
        return modules != null ? modules : new Modules();
    }

    public VelocityEngine getVelocityEngine() throws IOException {
        if (this.velocityEngine == null) {
            try {
                final String logPrefix = this.getClass().getName();
                Properties props = new Properties();
                props.put("resource.loader", "class");
                props.put("class.resource.loader.class", VELOCITY_RESOURCE_LOADER);
                props.put("class.resource.loader.cache", Boolean.TRUE.toString());
                props.put("runtime.references.strict", Boolean.TRUE.toString());
                props.put("velocimacro.arguments.strict", Boolean.TRUE.toString());
                VelocityEngine engine = new VelocityEngine();
                engine.setProperty("runtime.log.logsystem", (Object)new LogChute(){

                    public void init(RuntimeServices runtimeServices) throws Exception {
                    }

                    public void log(int level, String message) {
                        this.log(level, message, null);
                    }

                    public void log(int level, String message, Throwable throwable) {
                        StringBuilder b = new StringBuilder();
                        b.append(logPrefix).append(": ").append(message);
                        JomcTool.this.log(Level.FINE, b.toString(), throwable);
                    }

                    public boolean isLevelEnabled(int level) {
                        return JomcTool.this.isLoggable(Level.FINE);
                    }
                });
                engine.init(props);
                this.velocityEngine = engine;
            }
            catch (Exception e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine value) {
        this.velocityEngine = value;
    }

    public VelocityContext getVelocityContext() {
        Date now = new Date();
        VelocityContext ctx = new VelocityContext();
        ctx.put("model", (Object)this.getModel());
        ctx.put("modules", (Object)this.getModules());
        ctx.put("tool", (Object)this);
        ctx.put("toolName", (Object)this.getClass().getName());
        ctx.put("toolVersion", (Object)JomcTool.getMessage("projectVersion", new Object[0]));
        ctx.put("toolUrl", (Object)JomcTool.getMessage("projectUrl", new Object[0]));
        ctx.put("calendar", (Object)Calendar.getInstance());
        ctx.put("now", (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(now));
        ctx.put("year", (Object)new SimpleDateFormat("yyyy").format(now));
        ctx.put("month", (Object)new SimpleDateFormat("MM").format(now));
        ctx.put("day", (Object)new SimpleDateFormat("dd").format(now));
        ctx.put("hour", (Object)new SimpleDateFormat("HH").format(now));
        ctx.put("minute", (Object)new SimpleDateFormat("mm").format(now));
        ctx.put("second", (Object)new SimpleDateFormat("ss").format(now));
        ctx.put("timezone", (Object)new SimpleDateFormat("Z").format(now));
        return ctx;
    }

    public final String getTemplateEncoding() {
        if (this.templateEncoding == null) {
            this.templateEncoding = JomcTool.getMessage("buildSourceEncoding", new Object[0]);
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultTemplateEncoding", this.getClass().getName(), this.templateEncoding), null);
            }
        }
        return this.templateEncoding;
    }

    public final void setTemplateEncoding(String value) {
        this.templateEncoding = value;
        this.velocityEngine = null;
    }

    public final String getInputEncoding() {
        if (this.inputEncoding == null) {
            this.inputEncoding = new InputStreamReader(new ByteArrayInputStream(NO_BYTES)).getEncoding();
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultInputEncoding", this.getClass().getName(), this.inputEncoding), null);
            }
        }
        return this.inputEncoding;
    }

    public final void setInputEncoding(String value) {
        this.inputEncoding = value;
    }

    public final String getOutputEncoding() {
        if (this.outputEncoding == null) {
            this.outputEncoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultOutputEncoding", this.getClass().getName(), this.outputEncoding), null);
            }
        }
        return this.outputEncoding;
    }

    public final void setOutputEncoding(String value) {
        this.outputEncoding = value;
    }

    public static String getDefaultTemplateProfile() {
        if (defaultTemplateProfile == null) {
            defaultTemplateProfile = System.getProperty("org.jomc.tools.JomcTool.defaultTemplateProfile", DEFAULT_TEMPLATE_PROFILE);
        }
        return defaultTemplateProfile;
    }

    public static void setDefaultTemplateProfile(String value) {
        defaultTemplateProfile = value;
    }

    public final String getTemplateProfile() {
        if (this.templateProfile == null) {
            this.templateProfile = JomcTool.getDefaultTemplateProfile();
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultTemplateProfile", this.getClass().getName(), this.templateProfile), null);
            }
        }
        return this.templateProfile;
    }

    public final void setTemplateProfile(String value) {
        this.templateProfile = value;
    }

    public final String getIndentation() {
        if (this.indentation == null) {
            this.indentation = "    ";
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultIndentation", this.getClass().getName(), StringEscapeUtils.escapeJava((String)this.indentation)), null);
            }
        }
        return this.indentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getIndentation(int level) {
        if (level < 0) {
            throw new IllegalArgumentException(Integer.toString(level));
        }
        Map<Integer, String> map = this.indentationCache;
        synchronized (map) {
            String idt = this.indentationCache.get(level);
            if (idt == null) {
                StringBuilder b = new StringBuilder(this.getIndentation().length() * level);
                for (int i = level; i > 0; --i) {
                    b.append(this.getIndentation());
                }
                idt = b.toString();
                this.indentationCache.put(level, idt);
            }
            return idt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIndentation(String value) {
        Map<Integer, String> map = this.indentationCache;
        synchronized (map) {
            this.indentation = value;
            this.indentationCache.clear();
        }
    }

    public final String getLineSeparator() {
        if (this.lineSeparator == null) {
            this.lineSeparator = System.getProperty("line.separator", "\n");
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultLineSeparator", this.getClass().getName(), StringEscapeUtils.escapeJava((String)this.lineSeparator)), null);
            }
        }
        return this.lineSeparator;
    }

    public final void setLineSeparator(String value) {
        this.lineSeparator = value;
    }

    public Template getVelocityTemplate(String templateName) throws IOException {
        if (templateName == null) {
            throw new NullPointerException("templateName");
        }
        try {
            Template template = this.getVelocityEngine().getTemplate(TEMPLATE_PREFIX + this.getTemplateProfile() + "/" + templateName, this.getTemplateEncoding());
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, JomcTool.getMessage("templateInfo", this.getClass().getName(), templateName, this.getTemplateProfile()), null);
            }
            return template;
        }
        catch (ResourceNotFoundException e) {
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, JomcTool.getMessage("templateNotFound", this.getClass().getName(), templateName, this.getTemplateProfile()), null);
            }
            try {
                Template template = this.getVelocityEngine().getTemplate(TEMPLATE_PREFIX + JomcTool.getDefaultTemplateProfile() + "/" + templateName, this.getTemplateEncoding());
                if (this.isLoggable(Level.FINE)) {
                    this.log(Level.FINE, JomcTool.getMessage("templateInfo", this.getClass().getName(), templateName, JomcTool.getDefaultTemplateProfile()), null);
                }
                return template;
            }
            catch (Exception e2) {
                throw (IOException)new IOException(JomcTool.getMessage("failedGettingTemplate", templateName)).initCause(e2);
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException(JomcTool.getMessage("failedGettingTemplate", templateName)).initCause(e);
        }
    }

    protected void log(Level level, String message, Throwable throwable) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        if (this.isLoggable(level)) {
            for (Listener l : this.getListeners()) {
                l.onLog(level, message, throwable);
            }
        }
    }

    private String getJavaPackageName(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier");
        }
        int idx = identifier.lastIndexOf(46);
        return idx != -1 ? identifier.substring(0, idx) : "";
    }

    private String getJavaIdentifier(String identifier) {
        StringBuilder builder = new StringBuilder();
        boolean capitalize = true;
        for (int i = 0; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (Character.isWhitespace(c)) {
                capitalize = true;
                continue;
            }
            if (!(i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c))) continue;
            builder.append(capitalize ? Character.toUpperCase(c) : c);
            capitalize = false;
        }
        return builder.toString();
    }

    private static String getMessage(String key, Object ... arguments) {
        return MessageFormat.format(ResourceBundle.getBundle(JomcTool.class.getName().replace('.', '/')).getString(key), arguments);
    }

    static {
        DEFAULT_LOG_LEVEL = Level.WARNING;
    }

    public static abstract class Listener {
        public abstract void onLog(Level var1, String var2, Throwable var3);
    }
}

