/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBResult;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.validation.Schema;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Unknown;
import org.jomc.model.Dependencies;
import org.jomc.model.Dependency;
import org.jomc.model.Implementation;
import org.jomc.model.Implementations;
import org.jomc.model.Message;
import org.jomc.model.Messages;
import org.jomc.model.ModelObject;
import org.jomc.model.Module;
import org.jomc.model.ObjectFactory;
import org.jomc.model.Properties;
import org.jomc.model.Property;
import org.jomc.model.Specification;
import org.jomc.model.SpecificationReference;
import org.jomc.model.Specifications;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelException;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.tools.JomcTool;
import org.jomc.util.ParseException;
import org.jomc.util.TokenMgrError;
import org.jomc.util.VersionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFileProcessor
extends JomcTool {
    private static final byte[] NO_BYTES = new byte[0];

    public ClassFileProcessor() {
    }

    public ClassFileProcessor(ClassFileProcessor tool) throws IOException {
        super(tool);
    }

    public final void commitModelObjects(ModelContext context, File classesDirectory) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        try {
            Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
            m.setSchema(context.createSchema(this.getModel().getIdentifier()));
            this.commitModelObjects(this.getModules().getSpecifications(), this.getModules().getImplementations(), m, classesDirectory);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final void commitModelObjects(Module module, ModelContext context, File classesDirectory) throws IOException {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        assert (this.getModules().getModule(module.getName()) != null) : "Module '" + module.getName() + "' not found.";
        try {
            Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
            m.setSchema(context.createSchema(this.getModel().getIdentifier()));
            this.commitModelObjects(module.getSpecifications(), module.getImplementations(), m, classesDirectory);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final void commitModelObjects(Specification specification, ModelContext context, File classesDirectory) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        assert (this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        try {
            Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
            m.setSchema(context.createSchema(this.getModel().getIdentifier()));
            this.commitModelObjects(specification, m, classesDirectory);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final void commitModelObjects(Implementation implementation, ModelContext context, File classesDirectory) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        assert (this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        try {
            Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
            m.setSchema(context.createSchema(this.getModel().getIdentifier()));
            this.commitModelObjects(implementation, m, classesDirectory);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public void commitModelObjects(Specification specification, Marshaller marshaller, JavaClass javaClass) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        assert (this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        this.setClassfileAttribute(javaClass, Specification.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)new ObjectFactory().createSpecification(specification)));
    }

    public void commitModelObjects(Implementation implementation, Marshaller marshaller, JavaClass javaClass) throws IOException {
        Specifications specifications;
        Messages messages;
        Properties properties;
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        assert (this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        ObjectFactory of = new ObjectFactory();
        Dependencies dependencies = this.getModules().getDependencies(implementation.getIdentifier());
        if (dependencies == null) {
            dependencies = new Dependencies();
        }
        if ((properties = this.getModules().getProperties(implementation.getIdentifier())) == null) {
            properties = new Properties();
        }
        if ((messages = this.getModules().getMessages(implementation.getIdentifier())) == null) {
            messages = new Messages();
        }
        if ((specifications = this.getModules().getSpecifications(implementation.getIdentifier())) == null) {
            specifications = new Specifications();
        }
        for (SpecificationReference r : specifications.getReference()) {
            if (specifications.getSpecification(r.getIdentifier()) != null || !this.isLoggable(Level.WARNING)) continue;
            this.log(Level.WARNING, ClassFileProcessor.getMessage("unresolvedSpecification", r.getIdentifier(), implementation.getIdentifier()), null);
        }
        for (Dependency d : dependencies.getDependency()) {
            Specification s = this.getModules().getSpecification(d.getIdentifier());
            if (s != null) {
                if (specifications.getSpecification(s.getIdentifier()) != null) continue;
                specifications.getSpecification().add(s);
                continue;
            }
            if (!this.isLoggable(Level.WARNING)) continue;
            this.log(Level.WARNING, ClassFileProcessor.getMessage("unresolvedDependencySpecification", d.getIdentifier(), d.getName(), implementation.getIdentifier()), null);
        }
        this.setClassfileAttribute(javaClass, Dependencies.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createDependencies(dependencies)));
        this.setClassfileAttribute(javaClass, Properties.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createProperties(properties)));
        this.setClassfileAttribute(javaClass, Messages.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createMessages(messages)));
        this.setClassfileAttribute(javaClass, Specifications.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createSpecifications(specifications)));
    }

    public final ModelValidationReport validateModelObjects(ModelContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        try {
            Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
            u.setSchema(context.createSchema(this.getModel().getIdentifier()));
            return this.validateModelObjects(this.getModules().getSpecifications(), this.getModules().getImplementations(), u, context.getClassLoader());
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(Module module, ModelContext context) throws IOException {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        assert (this.getModules().getModule(module.getName()) != null) : "Module '" + module.getName() + "' not found.";
        try {
            Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
            u.setSchema(context.createSchema(this.getModel().getIdentifier()));
            return this.validateModelObjects(module.getSpecifications(), module.getImplementations(), u, context.getClassLoader());
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(Specification specification, ModelContext context) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        assert (this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        try {
            Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
            u.setSchema(context.createSchema(this.getModel().getIdentifier()));
            return this.validateModelObjects(specification, u, context.getClassLoader());
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(Implementation implementation, ModelContext context) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        assert (this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        try {
            Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
            u.setSchema(context.createSchema(this.getModel().getIdentifier()));
            return this.validateModelObjects(implementation, u, context.getClassLoader());
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(ModelContext context, File classesDirectory) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        try {
            Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
            u.setSchema(context.createSchema(this.getModel().getIdentifier()));
            return this.validateModelObjects(this.getModules().getSpecifications(), this.getModules().getImplementations(), u, classesDirectory);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(Module module, ModelContext context, File classesDirectory) throws IOException {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        assert (this.getModules().getModule(module.getName()) != null) : "Module '" + module.getName() + "' not found.";
        try {
            Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
            u.setSchema(context.createSchema(this.getModel().getIdentifier()));
            return this.validateModelObjects(module.getSpecifications(), module.getImplementations(), u, classesDirectory);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(Specification specification, ModelContext context, File classesDirectory) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        assert (this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        try {
            Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
            u.setSchema(context.createSchema(this.getModel().getIdentifier()));
            return this.validateModelObjects(specification, u, classesDirectory);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(Implementation implementation, ModelContext context, File classesDirectory) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        assert (this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        try {
            Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
            u.setSchema(context.createSchema(this.getModel().getIdentifier()));
            return this.validateModelObjects(implementation, u, classesDirectory);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public ModelValidationReport validateModelObjects(Specification specification, Unmarshaller unmarshaller, JavaClass javaClass) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        assert (this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        ModelValidationReport report = new ModelValidationReport();
        Specification decoded = null;
        byte[] bytes = this.getClassfileAttribute(javaClass, Specification.class.getName());
        if (bytes != null) {
            decoded = this.decodeModelObject(unmarshaller, bytes, Specification.class);
        }
        if (decoded != null) {
            if (decoded.getMultiplicity() != specification.getMultiplicity()) {
                report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_SPECIFICATION_MULTIPLICITY", Level.SEVERE, ClassFileProcessor.getMessage("illegalMultiplicity", specification.getIdentifier(), specification.getMultiplicity().value(), decoded.getMultiplicity().value()), new ObjectFactory().createSpecification(specification)));
            }
            if (decoded.getScope() == null ? specification.getScope() != null : !decoded.getScope().equals(specification.getScope())) {
                report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_SPECIFICATION_SCOPE", Level.SEVERE, ClassFileProcessor.getMessage("illegalScope", specification.getIdentifier(), specification.getScope() == null ? "Multiton" : specification.getScope(), decoded.getScope() == null ? "Multiton" : decoded.getScope()), new ObjectFactory().createSpecification(specification)));
            }
            if (decoded.getClazz() == null ? specification.getClazz() != null : !decoded.getClazz().equals(specification.getClazz())) {
                report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_SPECIFICATION_CLASS", Level.SEVERE, ClassFileProcessor.getMessage("illegalSpecificationClass", decoded.getIdentifier(), specification.getClazz(), decoded.getClazz()), new ObjectFactory().createSpecification(specification)));
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, ClassFileProcessor.getMessage("cannotValidateSpecification", specification.getIdentifier(), Specification.class.getName()), null);
        }
        return report;
    }

    public ModelValidationReport validateModelObjects(Implementation implementation, Unmarshaller unmarshaller, JavaClass javaClass) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        assert (this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        try {
            Specifications specifications;
            Messages messages;
            Properties properties;
            ModelValidationReport report = new ModelValidationReport();
            Dependencies dependencies = this.getModules().getDependencies(implementation.getIdentifier());
            if (dependencies == null) {
                dependencies = new Dependencies();
            }
            if ((properties = this.getModules().getProperties(implementation.getIdentifier())) == null) {
                properties = new Properties();
            }
            if ((messages = this.getModules().getMessages(implementation.getIdentifier())) == null) {
                messages = new Messages();
            }
            if ((specifications = this.getModules().getSpecifications(implementation.getIdentifier())) == null) {
                specifications = new Specifications();
            }
            Dependencies decodedDependencies = null;
            byte[] bytes = this.getClassfileAttribute(javaClass, Dependencies.class.getName());
            if (bytes != null) {
                decodedDependencies = this.decodeModelObject(unmarshaller, bytes, Dependencies.class);
            }
            Properties decodedProperties = null;
            bytes = this.getClassfileAttribute(javaClass, Properties.class.getName());
            if (bytes != null) {
                decodedProperties = this.decodeModelObject(unmarshaller, bytes, Properties.class);
            }
            Messages decodedMessages = null;
            bytes = this.getClassfileAttribute(javaClass, Messages.class.getName());
            if (bytes != null) {
                decodedMessages = this.decodeModelObject(unmarshaller, bytes, Messages.class);
            }
            Specifications decodedSpecifications = null;
            bytes = this.getClassfileAttribute(javaClass, Specifications.class.getName());
            if (bytes != null) {
                decodedSpecifications = this.decodeModelObject(unmarshaller, bytes, Specifications.class);
            }
            if (decodedDependencies != null) {
                for (Dependency decodedDependency : decodedDependencies.getDependency()) {
                    Dependency dependency = dependencies.getDependency(decodedDependency.getName());
                    Specification s = this.getModules().getSpecification(decodedDependency.getIdentifier());
                    if (dependency == null) {
                        report.getDetails().add(new ModelValidationReport.Detail("CLASS_MISSING_IMPLEMENTATION_DEPENDENCY", Level.SEVERE, ClassFileProcessor.getMessage("missingDependency", implementation.getIdentifier(), decodedDependency.getName()), new ObjectFactory().createImplementation(implementation)));
                    } else if (decodedDependency.getImplementationName() != null && dependency.getImplementationName() == null) {
                        report.getDetails().add(new ModelValidationReport.Detail("CLASS_MISSING_DEPENDENCY_IMPLEMENTATION_NAME", Level.SEVERE, ClassFileProcessor.getMessage("missingDependencyImplementationName", implementation.getIdentifier(), decodedDependency.getName()), new ObjectFactory().createImplementation(implementation)));
                    }
                    if (s == null || s.getVersion() == null || decodedDependency.getVersion() == null || VersionParser.compare((String)decodedDependency.getVersion(), (String)s.getVersion()) <= 0) continue;
                    Module moduleOfSpecification = this.getModules().getModuleOfSpecification(s.getIdentifier());
                    Module moduleOfImplementation = this.getModules().getModuleOfImplementation(implementation.getIdentifier());
                    report.getDetails().add(new ModelValidationReport.Detail("CLASS_INCOMPATIBLE_IMPLEMENTATION_DEPENDENCY", Level.SEVERE, ClassFileProcessor.getMessage("incompatibleDependency", javaClass.getClassName(), moduleOfImplementation == null ? "<>" : moduleOfImplementation.getName(), s.getIdentifier(), moduleOfSpecification == null ? "<>" : moduleOfSpecification.getName(), decodedDependency.getVersion(), s.getVersion()), new ObjectFactory().createImplementation(implementation)));
                }
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("cannotValidateImplementation", implementation.getIdentifier(), Dependencies.class.getName()), null);
            }
            if (decodedProperties != null) {
                for (Property decodedProperty : decodedProperties.getProperty()) {
                    Property property = properties.getProperty(decodedProperty.getName());
                    if (property == null) {
                        report.getDetails().add(new ModelValidationReport.Detail("CLASS_MISSING_IMPLEMENTATION_PROPERTY", Level.SEVERE, ClassFileProcessor.getMessage("missingProperty", implementation.getIdentifier(), decodedProperty.getName()), new ObjectFactory().createImplementation(implementation)));
                        continue;
                    }
                    if (!(decodedProperty.getType() == null ? property.getType() != null : !decodedProperty.getType().equals(property.getType()))) continue;
                    report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_IMPLEMENTATION_PROPERTY", Level.SEVERE, ClassFileProcessor.getMessage("illegalPropertyType", implementation.getIdentifier(), decodedProperty.getName(), property.getType() == null ? "<>" : property.getType(), decodedProperty.getType() == null ? "<>" : decodedProperty.getType()), new ObjectFactory().createImplementation(implementation)));
                }
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("cannotValidateImplementation", implementation.getIdentifier(), Properties.class.getName()), null);
            }
            if (decodedMessages != null) {
                for (Message decodedMessage : decodedMessages.getMessage()) {
                    Message message = messages.getMessage(decodedMessage.getName());
                    if (message != null) continue;
                    report.getDetails().add(new ModelValidationReport.Detail("CLASS_MISSING_IMPLEMENTATION_MESSAGE", Level.SEVERE, ClassFileProcessor.getMessage("missingMessage", implementation.getIdentifier(), decodedMessage.getName()), new ObjectFactory().createImplementation(implementation)));
                }
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("cannotValidateImplementation", implementation.getIdentifier(), Messages.class.getName()), null);
            }
            if (decodedSpecifications != null) {
                Specification specification;
                for (Specification decodedSpecification : decodedSpecifications.getSpecification()) {
                    specification = this.getModules().getSpecification(decodedSpecification.getIdentifier());
                    if (specification == null) {
                        report.getDetails().add(new ModelValidationReport.Detail("CLASS_MISSING_SPECIFICATION", Level.SEVERE, ClassFileProcessor.getMessage("missingSpecification", implementation.getIdentifier(), decodedSpecification.getIdentifier()), new ObjectFactory().createImplementation(implementation)));
                        continue;
                    }
                    if (decodedSpecification.getMultiplicity() != specification.getMultiplicity()) {
                        report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_SPECIFICATION_MULTIPLICITY", Level.SEVERE, ClassFileProcessor.getMessage("illegalMultiplicity", specification.getIdentifier(), specification.getMultiplicity().value(), decodedSpecification.getMultiplicity().value()), new ObjectFactory().createImplementation(implementation)));
                    }
                    if (decodedSpecification.getScope() == null ? specification.getScope() != null : !decodedSpecification.getScope().equals(specification.getScope())) {
                        report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_SPECIFICATION_SCOPE", Level.SEVERE, ClassFileProcessor.getMessage("illegalScope", decodedSpecification.getIdentifier(), specification.getScope() == null ? "Multiton" : specification.getScope(), decodedSpecification.getScope() == null ? "Multiton" : decodedSpecification.getScope()), new ObjectFactory().createImplementation(implementation)));
                    }
                    if (!(decodedSpecification.getClazz() == null ? specification.getClazz() != null : !decodedSpecification.getClazz().equals(specification.getClazz()))) continue;
                    report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_SPECIFICATION_CLASS", Level.SEVERE, ClassFileProcessor.getMessage("illegalSpecificationClass", decodedSpecification.getIdentifier(), specification.getClazz(), decodedSpecification.getClazz()), new ObjectFactory().createImplementation(implementation)));
                }
                for (SpecificationReference decodedReference : decodedSpecifications.getReference()) {
                    specification = specifications.getSpecification(decodedReference.getIdentifier());
                    if (specification == null) {
                        report.getDetails().add(new ModelValidationReport.Detail("CLASS_MISSING_SPECIFICATION", Level.SEVERE, ClassFileProcessor.getMessage("missingSpecification", implementation.getIdentifier(), decodedReference.getIdentifier()), new ObjectFactory().createImplementation(implementation)));
                        continue;
                    }
                    if (decodedReference.getVersion() == null || specification.getVersion() == null || VersionParser.compare((String)decodedReference.getVersion(), (String)specification.getVersion()) == 0) continue;
                    Module moduleOfSpecification = this.getModules().getModuleOfSpecification(decodedReference.getIdentifier());
                    Module moduleOfImplementation = this.getModules().getModuleOfImplementation(implementation.getIdentifier());
                    report.getDetails().add(new ModelValidationReport.Detail("CLASS_INCOMPATIBLE_IMPLEMENTATION", Level.SEVERE, ClassFileProcessor.getMessage("incompatibleImplementation", javaClass.getClassName(), moduleOfImplementation == null ? "<>" : moduleOfImplementation.getName(), specification.getIdentifier(), moduleOfSpecification == null ? "<>" : moduleOfSpecification.getName(), decodedReference.getVersion(), specification.getVersion()), new ObjectFactory().createImplementation(implementation)));
                }
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("cannotValidateImplementation", implementation.getIdentifier(), Specifications.class.getName()), null);
            }
            return report;
        }
        catch (ParseException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        catch (TokenMgrError e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final void transformModelObjects(ModelContext context, File classesDirectory, List<Transformer> transformers) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        if (transformers == null) {
            throw new NullPointerException("transformers");
        }
        try {
            Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
            Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
            Schema s = context.createSchema(this.getModel().getIdentifier());
            u.setSchema(s);
            m.setSchema(s);
            this.transformModelObjects(this.getModules().getSpecifications(), this.getModules().getImplementations(), u, m, classesDirectory, transformers);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final void transformModelObjects(Module module, ModelContext context, File classesDirectory, List<Transformer> transformers) throws IOException {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        if (transformers == null) {
            throw new NullPointerException("transformers");
        }
        assert (this.getModules().getModule(module.getName()) != null) : "Module '" + module.getName() + "' not found.";
        try {
            Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
            Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
            Schema s = context.createSchema(this.getModel().getIdentifier());
            u.setSchema(s);
            m.setSchema(s);
            this.transformModelObjects(module.getSpecifications(), module.getImplementations(), u, m, classesDirectory, transformers);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final void transformModelObjects(Specification specification, ModelContext context, File classesDirectory, List<Transformer> transformers) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        if (transformers == null) {
            throw new NullPointerException("transformers");
        }
        assert (this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        try {
            Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
            Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
            Schema s = context.createSchema(this.getModel().getIdentifier());
            u.setSchema(s);
            m.setSchema(s);
            this.transformModelObjects(specification, m, u, classesDirectory, transformers);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public final void transformModelObjects(Implementation implementation, ModelContext context, File classesDirectory, List<Transformer> transformers) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        if (transformers == null) {
            throw new NullPointerException("transformers");
        }
        assert (this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        try {
            Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
            Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
            Schema s = context.createSchema(this.getModel().getIdentifier());
            u.setSchema(s);
            m.setSchema(s);
            this.transformModelObjects(implementation, m, u, classesDirectory, transformers);
        }
        catch (ModelException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public void transformModelObjects(Specification specification, Marshaller marshaller, Unmarshaller unmarshaller, JavaClass javaClass, List<Transformer> transformers) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        if (transformers == null) {
            throw new NullPointerException("transformers");
        }
        assert (this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        try {
            Specification decodedSpecification = null;
            ObjectFactory objectFactory = new ObjectFactory();
            byte[] bytes = this.getClassfileAttribute(javaClass, Specification.class.getName());
            if (bytes != null) {
                decodedSpecification = this.decodeModelObject(unmarshaller, bytes, Specification.class);
            }
            if (decodedSpecification != null) {
                for (Transformer transformer : transformers) {
                    JAXBSource source = new JAXBSource(marshaller, (Object)objectFactory.createSpecification(decodedSpecification));
                    JAXBResult result = new JAXBResult(unmarshaller);
                    transformer.transform((Source)source, (Result)result);
                    decodedSpecification = (Specification)((JAXBElement)result.getResult()).getValue();
                }
                this.setClassfileAttribute(javaClass, Specification.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)objectFactory.createSpecification(decodedSpecification)));
            }
        }
        catch (JAXBException e) {
            String message = e.getMessage();
            if (message == null && e.getLinkedException() != null) {
                message = e.getLinkedException().getMessage();
            }
            throw (IOException)new IOException(message).initCause(e);
        }
        catch (TransformerException e) {
            String message = e.getMessage();
            if (message == null && e.getException() != null) {
                message = e.getException().getMessage();
            }
            throw (IOException)new IOException(message).initCause(e);
        }
    }

    public void transformModelObjects(Implementation implementation, Marshaller marshaller, Unmarshaller unmarshaller, JavaClass javaClass, List<Transformer> transformers) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        if (transformers == null) {
            throw new NullPointerException("transformers");
        }
        assert (this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        try {
            Dependencies decodedDependencies = null;
            byte[] bytes = this.getClassfileAttribute(javaClass, Dependencies.class.getName());
            if (bytes != null) {
                decodedDependencies = this.decodeModelObject(unmarshaller, bytes, Dependencies.class);
            }
            Messages decodedMessages = null;
            bytes = this.getClassfileAttribute(javaClass, Messages.class.getName());
            if (bytes != null) {
                decodedMessages = this.decodeModelObject(unmarshaller, bytes, Messages.class);
            }
            Properties decodedProperties = null;
            bytes = this.getClassfileAttribute(javaClass, Properties.class.getName());
            if (bytes != null) {
                decodedProperties = this.decodeModelObject(unmarshaller, bytes, Properties.class);
            }
            Specifications decodedSpecifications = null;
            bytes = this.getClassfileAttribute(javaClass, Specifications.class.getName());
            if (bytes != null) {
                decodedSpecifications = this.decodeModelObject(unmarshaller, bytes, Specifications.class);
            }
            ObjectFactory of = new ObjectFactory();
            for (Transformer transformer : transformers) {
                JAXBResult result;
                JAXBSource source;
                if (decodedDependencies != null) {
                    source = new JAXBSource(marshaller, (Object)of.createDependencies(decodedDependencies));
                    result = new JAXBResult(unmarshaller);
                    transformer.transform((Source)source, (Result)result);
                    decodedDependencies = (Dependencies)((JAXBElement)result.getResult()).getValue();
                }
                if (decodedMessages != null) {
                    source = new JAXBSource(marshaller, (Object)of.createMessages(decodedMessages));
                    result = new JAXBResult(unmarshaller);
                    transformer.transform((Source)source, (Result)result);
                    decodedMessages = (Messages)((JAXBElement)result.getResult()).getValue();
                }
                if (decodedProperties != null) {
                    source = new JAXBSource(marshaller, (Object)of.createProperties(decodedProperties));
                    result = new JAXBResult(unmarshaller);
                    transformer.transform((Source)source, (Result)result);
                    decodedProperties = (Properties)((JAXBElement)result.getResult()).getValue();
                }
                if (decodedSpecifications == null) continue;
                source = new JAXBSource(marshaller, (Object)of.createSpecifications(decodedSpecifications));
                result = new JAXBResult(unmarshaller);
                transformer.transform((Source)source, (Result)result);
                decodedSpecifications = (Specifications)((JAXBElement)result.getResult()).getValue();
            }
            if (decodedDependencies != null) {
                this.setClassfileAttribute(javaClass, Dependencies.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createDependencies(decodedDependencies)));
            }
            if (decodedMessages != null) {
                this.setClassfileAttribute(javaClass, Messages.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createMessages(decodedMessages)));
            }
            if (decodedProperties != null) {
                this.setClassfileAttribute(javaClass, Properties.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createProperties(decodedProperties)));
            }
            if (decodedSpecifications != null) {
                this.setClassfileAttribute(javaClass, Specifications.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createSpecifications(decodedSpecifications)));
            }
        }
        catch (JAXBException e) {
            String message = e.getMessage();
            if (message == null && e.getLinkedException() != null) {
                message = e.getLinkedException().getMessage();
            }
            throw (IOException)new IOException(message).initCause(e);
        }
        catch (TransformerException e) {
            String message = e.getMessage();
            if (message == null && e.getException() != null) {
                message = e.getException().getMessage();
            }
            throw (IOException)new IOException(message).initCause(e);
        }
    }

    public byte[] getClassfileAttribute(JavaClass clazz, String attributeName) throws IOException {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (attributeName == null) {
            throw new NullPointerException("attributeName");
        }
        Attribute[] attributes = clazz.getAttributes();
        for (int i = attributes.length - 1; i >= 0; --i) {
            Constant constant = clazz.getConstantPool().getConstant(attributes[i].getNameIndex());
            if (!(constant instanceof ConstantUtf8) || !attributeName.equals(((ConstantUtf8)constant).getBytes())) continue;
            Unknown unknown = (Unknown)attributes[i];
            return unknown.getBytes();
        }
        return null;
    }

    public void setClassfileAttribute(JavaClass clazz, String attributeName, byte[] data) throws IOException {
        Constant[] tmp;
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (attributeName == null) {
            throw new NullPointerException("attributeName");
        }
        byte[] attributeData = data != null ? data : NO_BYTES;
        Attribute[] attributes = clazz.getAttributes();
        int attributeIndex = -1;
        int nameIndex = -1;
        for (int i = attributes.length - 1; i >= 0; --i) {
            Constant constant = clazz.getConstantPool().getConstant(attributes[i].getNameIndex());
            if (!(constant instanceof ConstantUtf8) || !attributeName.equals(((ConstantUtf8)constant).getBytes())) continue;
            attributeIndex = i;
            nameIndex = attributes[i].getNameIndex();
        }
        if (nameIndex == -1) {
            Constant[] pool = clazz.getConstantPool().getConstantPool();
            tmp = new Constant[pool.length + 1];
            System.arraycopy(pool, 0, tmp, 0, pool.length);
            tmp[pool.length] = new ConstantUtf8(attributeName);
            nameIndex = pool.length;
            clazz.setConstantPool(new ConstantPool(tmp));
        }
        Unknown unknown = new Unknown(nameIndex, attributeData.length, attributeData, clazz.getConstantPool());
        if (attributeIndex == -1) {
            tmp = new Attribute[attributes.length + 1];
            System.arraycopy(attributes, 0, tmp, 0, attributes.length);
            tmp[attributes.length] = unknown;
            attributes = tmp;
        } else {
            attributes[attributeIndex] = unknown;
        }
        clazz.setAttributes(attributes);
    }

    public byte[] encodeModelObject(Marshaller marshaller, JAXBElement<? extends ModelObject> modelObject) throws IOException {
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        if (modelObject == null) {
            throw new NullPointerException("modelObject");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(baos);
            marshaller.marshal(modelObject, (OutputStream)out);
            out.close();
            return baos.toByteArray();
        }
        catch (JAXBException e) {
            String message = e.getMessage();
            if (message == null && e.getLinkedException() != null) {
                message = e.getLinkedException().getMessage();
            }
            throw (IOException)new IOException(message).initCause(e);
        }
    }

    public <T extends ModelObject> T decodeModelObject(Unmarshaller unmarshaller, byte[] bytes, Class<T> type) throws IOException {
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            GZIPInputStream in = new GZIPInputStream(bais);
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal((InputStream)in);
            in.close();
            return (T)((ModelObject)element.getValue());
        }
        catch (JAXBException e) {
            String message = e.getMessage();
            if (message == null && e.getLinkedException() != null) {
                message = e.getLinkedException().getMessage();
            }
            throw (IOException)new IOException(message).initCause(e);
        }
    }

    private void commitModelObjects(Specifications specifications, Implementations implementations, Marshaller marshaller, File classesDirectory) throws IOException {
        if (specifications != null) {
            for (Specification s : specifications.getSpecification()) {
                this.commitModelObjects(s, marshaller, classesDirectory);
            }
        }
        if (implementations != null) {
            for (Implementation i : implementations.getImplementation()) {
                this.commitModelObjects(i, marshaller, classesDirectory);
            }
        }
    }

    private void commitModelObjects(Specification specification, Marshaller marshaller, File classesDirectory) throws IOException {
        if (specification.isClassDeclaration()) {
            String classLocation = specification.getClazz().replace('.', File.separatorChar) + ".class";
            File classFile = new File(classesDirectory, classLocation);
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("committing", classFile.getAbsolutePath()), null);
            }
            JavaClass javaClass = new ClassParser(classFile.getAbsolutePath()).parse();
            this.commitModelObjects(specification, marshaller, javaClass);
            javaClass.dump(classFile);
        }
    }

    private void commitModelObjects(Implementation implementation, Marshaller marshaller, File classesDirectory) throws IOException {
        if (implementation.isClassDeclaration()) {
            String classLocation = implementation.getClazz().replace('.', File.separatorChar) + ".class";
            File classFile = new File(classesDirectory, classLocation);
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("committing", classFile.getAbsolutePath()), null);
            }
            JavaClass javaClass = new ClassParser(classFile.getAbsolutePath()).parse();
            this.commitModelObjects(implementation, marshaller, javaClass);
            javaClass.dump(classFile);
        }
    }

    private ModelValidationReport validateModelObjects(Specifications specifications, Implementations implementations, Unmarshaller unmarshaller, File classesDirectory) throws IOException {
        ModelValidationReport current;
        ModelValidationReport report = new ModelValidationReport();
        if (specifications != null) {
            for (Specification s : specifications.getSpecification()) {
                current = this.validateModelObjects(s, unmarshaller, classesDirectory);
                report.getDetails().addAll(current.getDetails());
            }
        }
        if (implementations != null) {
            for (Implementation i : implementations.getImplementation()) {
                current = this.validateModelObjects(i, unmarshaller, classesDirectory);
                report.getDetails().addAll(current.getDetails());
            }
        }
        return report;
    }

    private ModelValidationReport validateModelObjects(Specification specification, Unmarshaller unmarshaller, File classesDirectory) throws IOException {
        ModelValidationReport report = new ModelValidationReport();
        if (specification.isClassDeclaration()) {
            String classLocation = specification.getClazz().replace('.', File.separatorChar) + ".class";
            File classFile = new File(classesDirectory, classLocation);
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("validating", classFile.getAbsolutePath()), null);
            }
            ModelValidationReport current = this.validateModelObjects(specification, unmarshaller, new ClassParser(classFile.getAbsolutePath()).parse());
            report.getDetails().addAll(current.getDetails());
        }
        return report;
    }

    private ModelValidationReport validateModelObjects(Implementation implementation, Unmarshaller unmarshaller, File classesDirectory) throws IOException {
        ModelValidationReport report = new ModelValidationReport();
        if (implementation.isClassDeclaration()) {
            String classLocation = implementation.getClazz().replace('.', File.separatorChar) + ".class";
            File classFile = new File(classesDirectory, classLocation);
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("validating", classFile.getAbsolutePath()), null);
            }
            ModelValidationReport current = this.validateModelObjects(implementation, unmarshaller, new ClassParser(classFile.getAbsolutePath()).parse());
            report.getDetails().addAll(current.getDetails());
        }
        return report;
    }

    private ModelValidationReport validateModelObjects(Specifications specifications, Implementations implementations, Unmarshaller unmarshaller, ClassLoader classLoader) throws IOException {
        ModelValidationReport current;
        ModelValidationReport report = new ModelValidationReport();
        if (specifications != null) {
            for (Specification s : specifications.getSpecification()) {
                current = this.validateModelObjects(s, unmarshaller, classLoader);
                report.getDetails().addAll(current.getDetails());
            }
        }
        if (implementations != null) {
            for (Implementation i : implementations.getImplementation()) {
                current = this.validateModelObjects(i, unmarshaller, classLoader);
                report.getDetails().addAll(current.getDetails());
            }
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelValidationReport validateModelObjects(Specification specification, Unmarshaller unmarshaller, ClassLoader classLoader) throws IOException {
        ModelValidationReport report = new ModelValidationReport();
        if (specification.isClassDeclaration()) {
            URL classUrl;
            String classLocation = specification.getClazz().replace('.', '/') + ".class";
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("validatingSpecification", specification.getIdentifier()), null);
            }
            if ((classUrl = classLoader.getResource(classLocation)) == null) {
                throw new IOException(ClassFileProcessor.getMessage("resourceNotFound", classLocation));
            }
            InputStream in = null;
            JavaClass javaClass = null;
            try {
                in = classUrl.openStream();
                javaClass = new ClassParser(in, classUrl.toExternalForm()).parse();
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            ModelValidationReport current = this.validateModelObjects(specification, unmarshaller, javaClass);
            report.getDetails().addAll(current.getDetails());
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelValidationReport validateModelObjects(Implementation implementation, Unmarshaller unmarshaller, ClassLoader classLoader) throws IOException {
        ModelValidationReport report = new ModelValidationReport();
        if (implementation.isClassDeclaration()) {
            URL classUrl;
            String classLocation = implementation.getClazz().replace('.', '/') + ".class";
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("validatingImplementation", implementation.getIdentifier()), null);
            }
            if ((classUrl = classLoader.getResource(classLocation)) == null) {
                throw new IOException(ClassFileProcessor.getMessage("resourceNotFound", classLocation));
            }
            InputStream in = null;
            JavaClass javaClass = null;
            try {
                in = classUrl.openStream();
                javaClass = new ClassParser(in, classUrl.toExternalForm()).parse();
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            ModelValidationReport current = this.validateModelObjects(implementation, unmarshaller, javaClass);
            report.getDetails().addAll(current.getDetails());
        }
        return report;
    }

    private void transformModelObjects(Specifications specifications, Implementations implementations, Unmarshaller unmarshaller, Marshaller marshaller, File classesDirectory, List<Transformer> transformers) throws IOException {
        if (specifications != null) {
            for (Specification s : specifications.getSpecification()) {
                this.transformModelObjects(s, marshaller, unmarshaller, classesDirectory, transformers);
            }
        }
        if (implementations != null) {
            for (Implementation i : implementations.getImplementation()) {
                this.transformModelObjects(i, marshaller, unmarshaller, classesDirectory, transformers);
            }
        }
    }

    private void transformModelObjects(Specification specification, Marshaller marshaller, Unmarshaller unmarshaller, File classesDirectory, List<Transformer> transformers) throws IOException {
        if (specification.isClassDeclaration()) {
            String classLocation = specification.getClazz().replace('.', File.separatorChar) + ".class";
            File classFile = new File(classesDirectory, classLocation);
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("transforming", classFile.getAbsolutePath()), null);
            }
            JavaClass javaClass = new ClassParser(classFile.getAbsolutePath()).parse();
            this.transformModelObjects(specification, marshaller, unmarshaller, javaClass, transformers);
            javaClass.dump(classFile);
        }
    }

    private void transformModelObjects(Implementation implementation, Marshaller marshaller, Unmarshaller unmarshaller, File classesDirectory, List<Transformer> transformers) throws IOException {
        if (implementation.isClassDeclaration()) {
            String classLocation = implementation.getClazz().replace('.', File.separatorChar) + ".class";
            File classFile = new File(classesDirectory, classLocation);
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("transforming", classFile.getAbsolutePath()), null);
            }
            JavaClass javaClass = new ClassParser(classFile.getAbsolutePath()).parse();
            this.transformModelObjects(implementation, marshaller, unmarshaller, javaClass, transformers);
            javaClass.dump(classFile);
        }
    }

    private static String getMessage(String key, Object ... arguments) {
        return MessageFormat.format(ResourceBundle.getBundle(ClassFileProcessor.class.getName().replace('.', '/')).getString(key), arguments);
    }
}

