/*
 * Decompiled with CFR 0.152.
 */
package jolie.cli;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.stream.Collectors;
import jolie.Interpreter;
import jolie.JolieClassLoader;
import jolie.cli.CommandLineException;
import jolie.jap.JapURLConnection;
import jolie.lang.Constants;
import jolie.lang.parse.Scanner;
import jolie.runtime.correlation.CorrelationEngine;
import jolie.util.UriUtils;

public class CommandLineParser
implements Closeable {
    private static final String OPTION_SEPARATOR = " ";
    private final int connectionsLimit;
    private final CorrelationEngine.Type correlationAlgorithmType;
    private final String[] includePaths;
    private final String[] packagePaths;
    private final String[] optionArgs;
    private final URL[] libURLs;
    private final InputStream programStream;
    private String charset = null;
    private final File programFilepath;
    private final String[] arguments;
    private final Map<String, Scanner.Token> constants = new HashMap<String, Scanner.Token>();
    private final JolieClassLoader jolieClassLoader;
    private final boolean isProgramCompiled;
    private final boolean typeCheck;
    private final boolean tracer;
    private final String tracerMode;
    private final String tracerLevel;
    private final boolean check;
    private final long responseTimeout;
    private final boolean printStackTraces;
    private final Level logLevel;
    private final String executionTarget;
    private final Optional<Path> parametersFilepath;
    private File programDirectory = null;
    private int cellId = 0;

    @Override
    public void close() throws IOException {
        this.programStream.close();
    }

    private static String getOptionString(String option, String description) {
        return '\t' + option + "\t\t" + description + '\n';
    }

    private String getVersionString() {
        return "Jolie " + Constants.VERSION + "  " + "(C) 2006-2021 the Jolie developers";
    }

    public int cellId() {
        return this.cellId;
    }

    protected String getHelpString() {
        return this.getVersionString() + "\n\nUsage: jolie [options] program_file [program arguments]\n\n" + "Available options:\n" + CommandLineParser.getOptionString("-h, --help", "Display this help information") + CommandLineParser.getOptionString("-C ConstantIdentifier=ConstantValue", "Sets constant ConstantIdentifier to ConstantValue before starting execution \n" + "-C ConstantIdentifier=ConstantValue".replaceAll("(.)", OPTION_SEPARATOR) + "\t\t\t(under Windows use quotes or double-quotes, e.g., -C \"ConstantIdentifier=ConstantValue\" )") + CommandLineParser.getOptionString("--connlimit [number]", "Set the maximum number of active connection threads") + CommandLineParser.getOptionString("--conncache [number]", "Set the maximum number of cached persistent output connections") + CommandLineParser.getOptionString("--responseTimeout [number]", "Set the timeout for request-response invocations (in milliseconds)") + CommandLineParser.getOptionString("--correlationAlgorithm [simple|hash]", "Set the algorithm to use for message correlation") + CommandLineParser.getOptionString("--log [severe|warning|info|fine]", "Set the logging level (default: info)") + CommandLineParser.getOptionString("--stackTraces", "Activate the printing of Java stack traces (default: false)") + CommandLineParser.getOptionString("--typecheck [true|false]", "Check for correlation and other data related typing errors (default: false)") + CommandLineParser.getOptionString("--check", "Check for syntactic and semantic errors.") + CommandLineParser.getOptionString("--trace [console|file]", "Activate tracer. console prints out in the console, file creates a json file") + CommandLineParser.getOptionString("--traceLevel [all|comm|comp]", "Defines tracer level: all - all the traces; comm - only communication traces; comp - only computation traces. Default is all. ") + CommandLineParser.getOptionString("--charset [character encoding, e.g., UTF-8]", "Character encoding of the source *.ol/*.iol (default: system-dependent, on GNU/Linux UTF-8)") + CommandLineParser.getOptionString("-p PATH", "Add PATH to the set of paths where modules are looked up") + CommandLineParser.getOptionString("-s [service name], --service [service name]", "Specify a service in the module to execute (not necessary if the module contains only one service definition)") + CommandLineParser.getOptionString("--params json_file", "Use the contents of json_file as the argument of the service being executed.") + CommandLineParser.getOptionString("--version", "Display this program version information") + CommandLineParser.getOptionString("--cellId", "set an integer as cell identifier, used for creating message ids. (max: 2147483647)");
    }

    private void parseCommandLineConstant(String input) throws IOException {
        try {
            String id;
            Scanner scanner = new Scanner((InputStream)new ByteArrayInputStream(input.getBytes()), new URI("urn:CommandLine"), null);
            Scanner.Token token = scanner.getToken();
            if (token.is(Scanner.TokenType.ID)) {
                id = token.content();
                token = scanner.getToken();
                if (token.isNot(Scanner.TokenType.ASSIGN)) {
                    throw new IOException("expected = after constant identifier " + id + ", found token type " + token.type());
                }
                token = scanner.getToken();
                if (!token.isValidConstant()) {
                    throw new IOException("expected constant value for constant identifier " + id + ", found token type " + token.type());
                }
            } else {
                throw new IOException("expected constant identifier, found token type " + token.type());
            }
            this.constants.put(id, token);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public CommandLineParser(String[] args, ClassLoader parentClassLoader) throws CommandLineException, IOException {
        this(args, parentClassLoader, ArgumentHandler.DEFAULT_ARGUMENT_HANDLER);
    }

    public CommandLineParser(String[] args, ClassLoader parentClassLoader, ArgumentHandler argHandler) throws CommandLineException, IOException {
        this(args, parentClassLoader, argHandler, false);
    }

    public CommandLineParser(String[] args, ClassLoader parentClassLoader, boolean ignoreFile) throws CommandLineException, IOException {
        this(args, parentClassLoader, ArgumentHandler.DEFAULT_ARGUMENT_HANDLER, ignoreFile);
    }

    public CommandLineParser(String[] args, ClassLoader parentClassLoader, ArgumentHandler argHandler, boolean ignoreFile) throws CommandLineException, IOException {
        int i;
        List<String> argsList = Arrays.asList(args);
        String csetAlgorithmName = "simple";
        LinkedList<String> optionsList = new LinkedList<String>();
        boolean bTracer = false;
        boolean bStackTraces = false;
        boolean bCheck = false;
        boolean bTypeCheck = false;
        Level lLogLevel = Level.INFO;
        String tMode = "console";
        String tLevel = "all";
        ArrayList<String> programArgumentsList = new ArrayList<String>();
        LinkedList<String> includeList = new LinkedList<String>();
        ArrayList<String> libList = new ArrayList<String>();
        ArrayList packagesList = new ArrayList();
        int cLimit = -1;
        long rTimeout = 36000000L;
        String pwd = UriUtils.normalizeWindowsPath((String)new File("").getCanonicalPath());
        String tService = null;
        Path tParams = null;
        includeList.add(pwd);
        includeList.add("include");
        libList.add(pwd);
        libList.add("ext");
        libList.add("lib");
        String olFilepath = null;
        String japUrl = null;
        for (i = 0; i < argsList.size() && olFilepath == null; ++i) {
            Object path;
            if ("--help".equals(argsList.get(i)) || "-h".equals(argsList.get(i))) {
                throw new CommandLineException(this.getHelpString());
            }
            if ("-C".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                ++i;
                try {
                    this.parseCommandLineConstant(argsList.get(i));
                }
                catch (IOException e) {
                    throw new CommandLineException("Invalid constant definition, reason: " + e.getMessage());
                }
                optionsList.add(argsList.get(i));
                continue;
            }
            if ("-i".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                ++i;
                if (japUrl != null) {
                    argsList.set(i, argsList.get(i).replace("$JAP$", japUrl));
                }
                Collections.addAll(includeList, argsList.get(i).split(Constants.PATH_SEPARATOR));
                optionsList.add(argsList.get(i));
                continue;
            }
            if ("-l".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                ++i;
                if (japUrl != null) {
                    argsList.set(i, argsList.get(i).replace("$JAP$", japUrl));
                }
                String[] tmp = argsList.get(i).split(Constants.PATH_SEPARATOR);
                for (String libPath : tmp) {
                    path = CommandLineParser.findLibPath(libPath, includeList, parentClassLoader);
                    ((Optional)path).ifPresent(libList::add);
                }
                optionsList.add(argsList.get(i));
                continue;
            }
            if ("-p".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                Collections.addAll(packagesList, argsList.get(++i).split(Constants.PATH_SEPARATOR));
                optionsList.add(argsList.get(i));
                continue;
            }
            if ("--connlimit".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                cLimit = Integer.parseInt(argsList.get(++i));
                optionsList.add(argsList.get(i));
                continue;
            }
            if ("--responseTimeout".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                rTimeout = Long.parseLong(argsList.get(++i));
                optionsList.add(argsList.get(i));
                continue;
            }
            if ("--correlationAlgorithm".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                csetAlgorithmName = argsList.get(++i);
                optionsList.add(argsList.get(i));
                continue;
            }
            if ("--typecheck".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                String typeCheckStr = argsList.get(++i);
                optionsList.add(argsList.get(i));
                if ("false".equals(typeCheckStr)) {
                    bTypeCheck = false;
                    continue;
                }
                if (!"true".equals(typeCheckStr)) continue;
                bTypeCheck = true;
                continue;
            }
            if ("--stackTraces".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                bStackTraces = true;
                continue;
            }
            if ("--check".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                bCheck = true;
                continue;
            }
            if ("--trace".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                bTracer = true;
                switch (argsList.get(i + 1)) {
                    case "console": {
                        tMode = "console";
                        optionsList.add(argsList.get(++i));
                        break;
                    }
                    case "file": {
                        tMode = "file";
                        optionsList.add(argsList.get(++i));
                    }
                }
                continue;
            }
            if ("--traceLevel".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                switch (argsList.get(i + 1)) {
                    case "all": {
                        tLevel = "all";
                        optionsList.add(argsList.get(++i));
                        break;
                    }
                    case "comm": {
                        tLevel = "comm";
                        optionsList.add(argsList.get(++i));
                        break;
                    }
                    case "comp": {
                        tLevel = "comp";
                        optionsList.add(argsList.get(++i));
                    }
                }
                continue;
            }
            if ("--log".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                String level = argsList.get(++i);
                switch (level) {
                    case "severe": {
                        lLogLevel = Level.SEVERE;
                        break;
                    }
                    case "warning": {
                        lLogLevel = Level.WARNING;
                        break;
                    }
                    case "fine": {
                        lLogLevel = Level.FINE;
                        break;
                    }
                    case "info": {
                        lLogLevel = Level.INFO;
                    }
                }
                optionsList.add(argsList.get(i));
                continue;
            }
            if ("--charset".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                this.charset = argsList.get(++i);
                optionsList.add(argsList.get(i));
                continue;
            }
            if ("--cellId".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                ++i;
                try {
                    this.cellId = Integer.parseInt(argsList.get(i));
                }
                catch (Exception e) {
                    System.out.println("The number specified for cellId (" + argsList.get(i) + ") is not allowed. Set to 0");
                }
                optionsList.add(argsList.get(i));
                continue;
            }
            if ("--service".equals(argsList.get(i)) || "-s".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                ++i;
                if (tService != null) {
                    throw new CommandLineException("Execution service is already defined");
                }
                tService = argsList.get(i);
                optionsList.add(argsList.get(i));
                continue;
            }
            if ("--params".equals(argsList.get(i))) {
                optionsList.add(argsList.get(i));
                ++i;
                if (tParams != null) {
                    throw new CommandLineException("Service parameters file already specified");
                }
                tParams = Paths.get(argsList.get(i), new String[0]);
                optionsList.add(argsList.get(i));
                if (Files.exists(tParams, new LinkOption[0])) continue;
                throw new FileNotFoundException(argsList.get(i));
            }
            if ("--version".equals(argsList.get(i))) {
                throw new CommandLineException(this.getVersionString());
            }
            if (olFilepath == null && !argsList.get(i).startsWith("-")) {
                String path2 = argsList.get(i);
                if (path2.endsWith(".jap")) {
                    for (String includePath : CommandLineParser.prepend("", includeList)) {
                        try {
                            String japFilename = UriUtils.normalizeJolieUri((String)UriUtils.normalizeWindowsPath((String)UriUtils.resolve((String)includePath, (String)path2)));
                            if (!Files.exists(Paths.get(japFilename, new String[0]), new LinkOption[0])) continue;
                            JarFile japFile = new JarFile(japFilename);
                            path = null;
                            try {
                                Manifest manifest = japFile.getManifest();
                                olFilepath = UriUtils.normalizeWindowsPath((String)CommandLineParser.parseJapManifestForMainProgram(manifest, japFile));
                                libList.add(japFilename);
                                Collection<String> japOptions = CommandLineParser.parseJapManifestForOptions(manifest);
                                argsList.addAll(i + 1, japOptions);
                                japUrl = japFilename + "!";
                                this.programDirectory = new File(japFilename).getParentFile();
                                break;
                            }
                            catch (Throwable throwable) {
                                path = throwable;
                                throw throwable;
                            }
                            finally {
                                if (japFile != null) {
                                    if (path != null) {
                                        try {
                                            japFile.close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)path).addSuppressed(throwable);
                                        }
                                    } else {
                                        japFile.close();
                                    }
                                }
                            }
                        }
                        catch (URISyntaxException | InvalidPathException japFilename) {
                        }
                    }
                    if (olFilepath != null) continue;
                    throw new IOException("Could not locate " + path2);
                }
                olFilepath = path2;
                continue;
            }
            int newIndex = argHandler.onUnrecognizedArgument(argsList, i);
            if (newIndex == i) {
                throw new CommandLineException("Unrecognized command line option: " + argsList.get(i));
            }
            i = newIndex;
        }
        while (i < argsList.size() && olFilepath != null) {
            programArgumentsList.add(argsList.get(i));
            ++i;
        }
        this.typeCheck = bTypeCheck;
        this.logLevel = lLogLevel;
        this.tracerMode = tMode;
        this.tracerLevel = tLevel;
        this.printStackTraces = bStackTraces;
        this.executionTarget = tService;
        this.parametersFilepath = Optional.ofNullable(tParams);
        this.correlationAlgorithmType = CorrelationEngine.Type.fromString((String)csetAlgorithmName);
        if (this.correlationAlgorithmType == null) {
            throw new CommandLineException("Unrecognized correlation algorithm: " + csetAlgorithmName);
        }
        this.arguments = programArgumentsList.toArray(new String[0]);
        if (olFilepath == null) {
            throw new CommandLineException("Input file not specified.");
        }
        this.connectionsLimit = cLimit;
        this.responseTimeout = rTimeout;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String pathInList : libList) {
            String path = pathInList;
            if (path.contains("!/") && !path.startsWith("jap:") && !path.startsWith("jar:")) {
                path = "jap:file:" + path;
            }
            if (path.endsWith(".jar") || path.endsWith(".jap")) {
                if (path.startsWith("jap:")) {
                    urls.add(new URL(path + "!/"));
                    continue;
                }
                urls.add(new URL("jap:file:" + path + "!/"));
                continue;
            }
            if (new File(path).isDirectory()) {
                urls.add(new URL("file:" + path + "/"));
                continue;
            }
            if (path.endsWith("/*")) {
                Path dir = Paths.get(path.substring(0, path.length() - 2), new String[0]);
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                dir = dir.toRealPath(new LinkOption[0]);
                List archives = Files.list(dir).map(Path::toString).filter(p -> p.endsWith(".jar") || p.endsWith(".jap")).collect(Collectors.toList());
                for (String archive : archives) {
                    String scheme = archive.substring(archive.length() - 3);
                    urls.add(new URL(scheme + ":" + Paths.get(archive, new String[0]).toUri().toString() + "!/"));
                }
                continue;
            }
            if (!path.contains(":")) continue;
            try {
                urls.add(new URL(path));
            }
            catch (MalformedURLException dir) {
            }
        }
        urls.add(new URL("file:/"));
        this.libURLs = urls.toArray(new URL[0]);
        this.jolieClassLoader = new JolieClassLoader(this.libURLs, parentClassLoader);
        for (URL url : this.libURLs) {
            if (!url.getProtocol().startsWith("jap")) continue;
            includeList.add(url.toString());
        }
        GetOLStreamResult olResult = this.getOLStream(ignoreFile, olFilepath, includeList, optionsList, (ClassLoader)this.jolieClassLoader);
        if (olResult.stream == null) {
            if (ignoreFile) {
                olResult.source = olFilepath;
                olResult.stream = new ByteArrayInputStream(new byte[0]);
            } else if (olFilepath.endsWith(".ol")) {
                olResult = this.getOLStream(ignoreFile, olFilepath = olFilepath + "c", includeList, optionsList, (ClassLoader)this.jolieClassLoader);
                if (olResult.stream == null) {
                    throw new FileNotFoundException(olFilepath);
                }
            } else {
                throw new FileNotFoundException(olFilepath);
            }
        }
        this.isProgramCompiled = olFilepath.endsWith(".olc");
        this.tracer = bTracer && !this.isProgramCompiled;
        this.check = bCheck && !this.isProgramCompiled;
        this.programFilepath = new File(olResult.source);
        this.programStream = olResult.stream;
        this.includePaths = new LinkedHashSet<String>(includeList).toArray(new String[0]);
        this.packagePaths = new LinkedHashSet(packagesList).toArray(new String[0]);
        this.optionArgs = optionsList.toArray(new String[0]);
    }

    private static String parseJapManifestForMainProgram(Manifest manifest, JarFile japFile) {
        String name;
        String filepath = null;
        if (manifest != null) {
            Attributes attrs = manifest.getMainAttributes();
            filepath = attrs.getValue(Constants.Manifest.MAIN_PROGRAM);
        }
        if (filepath == null && japFile.getEntry(filepath = (name = new File(japFile.getName()).getName()).subSequence(0, name.lastIndexOf(".jap")) + ".ol") == null) {
            filepath = null;
            if (japFile.getEntry(filepath = filepath + 'c') == null) {
                filepath = null;
            }
        }
        if (filepath != null) {
            filepath = "jap:file:" + UriUtils.normalizeWindowsPath((String)japFile.getName()) + "!/" + filepath;
        }
        return filepath;
    }

    private static Collection<String> parseJapManifestForOptions(Manifest manifest) throws IOException {
        Attributes attrs;
        String options;
        ArrayList<String> optionList = new ArrayList<String>();
        if (manifest != null && (options = (attrs = manifest.getMainAttributes()).getValue(Constants.Manifest.OPTIONS)) != null) {
            String[] tmp = options.split(OPTION_SEPARATOR);
            Collections.addAll(optionList, tmp);
        }
        return optionList;
    }

    private GetOLStreamResult getOLStream(boolean ignoreFile, String olFilepath, Deque<String> includePaths, Deque<String> optionsList, ClassLoader classLoader) throws IOException {
        GetOLStreamResult result = new GetOLStreamResult();
        if (ignoreFile) {
            return result;
        }
        URL olURL = null;
        File f = new File(olFilepath).getAbsoluteFile();
        if (f.exists()) {
            result.stream = new FileInputStream(f);
            result.source = f.toURI().getSchemeSpecificPart();
            this.programDirectory = f.getParentFile();
        } else {
            for (String includePath : includePaths) {
                if (includePath.startsWith("jap:")) {
                    try {
                        olURL = new URL(UriUtils.normalizeJolieUri((String)UriUtils.normalizeWindowsPath((String)UriUtils.resolve((String)includePath, (String)olFilepath))));
                        result.stream = olURL.openStream();
                        result.source = olURL.toString();
                        break;
                    }
                    catch (IOException | URISyntaxException exception) {
                        continue;
                    }
                }
                f = new File(includePath + Constants.FILE_SEPARATOR + olFilepath);
                if (!f.exists()) continue;
                f = f.getAbsoluteFile();
                result.stream = new FileInputStream(f);
                result.source = f.toURI().getSchemeSpecificPart();
                this.programDirectory = f.getParentFile();
                break;
            }
            if (result.stream == null) {
                block21: {
                    try {
                        olURL = new URL(olFilepath);
                        result.stream = olURL.openStream();
                        result.source = olFilepath;
                        if (result.stream == null) {
                            throw new MalformedURLException();
                        }
                    }
                    catch (MalformedURLException e) {
                        olURL = classLoader.getResource(olFilepath);
                        if (olURL == null) break block21;
                        result.stream = olURL.openStream();
                        result.source = olURL.toString();
                    }
                }
                if (this.programDirectory == null && olURL != null && olURL.getPath() != null) {
                    try {
                        File urlFile = new File(JapURLConnection.NESTING_SEPARATION_PATTERN.split(new URI(olURL.getPath()).getSchemeSpecificPart())[0]).getAbsoluteFile();
                        if (urlFile.exists()) {
                            this.programDirectory = urlFile.getParentFile();
                        }
                    }
                    catch (URISyntaxException urlFile) {
                        // empty catch block
                    }
                }
            }
        }
        if (result.stream != null) {
            Optional<Object> parent;
            if (f.exists() && f.getParent() != null) {
                parent = Optional.of(f.getParent());
            } else if (olURL != null) {
                String urlString = olURL.toString();
                parent = Optional.of(urlString.substring(0, urlString.lastIndexOf(47) + 1));
            } else {
                parent = Optional.empty();
            }
            if (parent.isPresent()) {
                includePaths.addFirst((String)parent.get());
                optionsList.addFirst((String)parent.get());
                optionsList.addFirst("-l");
            }
            result.stream = new BufferedInputStream(result.stream);
        }
        return result;
    }

    private static Optional<String> findLibPath(String libPath, Deque<String> includePaths, ClassLoader classLoader) {
        if (libPath.endsWith("*")) {
            return CommandLineParser.findLibPath(libPath.substring(0, libPath.length() - 1), includePaths, classLoader).map(p -> p + "*");
        }
        for (String context : CommandLineParser.prepend("", includePaths)) {
            try {
                String path = UriUtils.normalizeJolieUri((String)UriUtils.normalizeWindowsPath((String)UriUtils.resolve((String)context, (String)libPath)));
                if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                    return Optional.of(path);
                }
                URL url = classLoader.getResource(path);
                if (url == null) continue;
                return Optional.of(url.toString());
            }
            catch (URISyntaxException | InvalidPathException exception) {
            }
        }
        return Optional.empty();
    }

    private static <T> List<T> prepend(T element, Collection<T> collection) {
        ArrayList<T> result = new ArrayList<T>(collection.size() + 1);
        result.add(element);
        result.addAll(collection);
        return result;
    }

    public Interpreter.Configuration getInterpreterConfiguration() throws CommandLineException, IOException {
        return Interpreter.Configuration.create((int)this.connectionsLimit, (int)this.cellId, (CorrelationEngine.Type)this.correlationAlgorithmType, (String[])this.includePaths, (String[])this.optionArgs, (URL[])this.libURLs, (InputStream)this.programStream, (String)this.charset, (File)this.programFilepath, (String[])this.arguments, this.constants, (JolieClassLoader)this.jolieClassLoader, (boolean)this.isProgramCompiled, (boolean)this.typeCheck, (boolean)this.tracer, (String)this.tracerLevel, (String)this.tracerMode, (boolean)this.check, (boolean)this.printStackTraces, (long)this.responseTimeout, (Level)this.logLevel, (File)this.programDirectory, (String[])this.packagePaths, (String)this.executionTarget, this.parametersFilepath);
    }

    public static interface ArgumentHandler {
        public static final ArgumentHandler DEFAULT_ARGUMENT_HANDLER = (argumentsList, index) -> {
            throw new CommandLineException("Unrecognized command line option: " + (String)argumentsList.get(index));
        };

        public int onUnrecognizedArgument(List<String> var1, int var2) throws CommandLineException;
    }

    private static class GetOLStreamResult {
        private String source;
        private InputStream stream;

        private GetOLStreamResult() {
        }
    }
}

