/*
 * Decompiled with CFR 0.152.
 */
package jolie;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import jolie.Interpreter;
import jolie.InterpreterException;
import jolie.JolieURLStreamHandlerFactory;
import jolie.cli.CommandLineException;
import jolie.cli.CommandLineParser;
import jolie.js.JsUtils;
import jolie.lang.parse.ParserException;
import jolie.runtime.Value;

public class Jolie {
    private static final long TERMINATION_TIMEOUT = 100L;

    private Jolie() {
    }

    private static void printErr(Throwable t, boolean printStackTraces) {
        String mesg;
        if (printStackTraces) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(bs));
            mesg = bs.toString();
        } else {
            mesg = t.getMessage();
        }
        System.err.println(mesg);
    }

    public static void main(String[] args) {
        int exitCode = 0;
        boolean printStackTraces = Arrays.asList(args).contains("--stackTraces");
        try {
            CommandLineParser commandLineParser = new CommandLineParser(args, Jolie.class.getClassLoader(), false);
            Interpreter.Configuration config = commandLineParser.getInterpreterConfiguration();
            Optional<Value> params = Optional.of(Value.create());
            if (config.parametersPath().isPresent()) {
                Path paramsPath = (Path)config.parametersPath().get();
                try (BufferedReader fileReader = Files.newBufferedReader(paramsPath);){
                    JsUtils.parseJsonIntoValue((Reader)fileReader, (Value)params.get(), (boolean)true);
                }
            }
            Interpreter interpreter = new Interpreter(config, null, params);
            Thread.currentThread().setContextClassLoader((ClassLoader)interpreter.getClassLoader());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> interpreter.exit(100L)));
            interpreter.run();
        }
        catch (CommandLineException cle) {
            Jolie.printErr(cle, printStackTraces);
        }
        catch (FileNotFoundException fe) {
            Jolie.printErr(new FileNotFoundException("File not found " + fe.getMessage()), printStackTraces);
            exitCode = 1;
        }
        catch (IOException ioe) {
            Jolie.printErr(ioe, printStackTraces);
            exitCode = 2;
        }
        catch (InterpreterException ie) {
            if (ie.getCause() instanceof ParserException) {
                Jolie.printErr(ie.getCause(), printStackTraces);
            } else {
                Jolie.printErr(ie, printStackTraces);
            }
            exitCode = 3;
        }
        catch (Exception e) {
            Jolie.printErr(e, printStackTraces);
            exitCode = 4;
        }
        System.exit(exitCode);
    }

    static {
        JolieURLStreamHandlerFactory.registerInVM();
    }
}

