/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.util.List;
import jodd.proxetta.JoddProxetta;
import jodd.proxetta.asm.MethodSignatureVisitor;
import jodd.proxetta.asm.ProxyAspectData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TargetMethodData {
    final MethodSignatureVisitor msign;
    final String methodName;
    final ProxyAspectData[] proxyData;
    int currentIndex;

    TargetMethodData(MethodSignatureVisitor msign, List<ProxyAspectData> aspectList) {
        this.msign = msign;
        this.methodName = msign.getMethodName();
        this.proxyData = aspectList.toArray(new ProxyAspectData[aspectList.size()]);
    }

    void selectCurrentProxy(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    ProxyAspectData getProxyData() {
        return this.proxyData[this.currentIndex];
    }

    private String methodName(int index) {
        return this.methodName + JoddProxetta.methodDivider + this.proxyData[index].aspectIndex;
    }

    String firstMethodName() {
        return this.methodName(0);
    }

    String methodName() {
        return this.methodName(this.currentIndex);
    }

    boolean isLastMethodInChain() {
        return this.currentIndex == this.proxyData.length - 1;
    }

    String nextMethodName() {
        return this.methodName(this.currentIndex + 1);
    }
}

