/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jodd.props.PropsData;
import jodd.util.CharUtil;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropsParser
implements Cloneable {
    protected static final String PROFILE_LEFT = "<";
    protected static final String PROFILE_RIGHT = ">";
    protected final PropsData propsData;
    protected String escapeNewLineValue = "";
    protected boolean valueTrimLeft = true;
    protected boolean valueTrimRight = true;
    protected boolean ignorePrefixWhitespacesOnNewLine = true;
    protected boolean multilineValues = true;
    protected boolean skipEmptyProps = true;

    public PropsParser() {
        this.propsData = new PropsData();
    }

    public PropsParser(PropsData propsData) {
        this.propsData = propsData;
    }

    public PropsData getPropsData() {
        return this.propsData;
    }

    public PropsParser clone() {
        PropsParser pp = new PropsParser(this.propsData.clone());
        pp.escapeNewLineValue = this.escapeNewLineValue;
        pp.valueTrimLeft = this.valueTrimLeft;
        pp.valueTrimRight = this.valueTrimRight;
        pp.ignorePrefixWhitespacesOnNewLine = this.ignorePrefixWhitespacesOnNewLine;
        pp.skipEmptyProps = this.skipEmptyProps;
        pp.multilineValues = this.multilineValues;
        return pp;
    }

    public void parse(String in) {
        ParseState state = ParseState.TEXT;
        ParseState stateOnEscape = null;
        boolean insideSection = false;
        String currentSection = null;
        String key = null;
        Operator operator = Operator.ASSIGN;
        StringBuilder sb = new StringBuilder();
        int len = in.length();
        int ndx = 0;
        block24: while (ndx < len) {
            char c = in.charAt(ndx);
            ++ndx;
            if (state == ParseState.COMMENT) {
                if (c != '\n') continue;
                state = ParseState.TEXT;
                continue;
            }
            if (state == ParseState.ESCAPE) {
                state = stateOnEscape;
                switch (c) {
                    case '\n': 
                    case '\r': {
                        state = ParseState.ESCAPE_NEWLINE;
                        continue block24;
                    }
                    case 'u': {
                        int value = 0;
                        for (int i = 0; i < 4; ++i) {
                            char hexChar;
                            if (CharUtil.isDigit((char)(hexChar = in.charAt(ndx++)))) {
                                value = (value << 4) + hexChar - 48;
                                continue;
                            }
                            if (hexChar >= 'a' && hexChar <= 'f') {
                                value = (value << 4) + 10 + hexChar - 97;
                                continue;
                            }
                            if (hexChar >= 'A' && hexChar <= 'F') {
                                value = (value << 4) + 10 + hexChar - 65;
                                continue;
                            }
                            throw new IllegalArgumentException("Malformed \\uXXXX encoding.");
                        }
                        sb.append((char)value);
                        continue block24;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block24;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block24;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block24;
                    }
                    case 'f': {
                        sb.append('\f');
                        continue block24;
                    }
                }
                sb.append(c);
                continue;
            }
            if (state == ParseState.TEXT) {
                switch (c) {
                    case '\\': {
                        stateOnEscape = state;
                        state = ParseState.ESCAPE;
                        continue block24;
                    }
                    case '[': {
                        sb.setLength(0);
                        insideSection = true;
                        continue block24;
                    }
                    case ']': {
                        if (insideSection) {
                            currentSection = sb.toString().trim();
                            sb.setLength(0);
                            insideSection = false;
                            if (currentSection.length() != 0) continue block24;
                            currentSection = null;
                            continue block24;
                        }
                        sb.append(c);
                        continue block24;
                    }
                    case '#': 
                    case ';': {
                        state = ParseState.COMMENT;
                        continue block24;
                    }
                    case '<': {
                        if (ndx == len || in.charAt(ndx) != '=') {
                            sb.append(c);
                            continue block24;
                        }
                        operator = Operator.COPY;
                        continue block24;
                    }
                    case '+': {
                        if (ndx == len || in.charAt(ndx) != '=') {
                            sb.append(c);
                            continue block24;
                        }
                        operator = Operator.QUICK_APPEND;
                        continue block24;
                    }
                    case ':': 
                    case '=': {
                        if (key == null) {
                            key = sb.toString().trim();
                            sb.setLength(0);
                        } else {
                            sb.append(c);
                        }
                        state = ParseState.VALUE;
                        continue block24;
                    }
                    case '\n': 
                    case '\r': {
                        this.add(currentSection, key, sb, true, operator);
                        sb.setLength(0);
                        key = null;
                        operator = Operator.ASSIGN;
                        continue block24;
                    }
                    case '\t': 
                    case ' ': {
                        continue block24;
                    }
                }
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    stateOnEscape = state;
                    state = ParseState.ESCAPE;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (state == ParseState.ESCAPE_NEWLINE && c == '\n') {
                        sb.append(this.escapeNewLineValue);
                        if (this.ignorePrefixWhitespacesOnNewLine) continue block24;
                        state = ParseState.VALUE;
                        break;
                    }
                    this.add(currentSection, key, sb, true, operator);
                    sb.setLength(0);
                    key = null;
                    operator = Operator.ASSIGN;
                    state = ParseState.TEXT;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (state == ParseState.ESCAPE_NEWLINE) break;
                }
                default: {
                    sb.append(c);
                    state = ParseState.VALUE;
                    if (!this.multilineValues || sb.length() != 3 || !sb.toString().equals("'''")) continue block24;
                    sb.setLength(0);
                    int endIndex = in.indexOf("'''", ndx);
                    if (endIndex == -1) {
                        endIndex = in.length();
                    }
                    sb.append(in, ndx, endIndex);
                    this.add(currentSection, key, sb, false, operator);
                    sb.setLength(0);
                    key = null;
                    operator = Operator.ASSIGN;
                    state = ParseState.TEXT;
                    ndx = endIndex + 3;
                }
            }
        }
        if (key != null) {
            this.add(currentSection, key, sb, true, operator);
        }
    }

    protected void add(String section, String key, StringBuilder value, boolean trim, Operator operator) {
        if (key == null) {
            return;
        }
        String fullKey = key;
        if (section != null) {
            fullKey = fullKey.length() != 0 ? section + '.' + fullKey : section;
        }
        String v = value.toString();
        if (trim) {
            v = this.valueTrimLeft && this.valueTrimRight ? v.trim() : (this.valueTrimLeft ? StringUtil.trimLeft((String)v) : StringUtil.trimRight((String)v));
        }
        if (v.length() == 0 && this.skipEmptyProps) {
            return;
        }
        this.extractProfilesAndAdd(fullKey, v, operator);
    }

    protected void extractProfilesAndAdd(String key, String value, Operator operator) {
        String fullKey = key;
        int ndx = fullKey.indexOf(PROFILE_LEFT);
        if (ndx == -1) {
            this.justAdd(fullKey, value, null, operator);
            return;
        }
        ArrayList<String> keyProfiles = new ArrayList<String>();
        while ((ndx = fullKey.indexOf(PROFILE_LEFT)) != -1) {
            int len = fullKey.length();
            int ndx2 = fullKey.indexOf(PROFILE_RIGHT, ndx + 1);
            if (ndx2 == -1) {
                ndx2 = len;
            }
            String profile = fullKey.substring(ndx + 1, ndx2);
            keyProfiles.add(profile);
            String right = ++ndx2 == len ? "" : fullKey.substring(ndx2);
            fullKey = fullKey.substring(0, ndx) + right;
        }
        if (fullKey.startsWith(".")) {
            fullKey = fullKey.substring(1);
        }
        this.justAdd(fullKey, value, keyProfiles, operator);
    }

    protected void justAdd(String key, String value, ArrayList<String> keyProfiles, Operator operator) {
        boolean append;
        if (operator == Operator.COPY) {
            String[] sources;
            HashMap target = new HashMap();
            String[] profiles = null;
            if (keyProfiles != null) {
                profiles = keyProfiles.toArray(new String[keyProfiles.size()]);
            }
            for (String source : sources = StringUtil.splitc((String)value, (char)',')) {
                source = source.trim();
                String[] lookupProfiles = profiles;
                String lookupProfilesString = null;
                int leftIndex = source.indexOf(60);
                if (leftIndex != -1) {
                    int rightIndex = source.indexOf(62);
                    lookupProfilesString = source.substring(leftIndex + 1, rightIndex);
                    source = source.substring(0, leftIndex).concat(source.substring(rightIndex + 1));
                    lookupProfiles = StringUtil.splitc((String)lookupProfilesString, (char)',');
                    StringUtil.trimAll((String[])lookupProfiles);
                }
                String[] wildcards = new String[]{source + ".*"};
                this.propsData.extract(target, lookupProfiles, wildcards);
                for (Map.Entry entry : target.entrySet()) {
                    String entryKey = (String)entry.getKey();
                    String suffix = entryKey.substring(source.length());
                    String newKey = key + suffix;
                    String newValue = "${" + entryKey;
                    if (lookupProfilesString != null) {
                        newValue = newValue + PROFILE_LEFT + lookupProfilesString + PROFILE_RIGHT;
                    }
                    newValue = newValue + "}";
                    if (profiles == null) {
                        this.propsData.putBaseProperty(newKey, newValue, false);
                        continue;
                    }
                    for (String p : profiles) {
                        this.propsData.putProfileProperty(newKey, newValue, p, false);
                    }
                }
            }
            return;
        }
        boolean bl = append = operator == Operator.QUICK_APPEND;
        if (keyProfiles == null) {
            this.propsData.putBaseProperty(key, value, append);
            return;
        }
        for (String p : keyProfiles) {
            this.propsData.putProfileProperty(key, value, p, append);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Operator {
        ASSIGN,
        QUICK_APPEND,
        COPY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ParseState {
        TEXT,
        ESCAPE,
        ESCAPE_NEWLINE,
        COMMENT,
        VALUE;

    }
}

