/*
 * Decompiled with CFR 0.152.
 */
package jodd.decora.parser;

import java.util.ArrayList;
import jodd.decora.DecoraException;
import jodd.decora.parser.DecoraTag;
import jodd.lagarto.EmptyTagVisitor;
import jodd.lagarto.Tag;
import jodd.lagarto.TagType;

public class DecoratorTagVisitor
extends EmptyTagVisitor {
    protected ArrayList<DecoraTag> decoraTags = new ArrayList();
    protected String decoraTagName;
    protected String decoraIdName;
    protected int decoraTagStart;
    protected int decoraTagEnd;
    protected int decoraTagDefaultValueStart;
    protected int decoraTagDefaultValueEnd;
    protected String closingTagName;
    protected int closingTagDeepLevel;

    public DecoraTag[] getDecoraTags() {
        return this.decoraTags.toArray(new DecoraTag[this.decoraTags.size()]);
    }

    public void tag(Tag tag) {
        String tagName = tag.getName();
        if (tagName.startsWith("decora:")) {
            this.onDecoraTag(tag);
            return;
        }
        if (tag.getType().isStartingTag()) {
            String id = tag.getId();
            if (id != null && id.startsWith("decora-")) {
                this.onIdAttrStart(tag);
            }
        } else if (tagName.equals(this.closingTagName) && this.closingTagDeepLevel == tag.getDeepLevel()) {
            this.onIdAttrEnd(tag);
        }
    }

    protected void onDecoraTag(Tag tag) {
        String tagName = tag.getName();
        if (tag.getType() == TagType.SELF_CLOSING) {
            this.checkNestedDecoraTags();
            this.decoraTagName = tagName.substring(7);
            this.decoraTagStart = tag.getTagPosition();
            this.decoraTagEnd = tag.getTagPosition() + tag.getTagLength();
            this.defineDecoraTag();
            return;
        }
        if (tag.getType() == TagType.START) {
            this.checkNestedDecoraTags();
            this.decoraTagName = tagName.substring(7);
            this.decoraTagStart = tag.getTagPosition();
            this.decoraTagDefaultValueStart = tag.getTagPosition() + tag.getTagLength();
            return;
        }
        this.decoraTagEnd = tag.getTagPosition() + tag.getTagLength();
        this.decoraTagDefaultValueEnd = tag.getTagPosition();
        this.defineDecoraTag();
    }

    protected void onIdAttrStart(Tag tag) {
        String idName;
        String tagName;
        String id = tag.getId().substring(7);
        int dashIndex = id.indexOf(45);
        if (dashIndex == -1) {
            tagName = id;
            idName = null;
        } else {
            tagName = id.substring(0, dashIndex);
            idName = id.substring(dashIndex + 1);
        }
        if (tag.getType() == TagType.SELF_CLOSING) {
            this.checkNestedDecoraTags();
            this.decoraTagName = tagName;
            this.decoraIdName = idName;
            this.decoraTagStart = tag.getTagPosition();
            this.decoraTagEnd = tag.getTagPosition() + tag.getTagLength();
            this.defineDecoraTag();
            return;
        }
        if (tag.getType() == TagType.START) {
            this.checkNestedDecoraTags();
            this.decoraTagName = tagName;
            this.decoraIdName = idName;
            this.decoraTagStart = tag.getTagPosition();
            this.decoraTagDefaultValueStart = tag.getTagPosition() + tag.getTagLength();
            this.closingTagName = tag.getName();
            this.closingTagDeepLevel = tag.getDeepLevel();
        }
    }

    protected void onIdAttrEnd(Tag tag) {
        this.decoraTagEnd = tag.getTagPosition() + tag.getTagLength();
        this.decoraTagDefaultValueEnd = tag.getTagPosition();
        this.defineDecoraTag();
    }

    protected void defineDecoraTag() {
        DecoraTag decoraTag = this.decoraTagDefaultValueStart == 0 ? new DecoraTag(this.decoraTagName, this.decoraIdName, this.decoraTagStart, this.decoraTagEnd) : new DecoraTag(this.decoraTagName, this.decoraIdName, this.decoraTagStart, this.decoraTagEnd, this.decoraTagDefaultValueStart, this.decoraTagDefaultValueEnd - this.decoraTagDefaultValueStart);
        this.decoraTags.add(decoraTag);
        this.decoraTagName = null;
        this.decoraIdName = null;
        this.closingTagName = null;
        this.decoraTagDefaultValueStart = 0;
    }

    protected void checkNestedDecoraTags() {
        if (this.decoraTagName != null) {
            throw new DecoraException("Nested Decora tags not allowed");
        }
    }
}

