/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.jtx;

import jodd.db.DbSession;
import jodd.db.connection.ConnectionProvider;
import jodd.db.jtx.JtxDbUtil;
import jodd.jtx.JtxException;
import jodd.jtx.JtxResourceManager;
import jodd.jtx.JtxTransactionMode;
import jodd.log.Logger;
import jodd.log.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbJtxResourceManager
implements JtxResourceManager<DbSession> {
    private static final Logger log = LoggerFactory.getLogger(DbJtxResourceManager.class);
    protected final ConnectionProvider connectionProvider;

    public DbJtxResourceManager(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public Class<DbSession> getResourceType() {
        return DbSession.class;
    }

    public DbSession beginTransaction(JtxTransactionMode jtxMode, boolean active) {
        DbSession session = new DbSession(this.connectionProvider);
        if (active) {
            log.debug("begin jtx");
            session.beginTransaction(JtxDbUtil.convertToDbMode(jtxMode));
        }
        return session;
    }

    public void commitTransaction(DbSession resource) {
        if (resource.isTransactionActive()) {
            log.debug("commit jtx");
            resource.commitTransaction();
        }
        resource.closeSession();
    }

    public void rollbackTransaction(DbSession resource) {
        try {
            if (resource.isTransactionActive()) {
                log.debug("rollback tx");
                resource.rollbackTransaction();
            }
        }
        catch (Exception ex) {
            throw new JtxException((Throwable)ex);
        }
        finally {
            resource.closeSession();
        }
    }

    public void close() {
        this.connectionProvider.close();
    }
}

