/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jodd.db.DbSqlException;
import jodd.db.type.NullAwareSqlType;
import jodd.db.type.TypesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterSqlType
extends NullAwareSqlType<Character> {
    @Override
    public Character get(ResultSet rs, int index, int dbSqlType) throws SQLException {
        if (TypesUtil.isIntegerType(dbSqlType)) {
            return Character.valueOf((char)rs.getInt(index));
        }
        String s = rs.getString(index);
        if (s == null) {
            return null;
        }
        if (s.length() > 1) {
            throw new DbSqlException("Char column size too long, should be 1");
        }
        return Character.valueOf(s.charAt(0));
    }

    @Override
    public void set(PreparedStatement st, int index, Character value, int dbSqlType) throws SQLException {
        if (TypesUtil.isIntegerType(dbSqlType)) {
            st.setInt(index, value.charValue());
            return;
        }
        st.setString(index, value.toString());
    }
}

