/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.objects.infos;

import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RigidBodyMotionState {
    long motionStateId = 0L;
    private Vector3f worldLocation = new Vector3f();
    private Matrix3f worldRotation = new Matrix3f();
    private Quaternion worldRotationQuat = new Quaternion();
    private Quaternion tmp_inverseWorldRotation = new Quaternion();
    private PhysicsVehicle vehicle;
    private boolean applyPhysicsLocal = false;

    public RigidBodyMotionState() {
        this.motionStateId = this.createMotionState();
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created MotionState {0}", Long.toHexString(this.motionStateId));
    }

    private native long createMotionState();

    public boolean applyTransform(Spatial spatial) {
        Quaternion localRotationQuat;
        Vector3f localLocation = spatial.getLocalTranslation();
        boolean physicsLocationDirty = this.applyTransform(this.motionStateId, localLocation, localRotationQuat = spatial.getLocalRotation());
        if (!physicsLocationDirty) {
            return false;
        }
        if (!this.applyPhysicsLocal && spatial.getParent() != null) {
            localLocation.subtractLocal(spatial.getParent().getWorldTranslation());
            localLocation.divideLocal(spatial.getParent().getWorldScale());
            this.tmp_inverseWorldRotation.set(spatial.getParent().getWorldRotation()).inverseLocal().multLocal(localLocation);
            this.tmp_inverseWorldRotation.mult(localRotationQuat, localRotationQuat);
            spatial.setLocalTranslation(localLocation);
            spatial.setLocalRotation(localRotationQuat);
        } else {
            spatial.setLocalTranslation(localLocation);
            spatial.setLocalRotation(localRotationQuat);
        }
        if (this.vehicle != null) {
            this.vehicle.updateWheels();
        }
        return true;
    }

    private native boolean applyTransform(long var1, Vector3f var3, Quaternion var4);

    public Vector3f getWorldLocation() {
        this.getWorldLocation(this.motionStateId, this.worldLocation);
        return this.worldLocation;
    }

    private native void getWorldLocation(long var1, Vector3f var3);

    public Matrix3f getWorldRotation() {
        this.getWorldRotation(this.motionStateId, this.worldRotation);
        return this.worldRotation;
    }

    private native void getWorldRotation(long var1, Matrix3f var3);

    public Quaternion getWorldRotationQuat() {
        this.getWorldRotationQuat(this.motionStateId, this.worldRotationQuat);
        return this.worldRotationQuat;
    }

    private native void getWorldRotationQuat(long var1, Quaternion var3);

    public void setVehicle(PhysicsVehicle vehicle) {
        this.vehicle = vehicle;
    }

    public boolean isApplyPhysicsLocal() {
        return this.applyPhysicsLocal;
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.applyPhysicsLocal = applyPhysicsLocal;
    }

    public long getObjectId() {
        return this.motionStateId;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Finalizing MotionState {0}", Long.toHexString(this.motionStateId));
        this.finalizeNative(this.motionStateId);
    }

    private native void finalizeNative(long var1);
}

