/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.joints.motors.RotationalLimitMotor;
import com.jme3.bullet.joints.motors.TranslationalLimitMotor;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SixDofJoint
extends PhysicsJoint {
    Matrix3f rotA;
    Matrix3f rotB;
    boolean useLinearReferenceFrameA;
    LinkedList<RotationalLimitMotor> rotationalMotors = new LinkedList();
    TranslationalLimitMotor translationalMotor;
    Vector3f angularUpperLimit = new Vector3f(Vector3f.POSITIVE_INFINITY);
    Vector3f angularLowerLimit = new Vector3f(Vector3f.NEGATIVE_INFINITY);
    Vector3f linearUpperLimit = new Vector3f(Vector3f.POSITIVE_INFINITY);
    Vector3f linearLowerLimit = new Vector3f(Vector3f.NEGATIVE_INFINITY);

    protected SixDofJoint() {
    }

    public SixDofJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB, Matrix3f rotA, Matrix3f rotB, boolean useLinearReferenceFrameA) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.rotA = rotA;
        this.rotB = rotB;
        this.objectId = this.createJoint(nodeA.getObjectId(), nodeB.getObjectId(), pivotA, rotA, pivotB, rotB, useLinearReferenceFrameA);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Joint {0}", Long.toHexString(this.objectId));
        this.gatherMotors();
    }

    public SixDofJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB, boolean useLinearReferenceFrameA) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.useLinearReferenceFrameA = useLinearReferenceFrameA;
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.objectId = this.createJoint(nodeA.getObjectId(), nodeB.getObjectId(), pivotA, this.rotA, pivotB, this.rotB, useLinearReferenceFrameA);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Joint {0}", Long.toHexString(this.objectId));
        this.gatherMotors();
    }

    private void gatherMotors() {
        for (int i = 0; i < 3; ++i) {
            RotationalLimitMotor rmot = new RotationalLimitMotor(this.getRotationalLimitMotor(this.objectId, i));
            this.rotationalMotors.add(rmot);
        }
        this.translationalMotor = new TranslationalLimitMotor(this.getTranslationalLimitMotor(this.objectId));
    }

    private native void getAngles(long var1, Vector3f var3);

    public Vector3f getAngles(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        long constraintId = this.getObjectId();
        this.getAngles(constraintId, result);
        return result;
    }

    private native long getRotationalLimitMotor(long var1, int var3);

    private native long getTranslationalLimitMotor(long var1);

    public TranslationalLimitMotor getTranslationalLimitMotor() {
        return this.translationalMotor;
    }

    public RotationalLimitMotor getRotationalLimitMotor(int index) {
        return this.rotationalMotors.get(index);
    }

    public void setLinearUpperLimit(Vector3f vector) {
        this.linearUpperLimit.set(vector);
        this.setLinearUpperLimit(this.objectId, vector);
    }

    private native void setLinearUpperLimit(long var1, Vector3f var3);

    public void setLinearLowerLimit(Vector3f vector) {
        this.linearLowerLimit.set(vector);
        this.setLinearLowerLimit(this.objectId, vector);
    }

    private native void setLinearLowerLimit(long var1, Vector3f var3);

    public void setAngularUpperLimit(Vector3f vector) {
        this.angularUpperLimit.set(vector);
        this.setAngularUpperLimit(this.objectId, vector);
    }

    private native void setAngularUpperLimit(long var1, Vector3f var3);

    public void setAngularLowerLimit(Vector3f vector) {
        this.angularLowerLimit.set(vector);
        this.setAngularLowerLimit(this.objectId, vector);
    }

    private native void setAngularLowerLimit(long var1, Vector3f var3);

    native long createJoint(long var1, long var3, Vector3f var5, Matrix3f var6, Vector3f var7, Matrix3f var8, boolean var9);

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.objectId = this.createJoint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), this.pivotA, this.rotA, this.pivotB, this.rotB, this.useLinearReferenceFrameA);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Joint {0}", Long.toHexString(this.objectId));
        this.gatherMotors();
        this.setAngularUpperLimit((Vector3f)capsule.readSavable("angularUpperLimit", (Savable)new Vector3f(Vector3f.POSITIVE_INFINITY)));
        this.setAngularLowerLimit((Vector3f)capsule.readSavable("angularLowerLimit", (Savable)new Vector3f(Vector3f.NEGATIVE_INFINITY)));
        this.setLinearUpperLimit((Vector3f)capsule.readSavable("linearUpperLimit", (Savable)new Vector3f(Vector3f.POSITIVE_INFINITY)));
        this.setLinearLowerLimit((Vector3f)capsule.readSavable("linearLowerLimit", (Savable)new Vector3f(Vector3f.NEGATIVE_INFINITY)));
        for (int i = 0; i < 3; ++i) {
            RotationalLimitMotor rotationalLimitMotor = this.getRotationalLimitMotor(i);
            rotationalLimitMotor.setBounce(capsule.readFloat("rotMotor" + i + "_Bounce", 0.0f));
            rotationalLimitMotor.setDamping(capsule.readFloat("rotMotor" + i + "_Damping", 1.0f));
            rotationalLimitMotor.setERP(capsule.readFloat("rotMotor" + i + "_ERP", 0.5f));
            rotationalLimitMotor.setHiLimit(capsule.readFloat("rotMotor" + i + "_HiLimit", Float.POSITIVE_INFINITY));
            rotationalLimitMotor.setLimitSoftness(capsule.readFloat("rotMotor" + i + "_LimitSoftness", 0.5f));
            rotationalLimitMotor.setLoLimit(capsule.readFloat("rotMotor" + i + "_LoLimit", Float.NEGATIVE_INFINITY));
            rotationalLimitMotor.setMaxLimitForce(capsule.readFloat("rotMotor" + i + "_MaxLimitForce", 300.0f));
            rotationalLimitMotor.setMaxMotorForce(capsule.readFloat("rotMotor" + i + "_MaxMotorForce", 0.1f));
            rotationalLimitMotor.setTargetVelocity(capsule.readFloat("rotMotor" + i + "_TargetVelocity", 0.0f));
            rotationalLimitMotor.setEnableMotor(capsule.readBoolean("rotMotor" + i + "_EnableMotor", false));
        }
        this.getTranslationalLimitMotor().setAccumulatedImpulse((Vector3f)capsule.readSavable("transMotor_AccumulatedImpulse", (Savable)Vector3f.ZERO));
        this.getTranslationalLimitMotor().setDamping(capsule.readFloat("transMotor_Damping", 1.0f));
        this.getTranslationalLimitMotor().setLimitSoftness(capsule.readFloat("transMotor_LimitSoftness", 0.7f));
        this.getTranslationalLimitMotor().setLowerLimit((Vector3f)capsule.readSavable("transMotor_LowerLimit", (Savable)Vector3f.ZERO));
        this.getTranslationalLimitMotor().setRestitution(capsule.readFloat("transMotor_Restitution", 0.5f));
        this.getTranslationalLimitMotor().setUpperLimit((Vector3f)capsule.readSavable("transMotor_UpperLimit", (Savable)Vector3f.ZERO));
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            this.translationalMotor.setEnabled(axisIndex, capsule.readBoolean("transMotor_Enable" + axisIndex, false));
        }
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.angularUpperLimit, "angularUpperLimit", (Savable)new Vector3f(Vector3f.POSITIVE_INFINITY));
        capsule.write((Savable)this.angularLowerLimit, "angularLowerLimit", (Savable)new Vector3f(Vector3f.NEGATIVE_INFINITY));
        capsule.write((Savable)this.linearUpperLimit, "linearUpperLimit", (Savable)new Vector3f(Vector3f.POSITIVE_INFINITY));
        capsule.write((Savable)this.linearLowerLimit, "linearLowerLimit", (Savable)new Vector3f(Vector3f.NEGATIVE_INFINITY));
        int i = 0;
        for (RotationalLimitMotor rotationalLimitMotor : this.rotationalMotors) {
            capsule.write(rotationalLimitMotor.getBounce(), "rotMotor" + i + "_Bounce", 0.0f);
            capsule.write(rotationalLimitMotor.getDamping(), "rotMotor" + i + "_Damping", 1.0f);
            capsule.write(rotationalLimitMotor.getERP(), "rotMotor" + i + "_ERP", 0.5f);
            capsule.write(rotationalLimitMotor.getHiLimit(), "rotMotor" + i + "_HiLimit", Float.POSITIVE_INFINITY);
            capsule.write(rotationalLimitMotor.getLimitSoftness(), "rotMotor" + i + "_LimitSoftness", 0.5f);
            capsule.write(rotationalLimitMotor.getLoLimit(), "rotMotor" + i + "_LoLimit", Float.NEGATIVE_INFINITY);
            capsule.write(rotationalLimitMotor.getMaxLimitForce(), "rotMotor" + i + "_MaxLimitForce", 300.0f);
            capsule.write(rotationalLimitMotor.getMaxMotorForce(), "rotMotor" + i + "_MaxMotorForce", 0.1f);
            capsule.write(rotationalLimitMotor.getTargetVelocity(), "rotMotor" + i + "_TargetVelocity", 0.0f);
            capsule.write(rotationalLimitMotor.isEnableMotor(), "rotMotor" + i + "_EnableMotor", false);
            ++i;
        }
        capsule.write((Savable)this.getTranslationalLimitMotor().getAccumulatedImpulse(), "transMotor_AccumulatedImpulse", (Savable)Vector3f.ZERO);
        capsule.write(this.getTranslationalLimitMotor().getDamping(), "transMotor_Damping", 1.0f);
        capsule.write(this.getTranslationalLimitMotor().getLimitSoftness(), "transMotor_LimitSoftness", 0.7f);
        capsule.write((Savable)this.getTranslationalLimitMotor().getLowerLimit(), "transMotor_LowerLimit", (Savable)Vector3f.ZERO);
        capsule.write(this.getTranslationalLimitMotor().getRestitution(), "transMotor_Restitution", 0.5f);
        capsule.write((Savable)this.getTranslationalLimitMotor().getUpperLimit(), "transMotor_UpperLimit", (Savable)Vector3f.ZERO);
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            capsule.write(this.translationalMotor.isEnabled(axisIndex), "transMotor_Enable" + axisIndex, false);
        }
    }
}

