/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConeJoint
extends PhysicsJoint {
    protected Matrix3f rotA;
    protected Matrix3f rotB;
    protected float swingSpan1 = 1.0E30f;
    protected float swingSpan2 = 1.0E30f;
    protected float twistSpan = 1.0E30f;
    protected boolean angularOnly = false;

    protected ConeJoint() {
    }

    public ConeJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.rotA = new Matrix3f();
        this.rotB = new Matrix3f();
        this.createJoint();
    }

    public ConeJoint(PhysicsRigidBody nodeA, PhysicsRigidBody nodeB, Vector3f pivotA, Vector3f pivotB, Matrix3f rotA, Matrix3f rotB) {
        super(nodeA, nodeB, pivotA, pivotB);
        this.rotA = rotA;
        this.rotB = rotB;
        this.createJoint();
    }

    public void setLimit(float swingSpan1, float swingSpan2, float twistSpan) {
        this.swingSpan1 = swingSpan1;
        this.swingSpan2 = swingSpan2;
        this.twistSpan = twistSpan;
        this.setLimit(this.objectId, swingSpan1, swingSpan2, twistSpan);
    }

    private native void setLimit(long var1, float var3, float var4, float var5);

    public void setAngularOnly(boolean value) {
        this.angularOnly = value;
        this.setAngularOnly(this.objectId, value);
    }

    private native void setAngularOnly(long var1, boolean var3);

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.rotA, "rotA", (Savable)new Matrix3f());
        capsule.write((Savable)this.rotB, "rotB", (Savable)new Matrix3f());
        capsule.write(this.angularOnly, "angularOnly", false);
        capsule.write(this.swingSpan1, "swingSpan1", 1.0E30f);
        capsule.write(this.swingSpan2, "swingSpan2", 1.0E30f);
        capsule.write(this.twistSpan, "twistSpan", 1.0E30f);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.rotA = (Matrix3f)capsule.readSavable("rotA", (Savable)new Matrix3f());
        this.rotB = (Matrix3f)capsule.readSavable("rotB", (Savable)new Matrix3f());
        this.angularOnly = capsule.readBoolean("angularOnly", false);
        this.swingSpan1 = capsule.readFloat("swingSpan1", 1.0E30f);
        this.swingSpan2 = capsule.readFloat("swingSpan2", 1.0E30f);
        this.twistSpan = capsule.readFloat("twistSpan", 1.0E30f);
        this.createJoint();
    }

    protected void createJoint() {
        this.objectId = this.createJoint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), this.pivotA, this.rotA, this.pivotB, this.rotB);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Joint {0}", Long.toHexString(this.objectId));
        this.setLimit(this.objectId, this.swingSpan1, this.swingSpan2, this.twistSpan);
        this.setAngularOnly(this.objectId, this.angularOnly);
    }

    private native long createJoint(long var1, long var3, Vector3f var5, Matrix3f var6, Vector3f var7, Matrix3f var8);
}

