/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.bullet.objects.VehicleWheel;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;

public class VehicleControl
extends PhysicsVehicle
implements PhysicsControl,
JmeCloneable {
    protected Spatial spatial;
    protected boolean enabled = true;
    protected PhysicsSpace space = null;
    protected boolean added = false;

    protected VehicleControl() {
    }

    public VehicleControl(CollisionShape shape) {
        super(shape);
    }

    public VehicleControl(CollisionShape shape, float mass) {
        super(shape, mass);
    }

    public boolean isApplyPhysicsLocal() {
        return this.motionState.isApplyPhysicsLocal();
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.motionState.setApplyPhysicsLocal(applyPhysicsLocal);
        for (VehicleWheel vehicleWheel : this.wheels) {
            vehicleWheel.setApplyLocal(applyPhysicsLocal);
        }
    }

    private Vector3f getSpatialTranslation() {
        if (this.motionState.isApplyPhysicsLocal()) {
            return this.spatial.getLocalTranslation();
        }
        return this.spatial.getWorldTranslation();
    }

    private Quaternion getSpatialRotation() {
        if (this.motionState.isApplyPhysicsLocal()) {
            return this.spatial.getLocalRotation();
        }
        return this.spatial.getWorldRotation();
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException();
    }

    public Object jmeClone() {
        VehicleControl control = new VehicleControl(this.collisionShape, this.mass);
        control.setAngularFactor(this.getAngularFactor());
        control.setAngularSleepingThreshold(this.getAngularSleepingThreshold());
        control.setAngularVelocity(this.getAngularVelocity());
        control.setCcdMotionThreshold(this.getCcdMotionThreshold());
        control.setCcdSweptSphereRadius(this.getCcdSweptSphereRadius());
        control.setCollideWithGroups(this.getCollideWithGroups());
        control.setCollisionGroup(this.getCollisionGroup());
        control.setContactResponse(this.isContactResponse());
        control.setDamping(this.getLinearDamping(), this.getAngularDamping());
        control.setFriction(this.getFriction());
        control.setGravity(this.getGravity());
        control.setKinematic(this.isKinematic());
        control.setLinearSleepingThreshold(this.getLinearSleepingThreshold());
        control.setLinearVelocity(this.getLinearVelocity());
        control.setPhysicsLocation(this.getPhysicsLocation());
        control.setPhysicsRotation(this.getPhysicsRotationMatrix());
        control.setRestitution(this.getRestitution());
        control.setFrictionSlip(this.getFrictionSlip());
        control.setMaxSuspensionTravelCm(this.getMaxSuspensionTravelCm());
        control.setSuspensionStiffness(this.getSuspensionStiffness());
        control.setSuspensionCompression(this.tuning.suspensionCompression);
        control.setSuspensionDamping(this.tuning.suspensionDamping);
        control.setMaxSuspensionForce(this.getMaxSuspensionForce());
        for (VehicleWheel wheel : this.wheels) {
            VehicleWheel newWheel = control.addWheel(wheel.getLocation(), wheel.getDirection(), wheel.getAxle(), wheel.getRestLength(), wheel.getRadius(), wheel.isFrontWheel());
            newWheel.setFrictionSlip(wheel.getFrictionSlip());
            newWheel.setMaxSuspensionTravelCm(wheel.getMaxSuspensionTravelCm());
            newWheel.setSuspensionStiffness(wheel.getSuspensionStiffness());
            newWheel.setWheelsDampingCompression(wheel.getWheelsDampingCompression());
            newWheel.setWheelsDampingRelaxation(wheel.getWheelsDampingRelaxation());
            newWheel.setMaxSuspensionForce(wheel.getMaxSuspensionForce());
            newWheel.setWheelSpatial(wheel.getWheelSpatial());
        }
        control.setApplyPhysicsLocal(this.isApplyPhysicsLocal());
        control.setEnabled(this.isEnabled());
        control.spatial = this.spatial;
        return control;
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.spatial = (Spatial)cloner.clone((Object)this.spatial);
        for (VehicleWheel wheel : this.wheels) {
            Spatial spatial = (Spatial)cloner.clone((Object)wheel.getWheelSpatial());
            wheel.setWheelSpatial(spatial);
        }
    }

    public void setSpatial(Spatial spatial) {
        this.spatial = spatial;
        this.setUserObject(spatial);
        if (spatial == null) {
            return;
        }
        this.setPhysicsLocation(this.getSpatialTranslation());
        this.setPhysicsRotation(this.getSpatialRotation());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.space != null) {
            if (enabled && !this.added) {
                if (this.spatial != null) {
                    this.setPhysicsLocation(this.getSpatialTranslation());
                    this.setPhysicsRotation(this.getSpatialRotation());
                }
                this.space.addCollisionObject(this);
                this.added = true;
            } else if (!enabled && this.added) {
                this.space.removeCollisionObject(this);
                this.added = false;
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void update(float tpf) {
        if (this.enabled && this.spatial != null) {
            if (this.getMotionState().applyTransform(this.spatial)) {
                this.spatial.getWorldTransform();
                this.applyWheelTransforms();
            }
        } else if (this.enabled) {
            this.applyWheelTransforms();
        }
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace newSpace) {
        if (this.space == newSpace) {
            return;
        }
        if (this.added) {
            this.space.removeCollisionObject(this);
            this.added = false;
        }
        if (newSpace != null && this.isEnabled()) {
            newSpace.addCollisionObject(this);
            this.added = true;
        }
        this.space = newSpace;
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.enabled, "enabled", true);
        oc.write(this.motionState.isApplyPhysicsLocal(), "applyLocalPhysics", false);
        oc.write((Savable)this.spatial, "spatial", null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule((Savable)this);
        this.enabled = ic.readBoolean("enabled", true);
        this.spatial = (Spatial)ic.readSavable("spatial", null);
        this.motionState.setApplyPhysicsLocal(ic.readBoolean("applyLocalPhysics", false));
        this.setUserObject(this.spatial);
    }
}

