/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control;

import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;

public abstract class AbstractPhysicsControl
implements PhysicsControl,
JmeCloneable {
    private final Quaternion tmp_inverseWorldRotation = new Quaternion();
    protected Spatial spatial;
    protected boolean enabled = true;
    protected boolean added = false;
    protected PhysicsSpace space = null;
    protected boolean applyLocal = false;

    protected abstract void createSpatialData(Spatial var1);

    protected abstract void removeSpatialData(Spatial var1);

    protected abstract void setPhysicsLocation(Vector3f var1);

    protected abstract void setPhysicsRotation(Quaternion var1);

    protected abstract void addPhysics(PhysicsSpace var1);

    protected abstract void removePhysics(PhysicsSpace var1);

    public boolean isApplyPhysicsLocal() {
        return this.applyLocal;
    }

    public void setApplyPhysicsLocal(boolean applyPhysicsLocal) {
        this.applyLocal = applyPhysicsLocal;
    }

    protected Vector3f getSpatialTranslation() {
        if (this.applyLocal) {
            return this.spatial.getLocalTranslation();
        }
        return this.spatial.getWorldTranslation();
    }

    protected Quaternion getSpatialRotation() {
        if (this.applyLocal) {
            return this.spatial.getLocalRotation();
        }
        return this.spatial.getWorldRotation();
    }

    protected void applyPhysicsTransform(Vector3f worldLocation, Quaternion worldRotation) {
        if (this.enabled && this.spatial != null) {
            Vector3f localLocation = this.spatial.getLocalTranslation();
            Quaternion localRotationQuat = this.spatial.getLocalRotation();
            if (!this.applyLocal && this.spatial.getParent() != null) {
                localLocation.set(worldLocation).subtractLocal(this.spatial.getParent().getWorldTranslation());
                localLocation.divideLocal(this.spatial.getParent().getWorldScale());
                this.tmp_inverseWorldRotation.set(this.spatial.getParent().getWorldRotation()).inverseLocal().multLocal(localLocation);
                localRotationQuat.set(worldRotation);
                this.tmp_inverseWorldRotation.set(this.spatial.getParent().getWorldRotation()).inverseLocal().mult(localRotationQuat, localRotationQuat);
                this.spatial.setLocalTranslation(localLocation);
                this.spatial.setLocalRotation(localRotationQuat);
            } else {
                this.spatial.setLocalTranslation(worldLocation);
                this.spatial.setLocalRotation(worldRotation);
            }
        }
    }

    @Deprecated
    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException();
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.spatial = (Spatial)cloner.clone((Object)this.spatial);
        this.createSpatialData(this.spatial);
    }

    public void setSpatial(Spatial spatial) {
        if (this.spatial != null && this.spatial != spatial) {
            this.removeSpatialData(this.spatial);
        } else if (this.spatial == spatial) {
            return;
        }
        this.spatial = spatial;
        if (spatial == null) {
            return;
        }
        this.createSpatialData(this.spatial);
        this.setPhysicsLocation(this.getSpatialTranslation());
        this.setPhysicsRotation(this.getSpatialRotation());
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.space != null) {
            if (enabled && !this.added) {
                if (this.spatial != null) {
                    this.setPhysicsLocation(this.getSpatialTranslation());
                    this.setPhysicsRotation(this.getSpatialRotation());
                }
                this.addPhysics(this.space);
                this.added = true;
            } else if (!enabled && this.added) {
                this.removePhysics(this.space);
                this.added = false;
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void update(float tpf) {
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    @Override
    public void setPhysicsSpace(PhysicsSpace newSpace) {
        if (this.space == newSpace) {
            return;
        }
        if (this.added) {
            this.removePhysics(this.space);
            this.added = false;
        }
        if (newSpace != null && this.isEnabled()) {
            this.addPhysics(newSpace);
            this.added = true;
        }
        this.space = newSpace;
    }

    @Override
    public PhysicsSpace getPhysicsSpace() {
        return this.space;
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule((Savable)this);
        oc.write(this.enabled, "enabled", true);
        oc.write(this.applyLocal, "applyLocalPhysics", false);
        oc.write((Savable)this.spatial, "spatial", null);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule((Savable)this);
        this.enabled = ic.readBoolean("enabled", true);
        this.spatial = (Spatial)ic.readSavable("spatial", null);
        this.applyLocal = ic.readBoolean("applyLocalPhysics", false);
    }
}

