/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SphereCollisionShape
extends CollisionShape {
    protected float radius;

    protected SphereCollisionShape() {
    }

    public SphereCollisionShape(float radius) {
        this.radius = radius;
        this.createShape();
    }

    public float getRadius() {
        return this.radius;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.radius, "radius", 0.5f);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.radius = capsule.readFloat("radius", 0.5f);
        this.createShape();
    }

    @Override
    public void setScale(Vector3f scale) {
        if (!scale.equals((Object)Vector3f.UNIT_XYZ)) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "SphereCollisionShape cannot be scaled");
        }
    }

    protected void createShape() {
        this.objectId = this.createShape(this.radius);
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Created Shape {0}", Long.toHexString(this.objectId));
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private native long createShape(float var1);
}

