/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CollisionShape
implements Savable {
    private static float defaultMargin = 0.04f;
    protected long objectId = 0L;
    protected Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    protected float margin = defaultMargin;

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long id) {
        this.objectId = id;
    }

    public void setScale(Vector3f scale) {
        this.scale.set(scale);
        this.setLocalScaling(this.objectId, scale);
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public boolean isNonMoving() {
        boolean result = this.isNonMoving(this.objectId);
        return result;
    }

    private native boolean isNonMoving(long var1);

    public float getMargin() {
        return this.getMargin(this.objectId);
    }

    private native float getMargin(long var1);

    public static void setDefaultMargin(float margin) {
        defaultMargin = margin;
    }

    public static float getDefaultMargin() {
        return defaultMargin;
    }

    public void setMargin(float margin) {
        this.setMargin(this.objectId, margin);
        this.margin = margin;
    }

    private native void setLocalScaling(long var1, Vector3f var3);

    private native void setMargin(long var1, float var3);

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write((Savable)this.scale, "scale", (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
        capsule.write(this.getMargin(), "margin", 0.0f);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.scale = (Vector3f)capsule.readSavable("scale", (Savable)new Vector3f(1.0f, 1.0f, 1.0f));
        this.margin = capsule.readFloat("margin", 0.0f);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Finalizing CollisionShape {0}", Long.toHexString(this.objectId));
        this.finalizeNative(this.objectId);
    }

    private native void finalizeNative(long var1);
}

