/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.joints.motors.RotationalLimitMotor;
import com.jme3.bullet.joints.motors.TranslationalLimitMotor;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Logger;

public class RangeOfMotion
implements Savable {
    public static final Logger logger = Logger.getLogger(RangeOfMotion.class.getName());
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private float maxX = 0.0f;
    private float minX = 0.0f;
    private float maxY = 0.0f;
    private float minY = 0.0f;
    private float maxZ = 0.0f;
    private float minZ = 0.0f;

    public RangeOfMotion() {
    }

    public RangeOfMotion(float maxX, float minX, float maxY, float minY, float maxZ, float minZ) {
        this.maxX = maxX;
        this.minX = minX;
        this.maxY = maxY;
        this.minY = minY;
        this.maxZ = maxZ;
        this.minZ = minZ;
    }

    public RangeOfMotion(float maxX, float maxY, float maxZ) {
        this.maxX = maxX;
        this.minX = -maxX;
        this.maxY = maxY;
        this.minY = -maxY;
        this.maxZ = maxZ;
        this.minZ = -maxZ;
    }

    public RangeOfMotion(float maxAngle) {
        this.maxX = maxAngle;
        this.minX = -maxAngle;
        this.maxY = maxAngle;
        this.minY = -maxAngle;
        this.maxZ = maxAngle;
        this.minZ = -maxAngle;
    }

    public RangeOfMotion(int axisIndex) {
        switch (axisIndex) {
            case 0: {
                this.maxX = 1.0f;
                this.minX = -1.0f;
                break;
            }
            case 1: {
                this.maxY = 1.0f;
                this.minY = -1.0f;
                break;
            }
            case 2: {
                this.maxZ = 1.0f;
                this.minZ = -1.0f;
                break;
            }
            default: {
                String msg = String.format("axisIndex=%d", axisIndex);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    public float getMaxRotation(int axisIndex) {
        float result;
        switch (axisIndex) {
            case 0: {
                result = this.maxX;
                break;
            }
            case 1: {
                result = this.maxY;
                break;
            }
            case 2: {
                result = this.maxZ;
                break;
            }
            default: {
                String msg = String.format("axisIndex=%d", axisIndex);
                throw new IllegalArgumentException(msg);
            }
        }
        return result;
    }

    public float getMinRotation(int axisIndex) {
        float result;
        switch (axisIndex) {
            case 0: {
                result = this.minX;
                break;
            }
            case 1: {
                result = this.minY;
                break;
            }
            case 2: {
                result = this.minZ;
                break;
            }
            default: {
                String msg = String.format("axisIndex=%d", axisIndex);
                throw new IllegalArgumentException(msg);
            }
        }
        return result;
    }

    public void setupJoint(SixDofJoint joint) {
        Vector3f lower = new Vector3f(this.minX, this.minY, this.minZ);
        Vector3f upper = new Vector3f(this.maxX, this.maxY, this.maxZ);
        RotationalLimitMotor rotX = joint.getRotationalLimitMotor(0);
        rotX.setLoLimit(lower.x);
        rotX.setHiLimit(upper.x);
        RotationalLimitMotor rotY = joint.getRotationalLimitMotor(1);
        rotY.setLoLimit(lower.y);
        rotY.setHiLimit(upper.y);
        RotationalLimitMotor rotZ = joint.getRotationalLimitMotor(2);
        rotZ.setLoLimit(lower.z);
        rotZ.setHiLimit(upper.z);
        joint.setAngularLowerLimit(lower);
        joint.setAngularUpperLimit(upper);
        for (int i = 0; i < 3; ++i) {
            RotationalLimitMotor rot = joint.getRotationalLimitMotor(i);
            rot.setMaxMotorForce(1.0E8f);
            rot.setMaxLimitForce(1.0E9f);
        }
        joint.setLinearLowerLimit(translateIdentity);
        joint.setLinearUpperLimit(translateIdentity);
        TranslationalLimitMotor tra = joint.getTranslationalLimitMotor();
        tra.setLowerLimit(translateIdentity);
        tra.setUpperLimit(translateIdentity);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule capsule = im.getCapsule((Savable)this);
        this.maxX = capsule.readFloat("maxX", 0.0f);
        this.minX = capsule.readFloat("minX", 0.0f);
        this.maxY = capsule.readFloat("maxY", 0.0f);
        this.minY = capsule.readFloat("minY", 0.0f);
        this.maxZ = capsule.readFloat("maxZ", 0.0f);
        this.minZ = capsule.readFloat("minZ", 0.0f);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule capsule = ex.getCapsule((Savable)this);
        capsule.write(this.maxX, "maxX", 0.0f);
        capsule.write(this.minX, "minX", 0.0f);
        capsule.write(this.maxY, "maxY", 0.0f);
        capsule.write(this.minY, "minY", 0.0f);
        capsule.write(this.maxZ, "maxZ", 0.0f);
        capsule.write(this.minZ, "minZ", 0.0f);
    }
}

