/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.command.file;

import java.io.File;
import java.io.IOException;
import org.jledit.ConsoleEditor;
import org.jledit.command.Command;
import org.jledit.command.undo.UndoContext;
import org.jledit.command.undo.UndoContextAware;

public class FileSaveCommand
implements Command,
UndoContextAware {
    private final ConsoleEditor editor;
    private UndoContext undoContext;

    public FileSaveCommand(ConsoleEditor editor) {
        this.editor = editor;
    }

    @Override
    public void execute() {
        if (!this.editor.isReadOnly()) {
            try {
                if (this.editor.getFile() == null) {
                    String fileName = this.editor.readLine("Save to file:");
                    this.editor.save(new File(fileName));
                } else {
                    this.editor.save(null);
                }
                this.undoContext.clear();
                this.editor.setDirty(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public UndoContext getUndoContext() {
        return this.undoContext;
    }

    @Override
    public void setUndoContext(UndoContext undoContext) {
        this.undoContext = undoContext;
    }
}

